/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.ui.AMenuUtil;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitIO;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class AActionGroup
extends AbstractAction {
    protected LinkedList<Action> mActions = new LinkedList();
    protected boolean mGroupByFirstWord = false;

    public AActionGroup() {
    }

    public AActionGroup(Iterator<Action> actions) {
        this.addActions(actions);
    }

    public AActionGroup(String name) {
        this.putValue("Name", name);
    }

    public AActionGroup(String name, Iterator<Action> actions) {
        this(actions);
        this.putValue("Name", name);
    }

    public void addActions(Stream<Action> actions) {
        actions.forEach(action -> this.mActions.add((Action)action));
    }

    public void addActions(Iterator<Action> actions) {
        AUtil.addAll(this.mActions, actions);
    }

    public IterableIterator<Action> getActions() {
        return new AIterableItr(this.mActions.iterator());
    }

    public void addAction(Action a) {
        this.mActions.add(a);
    }

    public int getActionCount() {
        return this.mActions.size();
    }

    public JPopupMenu getMenu() {
        JPopupMenu menu = new JPopupMenu();
        for (Action a : this.getActions()) {
            menu.add(a);
        }
        return menu;
    }

    public JMenu getJMenu() {
        JMenu menu = new JMenu("" + this.getValue("Name"));
        if (this.getValue("SmallIcon") != null) {
            menu.setIcon((Icon)this.getValue("SmallIcon"));
        }
        LinkedList buffer = new LinkedList();
        for (Action subAction : this.getActions()) {
            if (subAction == null) {
                if (this.getGroupByFirstWord()) {
                    buffer = AMenuUtil.groupByFirstWord(buffer.iterator());
                }
                for (JMenuItem mi : buffer) {
                    menu.add(mi);
                }
                menu.addSeparator();
                continue;
            }
            buffer.add(ObjectActionRegistry.getJMenuItem(subAction));
        }
        if (this.getGroupByFirstWord()) {
            buffer = AMenuUtil.groupByFirstWord(buffer.iterator());
        }
        for (JMenuItem mi : buffer) {
            menu.add(mi);
        }
        if (OrbitIO.getGuiWorkspace() != null) {
            OrbitIO.getGuiWorkspace().beautify(menu);
        }
        return menu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JPopupMenu menu = this.getMenu();
        Window w = UIUtil.getActiveWindow();
        Dimension dimOn = w == null ? Toolkit.getDefaultToolkit().getScreenSize() : w.getSize();
        Dimension dimMenu = menu.getSize();
        int x = (dimOn.width - dimMenu.width) / 2;
        int y = (dimOn.height - dimMenu.height) / 2;
        OrbitIO.getApp().getWorkspace().beautify(menu);
        menu.show(w, x, y);
    }

    public void addSeparator() {
        this.mActions.add(null);
    }

    public void setGroupByFirstWord(boolean enable) {
        this.mGroupByFirstWord = enable;
    }

    public boolean getGroupByFirstWord() {
        return this.mGroupByFirstWord;
    }
}

