/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.ui.GridBagManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ABshEditorPane
extends JPanel {
    static final String PROP_DEBUG = ABshEditorPane.class.getName() + ".debug";
    static JavaEditorFactory mExternalEditorFactory = null;
    protected JavaEditor mEditor = null;

    public static void registerExternalEditorFactory(JavaEditorFactory factory) {
        mExternalEditorFactory = factory;
    }

    public ABshEditorPane() {
        GridBagManager l = GridBagManager.layout((Container)this);
        this.mEditor = this.createExternalEditor();
        if (this.mEditor == null) {
            this.mEditor = this.createInternalEditor();
        }
        l.add((Component)this.mEditor.getEditor(), (GridBagConstraints)GridBagManager.FILLALL.noInsets());
    }

    public JavaEditor createInternalEditor() {
        return new InternalEditor();
    }

    public void setText(String text) {
        this.mEditor.setText(text);
    }

    public String getText() {
        return this.mEditor.getText();
    }

    public JavaEditor createExternalEditor() {
        if (mExternalEditorFactory != null) {
            try {
                return mExternalEditorFactory.create();
            }
            catch (Throwable e) {
                ALog.logError((Throwable)e, (String)"Exception in external editor factory.", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static class InternalEditor
    extends JavaEditor {
        protected JTextArea mTextArea = new JTextArea();

        public InternalEditor() {
            this.mTextArea.setRows(4);
            this.mTextArea.setTabSize(2);
        }

        @Override
        public String getText() {
            return this.mTextArea.getText();
        }

        @Override
        public void setText(String text) {
            this.mTextArea.setText(text);
        }

        @Override
        public JComponent getEditor() {
            return this.mTextArea;
        }
    }

    public static abstract class JavaEditor {
        public abstract void setText(String var1);

        public abstract String getText();

        public abstract JComponent getEditor();
    }

    public static interface JavaEditorFactory {
        public JavaEditor create();
    }
}

