/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.ui.AList;
import com.sigrity.acl.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;

public abstract class AButtonListCellRenderer<T>
extends JPanel
implements ListCellRenderer<T> {
    protected AbstractButton mBtn;
    protected JLabel mLbl = new JLabel();

    public AButtonListCellRenderer() {
        this.mBtn = this.createButton();
        this.setLayout(new FlowLayout(0, 0, 0));
        this.mBtn.setOpaque(false);
        this.mBtn.setBackground(new Color(0, 0, 0, 0));
        this.add(this.mBtn);
        this.add(this.mLbl);
    }

    protected abstract AbstractButton createButton();

    @Override
    public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof AList.AListItem) {
            AList.AListItem v = (AList.AListItem)value;
            this.mLbl.setText(v.getText());
            this.mLbl.setIcon(v.getIcon());
            this.mLbl.setToolTipText(v.getToolTip());
        } else {
            this.mLbl.setText("" + value);
        }
        this.mBtn.setSelected(isSelected);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        UIUtil.setEnabled((Container)this, (boolean)list.isEnabled());
        this.mLbl.setFont(list.getFont());
        return this;
    }

    public void setText(String s) {
        this.mLbl.setText(s);
    }

    public static class RadioButton<T>
    extends AButtonListCellRenderer<T> {
        @Override
        protected AbstractButton createButton() {
            return new JRadioButton();
        }
    }

    public static class CheckBox<T>
    extends AButtonListCellRenderer<T> {
        @Override
        protected AbstractButton createButton() {
            return new JCheckBox();
        }
    }
}

