/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;

public class ACanvasInfo {
    protected String message;
    protected APoint2D p;
    protected JTextPane pane;
    protected boolean showMe = false;
    Overlay myOverlay;
    boolean mDrawing = false;
    DesignView2D mView;

    public void show(DesignView2D view) {
        this.pane = new JTextPane();
        this.mView = view;
        this.myOverlay = new Overlay();
        this.mView.addOverlay(this.myOverlay);
    }

    public void message(APoint2D p, String message) {
        this.p = p;
        this.message = message;
        this.showMe = true;
        this.myOverlay.repaint();
    }

    public void hide() {
        this.showMe = false;
    }

    Polygon callOut(Rectangle r) {
        int pointl = r.height / 3;
        int pointw = r.width / 6;
        int pointxc = r.width / 3 * 2;
        double angle = Math.toDegrees(270.0);
        int arcsize = 20;
        Polygon p = new Polygon();
        p.addPoint(r.x + arcsize, r.y);
        int xc = r.x + r.width - arcsize;
        int yc = r.y + arcsize;
        double start = 270.0;
        this.addArc(p, xc, yc, arcsize, start, 90.0);
        xc = r.x + r.width - arcsize;
        yc = r.y + r.height - arcsize;
        start = 0.0;
        this.addArc(p, xc, yc, arcsize, start, 90.0);
        p.addPoint(r.x + pointxc + pointw / 2, r.y + r.height);
        int dx = (int)((double)pointl * Math.cos(angle));
        int dy = (int)((double)pointl * Math.sin(angle));
        p.addPoint(r.x + pointxc + dx, r.y + r.height + dy);
        p.addPoint(r.x + pointxc - pointw / 2, r.y + r.height);
        xc = r.x + arcsize;
        yc = r.y + r.height - arcsize;
        start = 90.0;
        this.addArc(p, xc, yc, arcsize, start, 90.0);
        xc = r.x + arcsize;
        yc = r.y + arcsize;
        start = 180.0;
        this.addArc(p, xc, yc, arcsize, start, 90.0);
        p.translate(dx, -dy);
        return p;
    }

    protected void addArc(Polygon p, int x, int y, int radius, double start, double sweep) {
        int numsegs = 8;
        double da = sweep / (double)numsegs;
        for (int i = 0; i < 8; ++i) {
            double thisAngle = Math.toRadians(start + da * (double)i);
            int dx = (int)(Math.cos(thisAngle) * (double)radius);
            int dy = (int)(Math.sin(thisAngle) * (double)radius);
            p.addPoint(x + dx, y + dy);
        }
    }

    public class Overlay
    extends JComponent {
        protected DesignCanvas2D.XForm w2s;
        Graphics2D g;

        public Overlay() {
            this.setOpaque(false);
            this.setBackground(new Color(0, 0, 0, 0));
            this.setDoubleBuffered(true);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            ACanvasInfo.this.pane.setVisible(false);
            if (ACanvasInfo.this.mDrawing) {
                return;
            }
            if (!ACanvasInfo.this.showMe) {
                return;
            }
            ACanvasInfo.this.mDrawing = true;
            this.g = (Graphics2D)graphics;
            DesignView2D v2 = ACanvasInfo.this.mView;
            this.w2s = v2.getCanvas().getXForm();
            DesignCanvas2D.XForm xform = v2.getCanvas().getXForm();
            Point sP = xform.getScreenPt(ACanvasInfo.this.p);
            ACanvasInfo.this.pane.setOpaque(false);
            ACanvasInfo.this.pane.setBackground(new Color(0, 0, 0, 0));
            ACanvasInfo.this.pane.setEditable(false);
            HTMLEditorKit ek = new HTMLEditorKit();
            ACanvasInfo.this.pane.setEditorKit(ek);
            String st = "<style type='text/css'>body {color: blue; text-align: left; font-weight:bold; font-size: 12pt; font-family: arial, sans-serif};</style><body>" + ACanvasInfo.this.message + "</body>";
            ACanvasInfo.this.pane.setText(st);
            this.add(ACanvasInfo.this.pane);
            Dimension d = ACanvasInfo.this.pane.getPreferredSize();
            int xSize = (int)((double)d.width * 1.5);
            int ySize = d.height;
            Rectangle r = new Rectangle(sP.x - xSize, sP.y - ySize, xSize, ySize);
            int newXSize = r.width;
            int newYSize = r.height;
            ACanvasInfo.this.pane.setSize(newXSize, newYSize);
            ACanvasInfo.this.pane.setLocation(sP.x - newXSize + 22, sP.y - newYSize);
            this.g.setColor(new Color(255, 255, 255, 200));
            this.g.fill(r);
            this.g.setColor(new Color(0, 0, 0, 200));
            this.g.draw(r);
            ACanvasInfo.this.pane.setVisible(true);
            ACanvasInfo.this.mDrawing = false;
        }
    }
}

