/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.APair;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.ProcessingIterator;
import com.sigrity.acl.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class ACheckBoxList<T>
extends JList<T> {
    protected HashSet<Integer> mCheckedIndexes = new HashSet();
    protected LinkedList<CheckListener<T>> mListeners = new LinkedList();

    public ACheckBoxList() {
        this.addMouseListener(new MouseHandler());
        this.addKeyListener(new KeyHandler());
        this.setCellRenderer(new CheckBoxListCellRenderer<T>(){

            @Override
            public Boolean isChecked(int idx) {
                return ACheckBoxList.this.isChecked(idx);
            }
        });
    }

    public ACheckBoxList(ListModel<T> dataModel) {
        super(dataModel);
        this.addMouseListener(new MouseHandler());
        this.addKeyListener(new KeyHandler());
        this.setCellRenderer(new /* invalid duplicate definition of identical inner class */);
    }

    public void clearChecked() {
        this.mCheckedIndexes.clear();
    }

    public boolean isChecked(int idx) {
        return this.mCheckedIndexes.contains(idx);
    }

    public void checkAll(boolean checked) {
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            this.setChecked(i, checked);
            UIUtil.repaintListItem((JList)this, (int)i, (boolean)false);
        }
    }

    public void setChecked(int idx, boolean checked) {
        if (checked) {
            if (this.mCheckedIndexes.add(idx)) {
                this.fireCheckChanged(idx);
            }
        } else if (this.mCheckedIndexes.remove(idx)) {
            this.fireCheckChanged(idx);
        }
    }

    public void toggleChecked(int idx) {
        this.setChecked(idx, !this.isChecked(idx));
        UIUtil.repaintListItem((JList)this, (int)idx, (boolean)false);
    }

    public IterableIterator<T> getCheckedItems() {
        return new ProcessingIterator<APair<Integer, T>, T>((Iterator)this.getIndexedItems()){

            protected T process(APair<Integer, T> idxItem) {
                return ACheckBoxList.this.isChecked((Integer)idxItem.first) ? idxItem.second : null;
            }
        };
    }

    public IterableIterator<APair<Integer, T>> getIndexedItems() {
        return new IterableIterator<APair<Integer, T>>(){
            int nextIdx = 0;

            public boolean hasNext() {
                return this.nextIdx < ACheckBoxList.this.getModel().getSize();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public Iterator<APair<Integer, T>> iterator() {
                return this;
            }

            public APair<Integer, T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return APair.create((Object)this.nextIdx, ACheckBoxList.this.getModel().getElementAt(this.nextIdx++));
            }
        };
    }

    public boolean addCheckListener(CheckListener<T> listener) {
        if (this.mListeners.contains(listener)) {
            return false;
        }
        return this.mListeners.add(listener);
    }

    public boolean removeCheckListener(CheckListener<T> listener) {
        return this.mListeners.remove(listener);
    }

    protected void fireCheckChanged(int idx) {
        for (CheckListener checkListener : this.mListeners) {
            checkListener.checkChanged(idx);
        }
    }

    public static abstract class CheckBoxListCellRenderer<T>
    extends JPanel
    implements ListCellRenderer<T> {
        protected JCheckBox mCBSel = new JCheckBox();
        protected JLabel mLabel = new JLabel();

        public CheckBoxListCellRenderer() {
            this.setLayout(new FlowLayout(0, 0, 0));
            this.add(this.mCBSel);
            this.mCBSel.setOpaque(false);
            this.mCBSel.setBackground(new Color(0, 0, 0, 0));
            this.add(this.mLabel);
        }

        public abstract Boolean isChecked(int var1);

        @Override
        public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
            this.mCBSel.setSelected(this.isChecked(index));
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.mLabel.setText(value == null ? "" : value.toString());
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    public static interface CheckListener<T> {
        public void checkChanged(int var1);
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 1) {
                return;
            }
            Point pt = e.getPoint();
            int index = ACheckBoxList.this.locationToIndex(pt);
            if (index < 0) {
                return;
            }
            Object value = ACheckBoxList.this.getModel().getElementAt(index);
            if (value == null) {
                return;
            }
            ListCellRenderer renderer = ACheckBoxList.this.getCellRenderer();
            if (renderer instanceof CheckBoxListCellRenderer) {
                CheckBoxListCellRenderer cbcr = (CheckBoxListCellRenderer)renderer;
                Rectangle cellBounds = ACheckBoxList.this.getCellBounds(index, index);
                cbcr.getListCellRendererComponent(ACheckBoxList.this, value, index, false, false);
                cbcr.setBounds(0, 0, cellBounds.width, cellBounds.height);
                Point rendererPoint = new Point(pt);
                rendererPoint.translate(-cellBounds.x, -cellBounds.y);
                if (cbcr.getComponentAt(rendererPoint) != cbcr.mCBSel) {
                    return;
                }
                ACheckBoxList.this.toggleChecked(index);
            }
        }
    }

    protected class KeyHandler
    extends KeyAdapter {
        protected KeyHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            super.keyTyped(e);
            if (e.isConsumed() || e.getKeyChar() != ' ') {
                return;
            }
            for (int i : ACheckBoxList.this.getSelectedIndices()) {
                ACheckBoxList.this.toggleChecked(i);
            }
        }
    }
}

