/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.ui.ACheckBoxList;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class ACheckBoxList2<T>
extends JList<T> {
    protected HashSet<T> mChecked = new HashSet();
    protected Function<T, Boolean> mIsChecked = item -> this.mChecked.contains(item);
    protected BiConsumer<T, Boolean> mSetChecked = (item, checked) -> {
        if (checked.booleanValue()) {
            this.mChecked.add(item);
        } else {
            this.mChecked.remove(item);
        }
    };

    public ACheckBoxList2() {
        this.addMouseListener(new MouseHandler());
        this.addKeyListener(new KeyHandler());
        this.setCellRenderer(new ACheckBoxList.CheckBoxListCellRenderer<T>(){

            @Override
            public Boolean isChecked(int idx) {
                return ACheckBoxList2.this.isChecked(idx);
            }
        });
    }

    public ACheckBoxList2(Stream<T> data) {
        this();
        DefaultListModel model = new DefaultListModel();
        data.forEach(item -> model.addElement(item));
        this.setModel(model);
    }

    public ACheckBoxList2(Stream<T> data, Function<T, Boolean> isChecked, BiConsumer<T, Boolean> setChecked) {
        this(data);
        this.mIsChecked = isChecked;
        this.mSetChecked = setChecked;
    }

    public boolean isChecked(T item) {
        return this.mIsChecked.apply(item);
    }

    public void setChecked(T item, boolean checked) {
        this.mSetChecked.accept(item, checked);
    }

    public boolean isChecked(int idx) {
        return this.mIsChecked.apply(this.getModel().getElementAt(idx));
    }

    public void setCheck(int idx, boolean check) {
        if (this.isChecked(idx) == check) {
            return;
        }
        this.mSetChecked.accept(this.getModel().getElementAt(idx), check);
        Rectangle bounds = this.getCellBounds(idx, idx);
        if (bounds != null) {
            this.repaint(bounds);
        }
    }

    public void toggleChecked(int idx) {
        this.setCheck(idx, !this.isChecked(idx));
    }

    public void setAllCheck(boolean check) {
        IntStream.range(0, this.getModel().getSize()).forEach(i -> this.setCheck(i, check));
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 1) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(e)) {
                Object value;
                Point pt = e.getPoint();
                int index = ACheckBoxList2.this.locationToIndex(pt);
                Object t = value = index < 0 ? null : (Object)ACheckBoxList2.this.getModel().getElementAt(index);
                if (value != null) {
                    ListCellRenderer renderer = ACheckBoxList2.this.getCellRenderer();
                    if (!(renderer instanceof ACheckBoxList.CheckBoxListCellRenderer)) {
                        return;
                    }
                    ACheckBoxList.CheckBoxListCellRenderer cbcr = (ACheckBoxList.CheckBoxListCellRenderer)renderer;
                    Rectangle cellBounds = ACheckBoxList2.this.getCellBounds(index, index);
                    cbcr.getListCellRendererComponent(ACheckBoxList2.this, value, index, false, false);
                    cbcr.setBounds(0, 0, cellBounds.width, cellBounds.height);
                    Point rendererPoint = new Point(pt);
                    rendererPoint.translate(-cellBounds.x, -cellBounds.y);
                    if (cbcr.getComponentAt(rendererPoint) == cbcr.mCBSel) {
                        ACheckBoxList2.this.toggleChecked(index);
                    }
                }
            } else if (SwingUtilities.isRightMouseButton(e)) {
                int[] selIdxs;
                boolean anyChecked;
                if (ACheckBoxList2.this.getModel() == null || ACheckBoxList2.this.getModel().getSize() == 0) {
                    return;
                }
                JPopupMenu pm = new JPopupMenu();
                final int totalCount = ACheckBoxList2.this.getModel().getSize();
                boolean anyUnchecked = IntStream.range(0, totalCount).anyMatch(i -> !ACheckBoxList2.this.isChecked(i));
                if (anyUnchecked) {
                    pm.add(new AbstractAction("Check all"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            IntStream.range(0, totalCount).filter(i -> !ACheckBoxList2.this.isChecked(i)).forEach(i -> ACheckBoxList2.this.setCheck(i, true));
                        }
                    });
                }
                if (anyChecked = IntStream.range(0, totalCount).anyMatch(i -> ACheckBoxList2.this.isChecked(i))) {
                    pm.add(new AbstractAction("Uncheck all"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            IntStream.range(0, totalCount).filter(i -> ACheckBoxList2.this.isChecked(i)).forEach(i -> ACheckBoxList2.this.setCheck(i, false));
                        }
                    });
                }
                if ((selIdxs = ACheckBoxList2.this.getSelectedIndices()).length > 0) {
                    boolean anySelChecked;
                    boolean anySelUnchecked = Arrays.stream(selIdxs).anyMatch(i -> !ACheckBoxList2.this.isChecked(i));
                    if (anySelUnchecked) {
                        pm.add(new AbstractAction("Check selected"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Arrays.stream(selIdxs).filter(i -> !ACheckBoxList2.this.isChecked(i)).forEach(i -> ACheckBoxList2.this.setCheck(i, true));
                            }
                        });
                    }
                    if (anySelChecked = Arrays.stream(selIdxs).anyMatch(i -> ACheckBoxList2.this.isChecked(i))) {
                        pm.add(new AbstractAction("Uncheck selected"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Arrays.stream(selIdxs).filter(i -> ACheckBoxList2.this.isChecked(i)).forEach(i -> ACheckBoxList2.this.setCheck(i, false));
                            }
                        });
                    }
                }
                pm.show(ACheckBoxList2.this, e.getX(), e.getY());
            }
        }
    }

    protected class KeyHandler
    extends KeyAdapter {
        protected KeyHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            super.keyTyped(e);
            if (e.isConsumed() || e.getKeyChar() != ' ') {
                return;
            }
            for (int i : ACheckBoxList2.this.getSelectedIndices()) {
                ACheckBoxList2.this.toggleChecked(i);
            }
        }
    }
}

