/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ACheckBoxTree
extends MouseAdapter
implements TreeSelectionListener {
    protected CheckTreeSelectionModel mSelectionModel;
    protected JTree mTree = new JTree();
    protected ArrayList<CheckListener> mCheckListeners = new ArrayList();
    int mHotspot;

    public ACheckBoxTree(JTree tree) {
        this.mHotspot = new JCheckBox().getPreferredSize().width;
        this.mTree = tree;
        this.mSelectionModel = new CheckTreeSelectionModel(tree.getModel());
        tree.setCellRenderer(new CheckTreeCellRenderer(tree.getCellRenderer(), this.mSelectionModel));
        tree.addMouseListener(this);
        this.mSelectionModel.addTreeSelectionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent me) {
        TreePath path = this.mTree.getPathForLocation(me.getX(), me.getY());
        if (path == null) {
            return;
        }
        if (me.getX() > this.mTree.getPathBounds((TreePath)path).x + this.mHotspot) {
            return;
        }
        boolean selected = this.mSelectionModel.isPathSelected(path, true);
        this.mSelectionModel.removeTreeSelectionListener(this);
        try {
            if (selected) {
                this.mSelectionModel.removeSelectionPath(path);
                this.fireCheckListener(path, false);
            } else {
                this.mSelectionModel.addSelectionPath(path);
                this.fireCheckListener(path, true);
            }
        }
        finally {
            this.mSelectionModel.addTreeSelectionListener(this);
            this.mTree.treeDidChange();
        }
    }

    public CheckTreeSelectionModel getSelectionModel() {
        return this.mSelectionModel;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.mTree.treeDidChange();
    }

    public void addCheckListener(CheckListener listener) {
        this.mCheckListeners.add(listener);
    }

    public void removeCheckListener(CheckListener listener) {
        this.mCheckListeners.remove(listener);
    }

    protected void fireCheckListener(TreePath path, boolean checked) {
        for (CheckListener l : this.mCheckListeners) {
            l.checkChanged(path, checked);
        }
    }

    public static class CheckTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected CheckTreeSelectionModel mSelectionModel;
        protected TreeCellRenderer mDelegate;
        protected JCheckBox mCheckBox = new JCheckBox();

        public CheckTreeCellRenderer(TreeCellRenderer delegate, CheckTreeSelectionModel selectionModel) {
            this.mDelegate = delegate;
            this.mSelectionModel = selectionModel;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.setBackground(new Color(0, 0, 0, 0));
            this.mCheckBox.setOpaque(false);
            this.mCheckBox.setBackground(new Color(0, 0, 0, 0));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component renderer = this.mDelegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            TreePath path = tree.getPathForRow(row);
            if (path != null) {
                if (this.mSelectionModel.isPathSelected(path, true)) {
                    this.mCheckBox.setSelected(true);
                } else {
                    this.mCheckBox.setSelected(this.mSelectionModel.isPartiallySelected(path));
                }
            }
            this.removeAll();
            this.add((Component)this.mCheckBox, "West");
            this.add(renderer, "Center");
            return this;
        }
    }

    public static class CheckTreeSelectionModel
    extends DefaultTreeSelectionModel {
        private TreeModel mModel;

        public CheckTreeSelectionModel(TreeModel model) {
            this.mModel = model;
            this.setSelectionMode(4);
        }

        public boolean isPartiallySelected(TreePath path) {
            if (this.isPathSelected(path, true)) {
                return false;
            }
            TreePath[] selectionPaths = this.getSelectionPaths();
            if (selectionPaths == null) {
                return false;
            }
            for (int j = 0; j < selectionPaths.length; ++j) {
                if (!this.isDescendant(selectionPaths[j], path)) continue;
                return true;
            }
            return false;
        }

        public boolean isPathSelected(TreePath path, boolean dig) {
            if (!dig) {
                return super.isPathSelected(path);
            }
            while (path != null && !super.isPathSelected(path)) {
                path = path.getParentPath();
            }
            return path != null;
        }

        private boolean isDescendant(TreePath path1, TreePath path2) {
            Object[] obj1 = path1.getPath();
            Object[] obj2 = path2.getPath();
            for (int i = 0; i < obj2.length; ++i) {
                if (obj1[i] == obj2[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public void setSelectionPaths(TreePath[] pPaths) {
            throw new UnsupportedOperationException("not implemented yet!!!");
        }

        @Override
        public void addSelectionPaths(TreePath[] paths) {
            TreePath path;
            int i;
            for (i = 0; i < paths.length; ++i) {
                path = paths[i];
                TreePath[] selectionPaths = this.getSelectionPaths();
                if (selectionPaths == null) break;
                ArrayList<TreePath> toBeRemoved = new ArrayList<TreePath>();
                for (int j = 0; j < selectionPaths.length; ++j) {
                    if (!this.isDescendant(selectionPaths[j], path)) continue;
                    toBeRemoved.add(selectionPaths[j]);
                }
                super.removeSelectionPaths(toBeRemoved.toArray(new TreePath[0]));
            }
            for (i = 0; i < paths.length; ++i) {
                path = paths[i];
                TreePath temp = null;
                while (this.areSiblingsSelected(path)) {
                    temp = path;
                    if (path.getParentPath() == null) break;
                    path = path.getParentPath();
                }
                if (temp != null) {
                    if (temp.getParentPath() != null) {
                        this.addSelectionPath(temp.getParentPath());
                        continue;
                    }
                    if (!this.isSelectionEmpty()) {
                        this.removeSelectionPaths(this.getSelectionPaths());
                    }
                    super.addSelectionPaths(new TreePath[]{temp});
                    continue;
                }
                super.addSelectionPaths(new TreePath[]{path});
            }
        }

        private boolean areSiblingsSelected(TreePath path) {
            TreePath parent = path.getParentPath();
            if (parent == null) {
                return true;
            }
            Object node = path.getLastPathComponent();
            Object parentNode = parent.getLastPathComponent();
            int childCount = this.mModel.getChildCount(parentNode);
            for (int i = 0; i < childCount; ++i) {
                Object childNode = this.mModel.getChild(parentNode, i);
                if (childNode == node || this.isPathSelected(parent.pathByAddingChild(childNode))) continue;
                return false;
            }
            return true;
        }

        @Override
        public void removeSelectionPaths(TreePath[] paths) {
            if (paths == null) {
                return;
            }
            for (int i = 0; i < paths.length; ++i) {
                TreePath path = paths[i];
                if (path.getPathCount() == 1) {
                    super.removeSelectionPaths(new TreePath[]{path});
                    continue;
                }
                this.toggleRemoveSelection(path);
            }
        }

        private void toggleRemoveSelection(TreePath path) {
            TreePath parent;
            Stack<TreePath> stack = new Stack<TreePath>();
            for (parent = path.getParentPath(); parent != null && !this.isPathSelected(parent); parent = parent.getParentPath()) {
                stack.push(parent);
            }
            if (parent != null) {
                stack.push(parent);
            } else {
                super.removeSelectionPaths(new TreePath[]{path});
                return;
            }
            while (!stack.isEmpty()) {
                TreePath temp = (TreePath)stack.pop();
                TreePath peekPath = stack.isEmpty() ? path : (TreePath)stack.peek();
                Object node = temp.getLastPathComponent();
                Object peekNode = peekPath.getLastPathComponent();
                int childCount = this.mModel.getChildCount(node);
                for (int i = 0; i < childCount; ++i) {
                    Object childNode = this.mModel.getChild(node, i);
                    if (childNode == peekNode) continue;
                    super.addSelectionPaths(new TreePath[]{temp.pathByAddingChild(childNode)});
                }
            }
            super.removeSelectionPaths(new TreePath[]{parent});
        }
    }

    public static interface CheckListener {
        public void checkChanged(TreePath var1, boolean var2);
    }
}

