/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.APatternColor;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AColorChooserDlg
extends ADialog {
    protected Color mReturnColor = null;
    protected boolean mShowOpacity = true;
    protected JColorChooser mColorPanel;
    protected JPanel mOpacityPanel;
    protected JSlider mSlideOpacity;
    protected ColorPreviewArea mOldColor;
    protected ColorPreviewArea mNewColor;
    protected JButton mBtnEmpty;
    protected JButton mBtnReset;
    protected JButton mBtnOK;
    protected JButton mBtnCancel;
    protected boolean ignoreColorChangeEvent = false;

    public static AColorChooserDlg createDialog(Component owner, String title, Color initialColor) {
        AColorChooserDlg d = null;
        Window w = UIUtil.getParentWindow((Component)owner);
        d = w instanceof Dialog ? new AColorChooserDlg((Dialog)w) : (w instanceof Frame ? new AColorChooserDlg((Frame)w) : new AColorChooserDlg());
        d.setTitle(title);
        d.setInitialColor(initialColor);
        return d;
    }

    public static AColorChooserDlg createDialog(Component owner, String title, APatternColor initialColor) {
        return AColorChooserDlg.createDialog(owner, title, initialColor == null ? null : initialColor.getColor());
    }

    protected AColorChooserDlg(Dialog owner) {
        super(owner);
        this.init();
    }

    protected AColorChooserDlg(Frame owner) {
        super(owner);
        this.init();
    }

    protected AColorChooserDlg() {
        this.init();
    }

    private void init() {
        JPanel p;
        GridBagManager l = new GridBagManager(this.getContentPane());
        this.mColorPanel = new JColorChooser();
        this.mColorPanel.setPreviewPanel(new JPanel());
        this.mColorPanel.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AColorChooserDlg.this.userChangedColor();
            }
        });
        AbstractColorChooserPanel[] panels = this.mColorPanel.getChooserPanels();
        if (panels.length > 0 && panels[0].getComponentCount() > 0 && panels[0].getComponent(0) instanceof JPanel && (p = (JPanel)panels[0].getComponent(0)).getComponentCount() > 2 && p.getComponent(2) instanceof JPanel) {
            p.remove(2);
            p.remove(1);
        }
        l.add((Component)this.mColorPanel, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.newline();
        this.mOpacityPanel = new JPanel();
        l.push((Container)this.mOpacityPanel, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.add("Opacity:");
        this.mSlideOpacity = new JSlider(0, 100);
        this.mSlideOpacity.setMajorTickSpacing(10);
        this.mSlideOpacity.setMinorTickSpacing(1);
        this.mSlideOpacity.setPaintTicks(true);
        this.mSlideOpacity.setPaintLabels(true);
        this.mSlideOpacity.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AColorChooserDlg.this.mSlideOpacity.getValueIsAdjusting()) {
                    return;
                }
                AColorChooserDlg.this.userChangedColor();
            }
        });
        l.add((Component)this.mSlideOpacity, (GridBagConstraints)GridBagManager.FILLX);
        l.pop();
        l.newline();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.add("Old:");
        this.mOldColor = new ColorPreviewArea();
        l.add((Component)this.mOldColor, (GridBagConstraints)GridBagManager.FILLX);
        l.add("New:");
        this.mNewColor = new ColorPreviewArea();
        l.add((Component)this.mNewColor, (GridBagConstraints)GridBagManager.FILLX);
        l.pop();
        l.newline();
        l.addFillY();
        l.newline();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        this.mBtnEmpty = new JButton("Remove Color");
        l.add((Component)this.mBtnEmpty, (GridBagConstraints)GridBagManager.LEFT);
        this.mBtnEmpty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AColorChooserDlg.this.mReturnColor = null;
                UIUtil.closeWindow((Window)((Object)AColorChooserDlg.this));
            }
        });
        l.addFillX();
        this.mBtnReset = new JButton("Reset");
        l.add((Component)this.mBtnReset, (GridBagConstraints)GridBagManager.RIGHT);
        this.mBtnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AColorChooserDlg.this.mColorPanel.setColor(AColorChooserDlg.this.mOldColor.getColor());
            }
        });
        this.mBtnOK = new JButton("OK");
        l.add((Component)this.mBtnOK, (GridBagConstraints)GridBagManager.RIGHT);
        this.mBtnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AColorChooserDlg.this.mReturnColor = AColorChooserDlg.this.mNewColor.getColor();
                UIUtil.closeWindow((Window)((Object)AColorChooserDlg.this));
            }
        });
        this.mBtnCancel = new JButton("Cancel");
        l.add((Component)this.mBtnCancel, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)this.mBtnCancel, (JButton)this.mBtnOK);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
    }

    public void setInitialColor(Color c) {
        this.ignoreColorChangeEvent = true;
        this.mColorPanel.setColor(c);
        this.ignoreColorChangeEvent = false;
        this.mOldColor.setColor(c);
        this.mNewColor.setColor(c);
        if (c != null) {
            double sliderValue = 100.0 * (double)c.getAlpha() / 255.0;
            this.mSlideOpacity.setValue((int)sliderValue);
        } else {
            this.mSlideOpacity.setValue(50);
        }
    }

    public void setShowOpacity(boolean show) {
        this.mShowOpacity = show;
        this.mOpacityPanel.setVisible(show);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
    }

    public Color doModal() {
        this.setModal(true);
        this.setVisible(true);
        return this.mReturnColor;
    }

    protected void userChangedColor() {
        if (this.ignoreColorChangeEvent) {
            return;
        }
        Color c = this.mColorPanel.getColor();
        double opacity = (double)this.mSlideOpacity.getValue() / 100.0 * 255.0;
        Color c2 = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)opacity);
        this.mNewColor.setColor(c2);
    }

    public static class ColorPreviewArea
    extends JPanel {
        protected Color[] SampleColors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.BLACK};
        protected Color mColor;

        public ColorPreviewArea() {
            this.setPreferredSize(new Dimension(26, 26));
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        }

        public ColorPreviewArea(Color color) {
            this();
            this.mColor = color;
        }

        public void setColor(Color color) {
            this.mColor = color;
            this.repaint();
        }

        public Color getColor() {
            return this.mColor;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int y;
            int x;
            int i;
            super.paintComponent(graphics);
            Graphics2D g = (Graphics2D)graphics;
            Shape oldClip = g.getClip();
            Rectangle b = UIUtil.getBoundsMinusInsets((JComponent)this);
            b = SwingUtilities.convertRectangle(this.getParent(), b, this);
            g.setClip(b);
            int dx = b.width / this.SampleColors.length + 1;
            int dy = b.height / 3;
            for (i = 0; i < this.SampleColors.length; ++i) {
                g.setColor(this.SampleColors[i]);
                x = b.x + dx * i;
                y = b.y;
                g.fillRect(x, y, dx, dy);
            }
            g.setColor(this.mColor);
            g.fillRect(b.x, b.y, b.width, b.height);
            dy = dy / 2 - 1;
            for (i = 0; i < this.SampleColors.length; ++i) {
                g.setColor(this.SampleColors[i]);
                x = b.x + dx * i;
                y = b.y;
                g.fillRect(x, y, dx, dy);
            }
            g.setClip(oldClip);
        }
    }
}

