/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class AComponentTitledBorder
implements Border {
    protected JComponent mOwner;
    protected Component mTitleComponent;
    protected Border mBaseBorder;
    protected int mTitleXInset = 6;
    protected int mTitleYInset = 0;
    protected MouseListener mMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent me) {
            AComponentTitledBorder.this.handleMouseEvent(me);
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            AComponentTitledBorder.this.handleMouseEvent(me);
        }

        @Override
        public void mouseExited(MouseEvent me) {
            AComponentTitledBorder.this.handleMouseEvent(me);
        }

        @Override
        public void mousePressed(MouseEvent me) {
            AComponentTitledBorder.this.handleMouseEvent(me);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            AComponentTitledBorder.this.handleMouseEvent(me);
        }
    };

    public AComponentTitledBorder(Component titleComp, JComponent container) {
        this(titleComp, container, null);
    }

    public AComponentTitledBorder(Component titleComp, JComponent owner, Border baseBorder) {
        this.mOwner = owner;
        this.mTitleComponent = titleComp;
        this.mBaseBorder = baseBorder;
        if (this.mBaseBorder == null) {
            this.mBaseBorder = new TitledBorder(" ");
        }
        this.mOwner.addMouseListener(this.mMouseListener);
        this.mTitleYInset = 8 - this.mTitleComponent.getPreferredSize().height / 2;
    }

    protected void handleMouseEvent(MouseEvent me) {
        Rectangle r = this.getTitleComponentBounds();
        if (r != null && r.contains(me.getX(), me.getY())) {
            Point pt = me.getPoint();
            pt.translate(-this.mTitleXInset, 0);
            this.mTitleComponent.setBounds(r);
            this.mTitleComponent.dispatchEvent(new MouseEvent(this.mTitleComponent, me.getID(), me.getWhen(), me.getModifiers(), pt.x, pt.y, me.getClickCount(), me.isPopupTrigger(), me.getButton()));
            if (!this.mTitleComponent.isValid()) {
                this.mOwner.repaint();
            }
        }
    }

    public Rectangle getTitleComponentBounds() {
        Dimension size = this.mTitleComponent.getPreferredSize();
        return new Rectangle(this.mTitleXInset, this.mTitleYInset, size.width, size.height);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.mBaseBorder.paintBorder(c, g, x, y, width, height);
        Rectangle r = this.getTitleComponentBounds();
        SwingUtilities.paintComponent(g, this.mTitleComponent, (Container)c, r);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Insets insets = this.mBaseBorder.getBorderInsets(c);
        Dimension titleCompDim = this.mTitleComponent.getPreferredSize();
        insets.top = Math.max(insets.top, titleCompDim.height / 2 + this.mTitleYInset * 2);
        return insets;
    }
}

