/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class ADockingBorderLayout
extends BorderLayout {
    protected LocationIndex mLocIdx = new LocationIndex();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component component, Object constraint) {
        Location.ID loc = constraint == null ? Location.ID.NORTH : Location.ID.valueOf(("" + constraint).toUpperCase());
        Object object = component.getTreeLock();
        synchronized (object) {
            if (constraint != null) {
                component.setVisible(true);
                this.mLocIdx.add(loc, component);
                component.getParent().validate();
            }
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.mLocIdx.remove(component);
        this.flipSeparators(component, 1);
        component.getParent().validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int top = insets.top;
            int bottom = target.getHeight() - insets.bottom;
            int left = insets.left;
            int right = target.getWidth() - insets.right;
            this.mLocIdx.setAllToPreferredSize();
            int h = ((Location)this.mLocIdx.get((Object)((Object)Location.ID.NORTH))).mActualSize.height;
            this.placeComponents(target, (Location)this.mLocIdx.get((Object)Location.ID.NORTH), left, top, right - left, h);
            h = ((Location)this.mLocIdx.get((Object)((Object)Location.ID.SOUTH))).mActualSize.height;
            this.placeComponents(target, (Location)this.mLocIdx.get((Object)Location.ID.SOUTH), left, bottom - h, right - left, h);
            h = ((Location)this.mLocIdx.get((Object)((Object)Location.ID.WEST))).mActualSize.width;
            this.placeComponents(target, (Location)this.mLocIdx.get((Object)Location.ID.WEST), right - h, top += ((Location)this.mLocIdx.get((Object)((Object)Location.ID.NORTH))).mActualSize.height + this.getVgap(), h, (bottom -= ((Location)this.mLocIdx.get((Object)((Object)Location.ID.SOUTH))).mActualSize.height + this.getVgap()) - top);
            right -= ((Location)this.mLocIdx.get((Object)((Object)Location.ID.WEST))).mActualSize.width + this.getHgap();
            h = ((Location)this.mLocIdx.get((Object)((Object)Location.ID.EAST))).mActualSize.width;
            this.placeComponents(target, (Location)this.mLocIdx.get((Object)Location.ID.EAST), left, top, h, bottom - top);
            left += ((Location)this.mLocIdx.get((Object)((Object)Location.ID.EAST))).mActualSize.width + this.getHgap();
            Location center = (Location)this.mLocIdx.get((Object)Location.ID.CENTER);
            if (center != null) {
                for (Component c : center.mContents) {
                    c.setBounds(left, top, right - left, bottom - top);
                }
            }
        }
    }

    protected void placeComponents(Container target, Location loc, int x, int y, int w, int h) {
        switch (loc.getID()) {
            case NORTH: 
            case SOUTH: {
                Rectangle rec;
                Component c0;
                Component c;
                int i;
                int offset = x;
                int totalWidth = 0;
                int cwidth = 0;
                int compCount = loc.mContents.size();
                for (i = 0; i < compCount; ++i) {
                    c = loc.mContents.get(i);
                    this.flipSeparators(c, 1);
                    int widthSwap = totalWidth;
                    int cwidthSwap = cwidth;
                    cwidth = c.getPreferredSize().width;
                    if (w < (totalWidth += cwidth) && i != 0) {
                        c0 = loc.mContents.get(i - 1);
                        rec = c0.getBounds();
                        c0.setBounds(rec.x, rec.y, w - widthSwap + cwidthSwap, rec.height);
                        offset = x;
                        loc.mActualSize.height += h;
                        y += loc.getID() == Location.ID.NORTH ? h : -h;
                        totalWidth = cwidth;
                    }
                    if (i + 1 == compCount) {
                        c.setBounds(x + offset, y, w - totalWidth + cwidth, h);
                        continue;
                    }
                    c.setBounds(x + offset, y, cwidth, h);
                    offset += cwidth;
                }
            }
            case EAST: 
            case WEST: {
                Rectangle rec;
                Component c0;
                Component c;
                int i;
                int offset = x;
                int totalHeight = 0;
                int cheight = 0;
                int num = loc.mContents.size();
                for (i = 0; i < num; ++i) {
                    c = loc.mContents.get(i);
                    this.flipSeparators(c, 0);
                    int heightSwap = totalHeight;
                    int cheightSwap = cheight;
                    cheight = c.getPreferredSize().height;
                    if (h < (totalHeight += cheight) && i != 0) {
                        c0 = loc.mContents.get(i - 1);
                        rec = c0.getBounds();
                        c0.setBounds(rec.x, rec.y, rec.width, h - heightSwap + cheightSwap);
                        offset = y;
                        loc.mActualSize.width += w;
                        x += loc.getID() == Location.ID.EAST ? w : -w;
                        totalHeight = cheight;
                        offset = 0;
                    }
                    if (i + 1 == num) {
                        c.setBounds(x, y + offset, w, h - totalHeight + cheight);
                        continue;
                    }
                    c.setBounds(x, y + offset, w, cheight);
                    offset += cheight;
                }
                break;
            }
        }
    }

    protected void flipSeparators(Component component, int orient) {
        if (!(component instanceof JToolBar)) {
            return;
        }
        if (!UIManager.getLookAndFeel().getName().toLowerCase().contains("windows")) {
            return;
        }
        JToolBar tb = (JToolBar)component;
        Component[] comps = tb.getComponents();
        if (comps == null || comps.length < 1) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            Component c = comps[i];
            if (c == null || !(c instanceof JSeparator)) continue;
            boolean visible = c.isVisible();
            tb.remove(c);
            JSeparator s = new JSeparator();
            s.setVisible(visible);
            if (orient == 1) {
                s.setOrientation(1);
                s.setMinimumSize(new Dimension(2, 6));
                s.setPreferredSize(new Dimension(2, 6));
                s.setMaximumSize(new Dimension(2, 100));
            } else {
                s.setOrientation(0);
                s.setMinimumSize(new Dimension(6, 2));
                s.setPreferredSize(new Dimension(6, 2));
                s.setMaximumSize(new Dimension(100, 2));
            }
            tb.add((Component)s, i);
        }
    }

    protected static class LocationIndex
    extends HashMap<Location.ID, Location> {
        public LocationIndex() {
            for (Location.ID id : Location.ID.values()) {
                this.put(id, new Location(id));
            }
        }

        public void add(Location.ID loc, Component c) {
            ((Location)this.get((Object)loc)).add(c);
        }

        public boolean remove(Component c) {
            for (Location l : this.values()) {
                if (!l.remove(c)) continue;
                return true;
            }
            return false;
        }

        public void setAllToPreferredSize() {
            for (Location l : this.values()) {
                l.setSizeToPreferred();
            }
        }
    }

    protected static class Location {
        protected ID mId;
        protected LinkedList<Component> mContents = new LinkedList();
        protected Dimension mPreferredSize = null;
        protected Dimension mActualSize = null;

        public Location(ID id) {
            this.mId = id;
        }

        public ID getID() {
            return this.mId;
        }

        public void add(Component c) {
            this.mContents.add(c);
            this.mPreferredSize = null;
        }

        public boolean remove(Component c) {
            if (!this.mContents.remove(c)) {
                return false;
            }
            this.mPreferredSize = null;
            return true;
        }

        public boolean contains(Component c) {
            return this.mContents.contains(c);
        }

        public boolean isEmpty() {
            return this.mContents.isEmpty();
        }

        public Dimension getPreferredDimension() {
            if (this.mPreferredSize == null) {
                int w = 0;
                int h = 0;
                for (Component c : this.mContents) {
                    Dimension d = c.getPreferredSize();
                    w = Math.max(w, d.width);
                    h = Math.max(h, d.height);
                }
                this.mPreferredSize = new Dimension(w, h);
            }
            return this.mPreferredSize;
        }

        public void setSizeToPreferred() {
            this.mActualSize = this.getPreferredDimension();
        }

        public static enum ID {
            CENTER,
            EAST,
            NORTH,
            WEST,
            SOUTH;

        }
    }
}

