/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public class ADraw2D {
    private ADraw2D() {
    }

    public static void drawArrow(Graphics2D g, Point2D p1, Point2D p2, int headLen) {
        ADraw2D.drawArrow(g, (int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY(), headLen);
    }

    public static void drawL(Graphics2D g, int x1, int y1, int h, int w) {
        Path2D.Double p = new Path2D.Double();
        ((Path2D)p).moveTo(x1, y1);
        ((Path2D)p).lineTo(x1, y1 - h);
        ((Path2D)p).moveTo(x1, y1);
        ((Path2D)p).lineTo(x1 + w, y1);
        g.draw(p);
    }

    public static void drawArrow(Graphics2D g, int x1, int y1, int x2, int y2, int headLen) {
        ADraw2D.drawArrow(g, x1, y1, x2, y2, headLen, false);
    }

    public static void drawTriangle(Graphics2D g, int x, int y, int base, int height, int dir) {
        Polygon screenP = new Polygon();
        screenP.addPoint(x, y);
        screenP.addPoint(x, y - base);
        if (dir > 0) {
            screenP.addPoint(x + height, y - base / 2);
        } else {
            screenP.addPoint(x - height, y - base / 2);
        }
        g.fillPolygon(screenP);
    }

    public static void drawTriangleVert(Graphics2D g, int x, int y, int base, int height, int dir) {
        Polygon screenP = new Polygon();
        screenP.addPoint(x, y);
        screenP.addPoint(x - base, y);
        if (dir > 0) {
            screenP.addPoint(x - base / 2, y + height);
        } else {
            screenP.addPoint(x - base / 2, y - height);
        }
        g.fillPolygon(screenP);
    }

    public static void drawArrow(Graphics2D g, int x1, int y1, int x2, int y2, int headLen, boolean first) {
        double direction = Math.atan2(x1 - x2, y1 - y2);
        double da = 0.5235987755982988;
        Path2D.Double p = new Path2D.Double();
        ((Path2D)p).moveTo(x1, y1);
        ((Path2D)p).lineTo(x2, y2);
        if (!first) {
            double x3 = (double)x2 + (double)headLen * Math.sin(direction + da);
            double y3 = (double)y2 + (double)headLen * Math.cos(direction - da);
            double x4 = (double)x2 + (double)headLen * Math.sin(direction - da);
            double y4 = (double)y2 + (double)headLen * Math.cos(direction + da);
            ((Path2D)p).lineTo(x3, y3);
            ((Path2D)p).moveTo(x2, y2);
            ((Path2D)p).lineTo(x4, y4);
        } else {
            double x3 = (double)x1 - (double)headLen * Math.sin(direction + da);
            double y3 = (double)y1 - (double)headLen * Math.cos(direction - da);
            double x4 = (double)x1 - (double)headLen * Math.sin(direction - da);
            double y4 = (double)y1 - (double)headLen * Math.cos(direction + da);
            ((Path2D)p).moveTo(x1, y1);
            ((Path2D)p).lineTo(x3, y3);
            ((Path2D)p).moveTo(x1, y1);
            ((Path2D)p).lineTo(x4, y4);
        }
        g.draw(p);
    }
}

