/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.ABrowserControl;
import com.sigrity.acl.ALog;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class AFloatWindow
extends ADialog {
    public static final Icon ICON_PIN = UIUtil.getIcon(AFloatWindow.class, (String)"res/iconPin8x8.gif");
    public static final Icon ICON_CLOSE = UIUtil.getIcon(AFloatWindow.class, (String)"res/iconClose8x8.gif");
    protected static boolean sPinByDefault = true;
    protected JCheckBoxMenuItem mBtnPin;
    protected JMenuItem mBtnClose;
    protected boolean mPinnable = true;
    protected boolean mMinimizable = false;
    protected boolean mMaximizable = false;
    protected ArrayList<LinkHandler> mLinkHandlers = new ArrayList();

    public static AFloatWindow createInstance(Window owner, String title, boolean modal) {
        return new AFloatWindow(owner, title, modal ? DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS);
    }

    public static AFloatWindow createInstance(Window owner) {
        return AFloatWindow.createInstance(owner, null, false);
    }

    public static void setPinByDefault(boolean b) {
        sPinByDefault = b;
    }

    public static boolean getPinByDefault() {
        return sPinByDefault;
    }

    public AFloatWindow() {
        this.init();
    }

    public AFloatWindow(Component owner, String title) {
        super(owner, title);
        this.init();
    }

    public AFloatWindow(Window owner, String title, Dialog.ModalityType modalityType) {
        super(owner, title, modalityType);
        this.init();
    }

    public AFloatWindow(Window owner) {
        super(owner);
        this.init();
    }

    private void init() {
        this.setSize(400, 300);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    AFloatWindow.this.showContextMenu(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    AFloatWindow.this.showContextMenu(e);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    AFloatWindow.this.showContextMenu(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    AFloatWindow.this.showContextMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    AFloatWindow.this.showContextMenu(e);
                }
            }
        });
        this.mBtnPin = new JCheckBoxMenuItem("Pin this window");
        if (sPinByDefault) {
            this.mBtnPin.setSelected(true);
        }
        this.mBtnClose = new JMenuItem("Close");
        this.mBtnClose.addActionListener(e -> UIUtil.closeWindow((Window)((Object)this)));
        WindowEventHandler weh = new WindowEventHandler();
        this.addWindowListener(weh);
        this.addMouseListener(weh);
        this.addMouseMotionListener(weh);
        UIUtil.enableEscape((JDialog)((Object)this));
    }

    private void showContextMenu(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.mBtnPin);
        menu.add(this.mBtnClose);
        menu.show((Component)((Object)this), e.getX(), e.getY());
    }

    public void setHtmlContents(URL url) {
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        HtmlPanel hp = new HtmlPanel(url);
        this.getContentPane().add(hp);
        this.pack();
    }

    public HTMLDocument setHtmlContents(String html) {
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        HtmlPanel hp = new HtmlPanel(html);
        this.getContentPane().add(hp);
        this.pack();
        return hp.getHtmlDoc();
    }

    public void setPinnable(boolean pinnable) {
        this.mPinnable = pinnable;
    }

    public boolean getPinnable() {
        return this.mPinnable;
    }

    public boolean getPinned() {
        return this.mBtnPin.isSelected();
    }

    public void setPinned(boolean pinned) {
        this.mBtnPin.setSelected(pinned);
    }

    public void setForcePinned(boolean b) {
        this.mBtnPin.setSelected(b);
    }

    public void addLinkHandler(LinkHandler lh) {
        this.mLinkHandlers.add(lh);
    }

    public void removeLinkHandler(LinkHandler lh) {
        this.mLinkHandlers.remove(lh);
    }

    public static interface LinkHandler {
        public boolean linkUpdate(HyperlinkEvent var1);
    }

    public class HtmlPanel
    extends JPanel {
        protected JTextPane mTextPaneHtml = new JTextPane();
        protected JScrollPane mScrollPane;
        protected boolean mPageLoaded = false;

        public HtmlPanel() {
            HTMLEditorKit ek = new HTMLEditorKit();
            this.mTextPaneHtml.setEditorKit(ek);
            this.mTextPaneHtml.setEditable(false);
            this.mTextPaneHtml.addHyperlinkListener(e -> {
                for (LinkHandler lh : AFloatWindow.this.mLinkHandlers) {
                    if (!lh.linkUpdate(e)) continue;
                    return;
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ABrowserControl.displayURL((String)e.getDescription());
                }
            });
            this.mScrollPane = new JScrollPane(this.mTextPaneHtml);
            this.mScrollPane.setHorizontalScrollBarPolicy(30);
            this.mScrollPane.setVerticalScrollBarPolicy(20);
            this.mScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.mScrollPane.setAlignmentX(0.0f);
            this.setLayout(new BorderLayout());
            this.add(this.mScrollPane);
        }

        public HtmlPanel(URL url) {
            this();
            this.mTextPaneHtml.addPropertyChangeListener(evt -> {
                if (evt.getPropertyName().equals("page")) {
                    this.mPageLoaded = true;
                }
            });
            try {
                this.mTextPaneHtml.setPage(url);
            }
            catch (IOException ioe) {
                ALog.logError((Throwable)ioe, (String)"Unable to read from URL.", (Object[])new Object[0]);
                this.mTextPaneHtml.setText(ioe.toString());
            }
        }

        public HtmlPanel(String html) {
            this();
            this.mTextPaneHtml.setText(html);
        }

        public boolean getPageLoaded() {
            return this.mPageLoaded;
        }

        public HTMLDocument getHtmlDoc() {
            return (HTMLDocument)this.mTextPaneHtml.getDocument();
        }
    }

    protected class WindowEventHandler
    implements WindowListener,
    MouseListener,
    MouseMotionListener {
        protected Point mPressOrigin = null;
        protected int mCurCursorType = 0;
        protected Cursor mWindowCursor = null;

        protected WindowEventHandler() {
        }

        protected void updateCursor(int newCursorType) {
            if (newCursorType == this.mCurCursorType) {
                return;
            }
            if (this.mCurCursorType == 0) {
                this.mWindowCursor = AFloatWindow.this.getCursor();
            }
            if (newCursorType == 0) {
                AFloatWindow.this.setCursor(this.mWindowCursor);
                this.mWindowCursor = null;
            } else {
                AFloatWindow.this.setCursor(Cursor.getPredefinedCursor(newCursorType));
            }
            this.mCurCursorType = newCursorType;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.mPressOrigin == null) {
                this.updateCursor(0);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mPressOrigin = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mPressOrigin = null;
            this.updateCursor(0);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.mPressOrigin == null) {
                return;
            }
            int dx = e.getX() - this.mPressOrigin.x;
            int dy = e.getY() - this.mPressOrigin.y;
            if (this.mCurCursorType == 0) {
                Point winLoc = AFloatWindow.this.getLocation();
                AFloatWindow.this.setLocation(winLoc.x + dx, winLoc.y + dy);
            } else {
                Rectangle winBounds = AFloatWindow.this.getBounds();
                Dimension minSize = AFloatWindow.this.getMinimumSize();
                int xAvail = winBounds.width - minSize.width;
                int yAvail = winBounds.height - minSize.height;
                switch (this.mCurCursorType) {
                    case 11: {
                        dx = Math.max(-xAvail, dx);
                        this.mPressOrigin.x += dx;
                        winBounds.width += dx;
                        break;
                    }
                    case 7: {
                        dx = Math.max(-xAvail, dx);
                        this.mPressOrigin.x += dx;
                        winBounds.width += dx;
                        dy = Math.min(yAvail, dy);
                        winBounds.y += dy;
                        winBounds.height -= dy;
                        break;
                    }
                    case 8: {
                        dy = Math.min(yAvail, dy);
                        winBounds.y += dy;
                        winBounds.height -= dy;
                        break;
                    }
                    case 6: {
                        dy = Math.min(yAvail, dy);
                        winBounds.y += dy;
                        winBounds.height -= dy;
                        dx = Math.min(xAvail, dx);
                        winBounds.x += dx;
                        winBounds.width -= dx;
                        break;
                    }
                    case 10: {
                        dx = Math.min(xAvail, dx);
                        winBounds.x += dx;
                        winBounds.width -= dx;
                        break;
                    }
                    case 4: {
                        dx = Math.min(xAvail, dx);
                        winBounds.x += dx;
                        winBounds.width -= dx;
                        dy = Math.max(-yAvail, dy);
                        this.mPressOrigin.y += dy;
                        winBounds.height += dy;
                        break;
                    }
                    case 9: {
                        dy = Math.max(-yAvail, dy);
                        this.mPressOrigin.y += dy;
                        winBounds.height += dy;
                        break;
                    }
                    case 5: {
                        dx = Math.max(-xAvail, dx);
                        this.mPressOrigin.x += dx;
                        winBounds.width += dx;
                        dy = Math.max(-yAvail, dy);
                        this.mPressOrigin.y += dy;
                        winBounds.height += dy;
                    }
                }
                AFloatWindow.this.setBounds(winBounds);
                AFloatWindow.this.validate();
            }
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            if (!AFloatWindow.this.mBtnPin.isSelected()) {
                UIUtil.closeWindow((Window)((Object)AFloatWindow.this));
            }
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }
}

