/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.app.Settings;
import com.sigrity.acl.ui.AComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AHistoryTextField
extends AComboBox<Object> {
    public static final int DEFAULT_MAX_HISTORY = 32;
    protected int columnWidth = 0;
    protected int mColumns = 0;
    protected boolean mAutoSave = true;
    protected int mMaxHistory = 32;
    protected String mHistorySection;
    protected String mSettingBaseName;
    protected Timer mUpdateTimer;
    protected boolean mUpdatePending = false;
    protected boolean mUpdating = false;
    protected UpdateListener mUpdateListener = null;
    protected ActionListener mActionListener = null;
    protected boolean mInvokeActionOnTextUpdate = false;
    protected DefaultComboBoxModel<Object> mModel = new DefaultComboBoxModel<Object>(){

        @Override
        protected void fireContentsChanged(Object source, int index0, int index1) {
            if (!AHistoryTextField.this.mUpdating) {
                super.fireContentsChanged(source, index0, index1);
            }
        }

        @Override
        protected void fireIntervalAdded(Object source, int index0, int index1) {
            if (!AHistoryTextField.this.mUpdating) {
                super.fireIntervalAdded(source, index0, index1);
            }
        }

        @Override
        protected void fireIntervalRemoved(Object source, int index0, int index1) {
            if (!AHistoryTextField.this.mUpdating) {
                super.fireIntervalRemoved(source, index0, index1);
            }
        }

        @Override
        public void setSelectedItem(Object anObject) {
            super.setSelectedItem(anObject);
            this.fireContentsChanged(this, -1, -1);
        }
    };
    protected DocumentListener mTextChanged = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            AHistoryTextField.this.scheduleUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AHistoryTextField.this.scheduleUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            AHistoryTextField.this.scheduleUpdate();
        }
    };
    protected KeyListener mKeyListener = new KeyAdapter(){

        @Override
        public void keyTyped(KeyEvent e) {
            super.keyTyped(e);
            char key = e.getKeyChar();
            if (key == '\n') {
                AHistoryTextField.this.callAction(UpdateHint.ACTION);
            }
        }
    };
    protected ActionListener mTimedUpdateTask = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AHistoryTextField.this.callAction(UpdateHint.TIMER);
        }
    };

    public AHistoryTextField(String settingsSection, String settingsBaseName) {
        this.mHistorySection = settingsSection;
        this.mSettingBaseName = settingsBaseName;
        this.setModel(this.mModel);
        this.setEditable(true);
        this.setRenderer(new DefaultListCellRenderer());
    }

    public AHistoryTextField(String settingsSection, String settingsBaseName, int columns) {
        this(settingsSection, settingsBaseName);
        if (columns < 0) {
            throw new IllegalArgumentException("Columns less than zero.");
        }
        this.mColumns = columns;
    }

    public void addNotify() {
        super.addNotify();
        this.readHistory();
        this.checkListeners(this.mUpdateListener);
        this.getEditor().getEditorComponent().addKeyListener(this.mKeyListener);
    }

    public void removeNotify() {
        this.getEditor().getEditorComponent().removeKeyListener(this.mKeyListener);
        this.checkListeners(null);
        super.removeNotify();
    }

    public int getColumns() {
        return this.mColumns;
    }

    public void setColumns(int columns) {
        int oldVal = this.mColumns;
        if (columns < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        if (columns != oldVal) {
            this.mColumns = columns;
            this.invalidate();
        }
    }

    public void setAutoSave(boolean b) {
        this.mAutoSave = b;
    }

    public boolean getAutoSave() {
        return this.mAutoSave;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.mColumns != 0) {
            Insets insets = this.getInsets();
            size.width = this.mColumns * this.getColumnWidth() + insets.left + insets.right;
        }
        return size;
    }

    public void setText(String text) {
        this.setSelectedItem(text);
    }

    public String getText() {
        return this.getTextField().getText();
    }

    public void setUpdateListener(UpdateListener r) {
        this.mUpdateListener = r;
        this.checkListeners(this.mUpdateListener);
    }

    public void setInvokeActionOnTextUpdate(boolean invokeActionOnTextUpdate) {
        this.mInvokeActionOnTextUpdate = invokeActionOnTextUpdate;
    }

    public JTextField getTextField() {
        Component c = this.getEditor().getEditorComponent();
        if (c instanceof JTextField) {
            return (JTextField)c;
        }
        return null;
    }

    public void saveCurrentEntryToHistory() {
        String text = this.getText();
        if (text != null) {
            text = text.trim();
        }
        if (text != null && text.length() > 0) {
            this.mUpdating = true;
            int idx = this.mModel.getIndexOf(text);
            if (idx >= 0) {
                this.mModel.removeElementAt(idx);
            }
            this.mModel.insertElementAt(text, 0);
            this.mModel.setSelectedItem(text);
            this.mUpdating = false;
            this.saveHistory();
        }
    }

    protected void readHistory() {
        String k;
        String v;
        Settings settings = Settings.getSettings((String)this.mHistorySection);
        for (int i = 0; i < this.mMaxHistory && (v = (String)settings.getSettingOfClass(k = String.format("%s:%d", this.mSettingBaseName, i), String.class)) != null; ++i) {
            this.mModel.addElement(v);
        }
        this.setSelectedIndex(-1);
    }

    protected void saveHistory() {
        String k;
        int i;
        Settings settings = Settings.getSettings((String)this.mHistorySection);
        for (i = 0; i < Integer.MAX_VALUE && settings.getSettingOfClass(k = String.format("%s:%d", this.mSettingBaseName, i), String.class) != null; ++i) {
            settings.removeSetting(k);
        }
        int written = 0;
        for (i = 0; i < this.mModel.getSize() && written < this.mMaxHistory; ++i) {
            String s = "" + this.mModel.getElementAt(i);
            String k2 = String.format("%s:%d", this.mSettingBaseName, i);
            settings.putSetting(k2, (Object)s);
        }
        settings.save(Settings.Type.User);
    }

    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth('m');
        }
        return this.columnWidth;
    }

    protected void checkListeners(UpdateListener l) {
        if (l != null && this.mActionListener == null) {
            this.mActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AHistoryTextField.this.callAction(UpdateHint.ACTION);
                }
            };
            this.addActionListener(this.mActionListener);
            this.getTextField().getDocument().addDocumentListener(this.mTextChanged);
        } else if (l == null && this.mActionListener != null) {
            this.removeActionListener(this.mActionListener);
            this.getTextField().getDocument().removeDocumentListener(this.mTextChanged);
            this.mActionListener = null;
        }
    }

    protected void scheduleUpdate() {
        if (!this.mInvokeActionOnTextUpdate || this.mUpdating) {
            return;
        }
        if (this.mUpdateTimer == null) {
            this.mUpdateTimer = new Timer(1000, this.mTimedUpdateTask);
            this.mUpdateTimer.setRepeats(false);
        }
        if (this.mUpdateTimer.isRunning()) {
            this.mUpdateTimer.restart();
        } else {
            this.mUpdateTimer.start();
        }
    }

    protected void callAction(final UpdateHint hint) {
        if (this.mUpdateTimer != null && this.mUpdateTimer.isRunning()) {
            this.mUpdateTimer.stop();
        }
        if (this.mUpdatePending || this.mUpdating) {
            return;
        }
        this.mUpdatePending = true;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AHistoryTextField.this.mUpdatePending = false;
                if (AHistoryTextField.this.mAutoSave) {
                    AHistoryTextField.this.saveCurrentEntryToHistory();
                }
                AHistoryTextField.this.mUpdateListener.update(hint);
            }
        });
    }

    public static interface UpdateListener {
        public void update(UpdateHint var1);
    }

    public static enum UpdateHint {
        TIMER,
        ACTION;

    }
}

