/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.AHtmlSourceViewer;
import com.sigrity.acl.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class AHtmlPane
extends JTextPane {
    protected URL mLastLoadedCss = null;

    public AHtmlPane() {
        HTMLEditorKit hek = new HTMLEditorKit();
        this.setBorder(null);
        this.setEditorKit(hek);
        this.setEditable(false);
        this.setDocument(hek.createDefaultDocument());
        UIUtil.installPopupMenu((Component)this, (UIUtil.APopupMenuProvider)this.createPopupMenuProvider());
    }

    public void setCSS(URL css) {
        try (InputStreamReader reader = new InputStreamReader(css.openStream());){
            StyleSheet ss = new StyleSheet();
            ss.loadRules(reader, css);
            String text = this.getText();
            HTMLEditorKit hek = new HTMLEditorKit();
            hek.setStyleSheet(ss);
            this.setEditorKit(hek);
            this.setText(text);
            this.mLastLoadedCss = css;
        }
        catch (IOException e) {
            ALog.logDebug((Throwable)e, (String)"Error loading CSS.", (Object[])new Object[0]);
        }
    }

    public void addCSSRule(String rule) {
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        StyleSheet styleSheet = doc.getStyleSheet();
        styleSheet.addRule(rule);
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        this.setCaretPosition(0);
    }

    public HTMLEditorKit getHTMLEditorKit() {
        EditorKit ek = this.getEditorKit();
        if (ek instanceof HTMLEditorKit) {
            return (HTMLEditorKit)ek;
        }
        return null;
    }

    public UIUtil.APopupMenuProvider createPopupMenuProvider() {
        return new PopupMenuProvider();
    }

    protected class CssReloadAction
    extends AbstractAction {
        public CssReloadAction() {
            super("Reload CSS");
            if (AHtmlPane.this.mLastLoadedCss == null) {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AHtmlPane.this.setCSS(AHtmlPane.this.mLastLoadedCss);
        }
    }

    protected class CssLoadAction
    extends AbstractAction {
        public CssLoadAction() {
            super("Set CSS...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            fc.addChoosableFileFilter((FileFilter)AFileFilter.CSS);
            int res = fc.showOpenDialog((Component)AHtmlPane.this);
            if (res != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            try {
                URL url = f.toURI().toURL();
                AHtmlPane.this.setCSS(url);
            }
            catch (MalformedURLException e1) {
                ALog.logError((Throwable)e1, (String)"Error opening CSS file.", (Object[])new Object[0]);
            }
        }
    }

    protected class CssViewSourceAction
    extends AbstractAction {
        public CssViewSourceAction() {
            super("View CSS Source");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AHtmlSourceViewer.showHtmlSource(AHtmlPane.this, AHtmlPane.this.getHTMLEditorKit().getStyleSheet().toString());
        }
    }

    protected class HtmlViewSourceAction
    extends AbstractAction {
        public HtmlViewSourceAction() {
            super("View HTML Source");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AHtmlSourceViewer.showHtmlSource(AHtmlPane.this, AHtmlPane.this.getText());
        }
    }

    protected class PopupMenuProvider
    implements UIUtil.APopupMenuProvider {
        protected PopupMenuProvider() {
        }

        public JPopupMenu getMenu(Component c, int x, int y) {
            JPopupMenu popup = new JPopupMenu();
            popup.add(new HtmlViewSourceAction());
            popup.addSeparator();
            popup.add(new CssViewSourceAction());
            popup.add(new CssLoadAction());
            popup.add(new CssReloadAction());
            return popup;
        }
    }
}

