/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.ui.UIUtil;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;

public class ALinkLabel
extends JLabel {
    protected String mText;
    protected ActionListener mActionListener = null;
    protected MouseListener mMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 1) {
                ALinkLabel.this.fireActionEvent();
            }
        }
    };

    public ALinkLabel() {
        this("");
    }

    public ALinkLabel(String text) {
        this.setText(text);
        this.setToolTipText(text);
        this.setForeground(Color.BLUE);
        Font font = this.getFont();
        HashMap attributes = new HashMap(font.getAttributes());
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        this.setFont(font.deriveFont(attributes));
    }

    public ALinkLabel(Action action) {
        this((String)action.getValue("Name"));
        this.mActionListener = action;
    }

    public ALinkLabel(String text, Action action) {
        this(text);
        this.mActionListener = action;
    }

    public ALinkLabel(String text, Runnable r) {
        this(text);
        this.mActionListener = e -> r.run();
    }

    public synchronized void addActionListener(ActionListener l) {
        this.mActionListener = AWTEventMulticaster.add(this.mActionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.mActionListener = AWTEventMulticaster.remove(this.mActionListener, l);
    }

    public void fireActionEvent() {
        if (this.mActionListener != null) {
            this.mActionListener.actionPerformed(new ActionEvent(this, 1001, null));
        }
    }

    @Override
    public void setText(String text) {
        this.mText = text;
        super.setText(text);
    }

    public void enableCopySupport(Action ... otherActions) {
        JPopupMenu menu = UIUtil.addCopySupport((JComponent)this, (UIUtil.ATextProvider)new UIUtil.ATextProvider(){

            public String getText() {
                return ALinkLabel.this.mText;
            }
        });
        for (Action a : otherActions) {
            menu.add(a);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(this.mMouseListener);
    }

    @Override
    public void removeNotify() {
        this.removeMouseListener(this.mMouseListener);
        super.removeNotify();
    }
}

