/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class AList<T>
extends JList<T> {
    protected boolean mCheckBoxes = false;
    protected ArrayList<CheckListener> mListeners = new ArrayList();
    protected KeyListener mListKeyListener = new KeyAdapter(){

        @Override
        public void keyTyped(KeyEvent e) {
            super.keyTyped(e);
            if (e.isConsumed() || e.getKeyChar() != ' ' || !AList.this.mCheckBoxes) {
                return;
            }
            for (int i : AList.this.getSelectedIndices()) {
                AListItem v;
                Object value = AList.this.getModel().getElementAt(i);
                if (!(value instanceof AListItem)) continue;
                v.setIsSelected(!(v = (AListItem)value).getIsSelected());
                AList.this.fireCheckChanged(v);
                UIUtil.repaintListItem((JList)AList.this, (int)i);
            }
        }
    };
    protected MouseListener mListMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 1 || !AList.this.mCheckBoxes) {
                return;
            }
            Point pt = e.getPoint();
            int index = AList.this.locationToIndex(pt);
            if (index < 0) {
                return;
            }
            Object value = AList.this.getModel().getElementAt(index);
            if (!(value instanceof AListItem)) {
                return;
            }
            AListItem v = (AListItem)value;
            SelectFileCellRenderer renderer = (SelectFileCellRenderer)AList.this.getCellRenderer();
            Rectangle cellBounds = AList.this.getCellBounds(index, index);
            renderer.getListCellRendererComponent(AList.this, value, index, false, false);
            renderer.setBounds(0, 0, cellBounds.width, cellBounds.height);
            Point rendererPoint = new Point(pt);
            rendererPoint.translate(-cellBounds.x, -cellBounds.y);
            if (renderer.getComponentAt(rendererPoint) != renderer.mCBSel) {
                return;
            }
            v.setIsSelected(!v.getIsSelected());
            AList.this.fireCheckChanged(v);
            AList.this.repaint(cellBounds);
        }
    };

    public AList() {
        this.addMouseListener(this.mListMouseListener);
        this.addKeyListener(this.mListKeyListener);
        this.setCellRenderer(new SelectFileCellRenderer(this));
    }

    public AList(ListModel<T> model) {
        super(model);
        this.addMouseListener(this.mListMouseListener);
        this.addKeyListener(this.mListKeyListener);
        this.setCellRenderer(new SelectFileCellRenderer(this));
    }

    public AList(T[] listData) {
        super(listData);
        this.addMouseListener(this.mListMouseListener);
        this.addKeyListener(this.mListKeyListener);
        this.setCellRenderer(new SelectFileCellRenderer(this));
    }

    public AList(Vector<T> listData) {
        super(listData);
        this.addMouseListener(this.mListMouseListener);
        this.addKeyListener(this.mListKeyListener);
        this.setCellRenderer(new SelectFileCellRenderer(this));
    }

    public boolean addCheckListener(CheckListener listener) {
        if (this.mListeners.contains(listener)) {
            return false;
        }
        return this.mListeners.add(listener);
    }

    public boolean removeCheckListener(CheckListener listener) {
        return this.mListeners.remove(listener);
    }

    protected void fireCheckChanged(AListItem item) {
        for (CheckListener l : this.mListeners) {
            l.checkChanged(item);
        }
    }

    public void setShowCheckBoxes(boolean b) {
        this.mCheckBoxes = b;
        this.setCellRenderer(new SelectFileCellRenderer(this));
    }

    public static class SelectFileCellRenderer<T>
    extends JPanel
    implements ListCellRenderer<T> {
        protected AList<T> mList;
        protected JCheckBox mCBSel = null;
        protected JLabel mLabel = new JLabel();

        public SelectFileCellRenderer(AList<T> list) {
            this.mList = list;
            this.setLayout(new FlowLayout(0, 0, 0));
            if (this.mList.mCheckBoxes) {
                this.mCBSel = new JCheckBox();
                this.add(this.mCBSel);
                this.mCBSel.setOpaque(false);
                this.mCBSel.setBackground(new Color(0, 0, 0, 0));
            }
            this.add(this.mLabel);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof AListItem) {
                AListItem v = (AListItem)value;
                if (this.mCBSel != null) {
                    this.mCBSel.setSelected(v.getIsSelected());
                }
                this.mLabel.setText(v.getText());
                this.mLabel.setIcon(v.getIcon());
                this.setToolTipText(v.getToolTip());
            } else {
                if (this.mCBSel != null) {
                    this.mCBSel.setSelected(false);
                }
                this.mLabel.setText(value.toString());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    public static class AListItem {
        protected Icon mIcon;
        protected String mText;
        protected String mToolTip;
        protected Object mKey;
        protected boolean mIsSelected = false;

        public AListItem(String text) {
            this(text, null, null);
        }

        public AListItem(String text, Icon icon, Object key) {
            this.mText = text;
            this.mIcon = icon;
            this.mKey = key;
        }

        public String getText() {
            return this.mText;
        }

        public Icon getIcon() {
            return this.mIcon;
        }

        public void setKey(Object key) {
            this.mKey = key;
        }

        public Object getKey() {
            return this.mKey;
        }

        public boolean getIsSelected() {
            return this.mIsSelected;
        }

        public void setIsSelected(boolean isSelected) {
            this.mIsSelected = isSelected;
        }

        public void setToolTip(String tt) {
            this.mToolTip = tt;
        }

        public String getToolTip() {
            return this.mToolTip;
        }
    }

    public static interface CheckListener {
        public void checkChanged(AListItem var1);
    }
}

