/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.ui.AListConnectionOverlay;
import com.sigrity.acl.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AListConnectionManager<L, R> {
    static final DataFlavor ListObjectFlavor = new DataFlavor(Object.class, "List Object");
    static final DataFlavor[] mFlavors = new DataFlavor[]{DataFlavor.stringFlavor, ListObjectFlavor};
    protected JList<L> mLstLeft;
    protected JList<R> mLstRight;
    protected AListConnectionOverlay.ListItemMapper<L, R> mMap;
    protected HashSet<DataFlavor> mHashFlavors = new HashSet<DataFlavor>(Arrays.asList(mFlavors));

    public AListConnectionManager(JList<L> left, JList<R> right, AListConnectionOverlay.ListItemMapper<L, R> map) {
        this.mLstLeft = left;
        this.mLstRight = right;
        this.mMap = map;
        this.mLstLeft.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AListConnectionManager.this.repaintGlass();
                int idxRight = AListConnectionManager.this.mMap.getRightListIndex(AListConnectionManager.this.mLstLeft.getSelectedIndex());
                if (idxRight < 0) {
                    AListConnectionManager.this.mLstRight.clearSelection();
                } else {
                    AListConnectionManager.this.mLstRight.setSelectedIndex(idxRight);
                    AListConnectionManager.this.mLstRight.ensureIndexIsVisible(idxRight);
                }
                AListConnectionManager.this.updateStatus();
            }
        });
        this.mLstLeft.setDragEnabled(true);
        this.mLstLeft.setTransferHandler(new TransferHandler(null){

            @Override
            public int getSourceActions(JComponent c) {
                return 0x40000000;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                return new Transferable(){

                    @Override
                    public boolean isDataFlavorSupported(DataFlavor flavor) {
                        return AListConnectionManager.this.mHashFlavors.contains(flavor);
                    }

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        return mFlavors;
                    }

                    @Override
                    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                        if (flavor == ListObjectFlavor) {
                            return AListConnectionManager.this.mLstLeft.getSelectedValue();
                        }
                        if (flavor == DataFlavor.stringFlavor) {
                            Component c = AListConnectionManager.this.mLstLeft.getCellRenderer().getListCellRendererComponent(AListConnectionManager.this.mLstLeft, AListConnectionManager.this.mLstLeft.getSelectedValue(), AListConnectionManager.this.mLstLeft.getSelectedIndex(), true, true);
                            if (c instanceof DefaultListCellRenderer) {
                                return ((DefaultListCellRenderer)c).getText();
                            }
                            if (c instanceof JLabel) {
                                return ((JLabel)c).getText();
                            }
                            return "" + AListConnectionManager.this.mLstLeft.getSelectedValue();
                        }
                        throw new UnsupportedFlavorException(flavor);
                    }
                };
            }
        });
        this.mLstRight.setDropMode(DropMode.ON);
        this.mLstRight.setTransferHandler(new TransferHandlerRight());
        this.mLstRight.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    Object left = AListConnectionManager.this.mLstLeft.getSelectedValue();
                    if (left == null) {
                        return;
                    }
                    Object tgt = AListConnectionManager.this.mLstRight.getSelectedValue();
                    if (tgt == null) {
                        return;
                    }
                    AListConnectionManager.this.mMap.put(left, tgt);
                    AListConnectionManager.this.repaintGlass();
                    AListConnectionManager.this.updateStatus();
                }
            }
        });
    }

    protected abstract void updateStatus();

    protected void repaintGlass() {
        JDialog dlg = (JDialog)UIUtil.getAncestorOfType(this.mLstLeft, JDialog.class);
        if (dlg != null) {
            dlg.getGlassPane().repaint();
        }
    }

    public class TransferHandlerRight
    extends TransferHandler {
        public TransferHandlerRight() {
            super(null);
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDataFlavorSupported(ListObjectFlavor)) {
                return false;
            }
            APair right = this.getDropTargetItem(support);
            if (right.second == null) {
                return false;
            }
            if (AListConnectionManager.this.mLstRight.getSelectedIndex() != ((Integer)right.second).intValue()) {
                AListConnectionManager.this.mLstRight.setSelectedValue(right.first, true);
            }
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!support.isDataFlavorSupported(ListObjectFlavor)) {
                return false;
            }
            Object left = null;
            try {
                Object temp;
                left = temp = support.getTransferable().getTransferData(ListObjectFlavor);
            }
            catch (Exception e) {
                ALog.logWarn((Throwable)e, (String)"Error getting transfer data.", (Object[])new Object[0]);
                return false;
            }
            Object right = this.getDropTargetItem((TransferHandler.TransferSupport)support).first;
            if (right == null) {
                return false;
            }
            AListConnectionManager.this.mMap.put(left, right);
            AListConnectionManager.this.mLstRight.setSelectedValue(right, true);
            AListConnectionManager.this.updateStatus();
            AListConnectionManager.this.repaintGlass();
            return true;
        }

        APair<R, Integer> getDropTargetItem(TransferHandler.TransferSupport support) {
            TransferHandler.DropLocation loc = support.getDropLocation();
            Point pt = loc.getDropPoint();
            int idx = AListConnectionManager.this.mLstRight.locationToIndex(pt);
            if (idx < 0) {
                return APair.create(null, null);
            }
            Object r = AListConnectionManager.this.mLstRight.getModel().getElementAt(idx);
            return APair.create(r, (Object)idx);
        }
    }
}

