/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.ui.ADraw2D;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class AListConnectionOverlay<L, R>
extends JComponent {
    protected JList<L> mLstLeft;
    protected JList<R> mLstRight;
    protected ListItemMapper<L, R> mListItemMapper;
    protected ComponentListener mListMotionListener = new ComponentAdapter(){

        @Override
        public void componentMoved(ComponentEvent e) {
            AListConnectionOverlay.this.repaint();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            AListConnectionOverlay.this.repaint();
        }
    };

    public AListConnectionOverlay(JList<L> left, JList<R> right, ListItemMapper<L, R> map) {
        this.mLstLeft = left;
        this.mLstRight = right;
        this.mListItemMapper = map;
        this.mLstLeft.addComponentListener(this.mListMotionListener);
        this.mLstRight.addComponentListener(this.mListMotionListener);
    }

    @Override
    protected void paintComponent(Graphics gIn) {
        Graphics2D g = (Graphics2D)gIn;
        Color oldColor = g.getColor();
        Object oldAntiAliasing = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle oldClip = g.getClipBounds();
        Rectangle srcListVisible = SwingUtilities.convertRectangle(this.mLstLeft, this.mLstLeft.getVisibleRect(), this);
        Rectangle destListVisible = SwingUtilities.convertRectangle(this.mLstRight, this.mLstRight.getVisibleRect(), this);
        Rectangle2D clipRect = new Rectangle(srcListVisible);
        clipRect = ((Rectangle2D)clipRect).createUnion(destListVisible);
        g.setClip(clipRect);
        ListModel<L> modelL = this.mLstLeft.getModel();
        IntStream.range(0, modelL.getSize()).forEach(idxLeft -> {
            int idxRight = this.mListItemMapper.getRightListIndex(idxLeft);
            if (idxRight >= 0) {
                Rectangle rectLeft = this.mLstLeft.getCellBounds(idxLeft, idxLeft);
                rectLeft = SwingUtilities.convertRectangle(this.mLstLeft, rectLeft, this);
                Rectangle rectRight = this.mLstRight.getCellBounds(idxRight, idxRight);
                rectRight = SwingUtilities.convertRectangle(this.mLstRight, rectRight, this);
                boolean isLeftSelected = this.mLstLeft.isSelectedIndex(idxLeft);
                g.setColor(isLeftSelected ? Color.RED : Color.BLACK);
                Object val = modelL.getElementAt(idxLeft);
                Dimension leftCellSize = this.mLstLeft.getCellRenderer().getListCellRendererComponent(this.mLstLeft, val, idxLeft, isLeftSelected, false).getPreferredSize();
                int leftXOffset = Math.min(rectLeft.width, leftCellSize.width);
                Point ptLeft = new Point(rectLeft.x + leftXOffset + 1, (int)rectLeft.getCenterY());
                if (ptLeft.x > srcListVisible.x + srcListVisible.width) {
                    ptLeft.x = srcListVisible.x + srcListVisible.width;
                }
                Point ptRight = new Point(rectRight.x, (int)rectRight.getCenterY());
                ADraw2D.drawArrow(g, ptLeft, ptRight, leftCellSize.height / 3);
            }
        });
        g.setClip(oldClip);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntiAliasing);
        g.setColor(oldColor);
    }

    public static interface ListItemMapper<L, R> {
        public int getRightListIndex(int var1);

        public void put(L var1, R var2);
    }
}

