/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;

public class AListModel<T>
extends AbstractListModel<T> {
    protected ArrayList<T> mData = new ArrayList();

    public static <T> AListModel<T> create(Collection<T> c) {
        return new AListModel<T>(c);
    }

    public AListModel() {
    }

    public AListModel(Collection<T> data) {
        this.setContents(data);
    }

    @Override
    public T getElementAt(int index) {
        return this.mData.get(index);
    }

    @Override
    public int getSize() {
        return this.mData.size();
    }

    public void addItem(T item) {
        this.mData.add(item);
        this.fireIntervalAdded(this, this.mData.size() - 1, this.mData.size() - 1);
    }

    public void addItem(int index, T item) {
        this.mData.add(index, item);
        this.fireIntervalAdded(this, index, index);
    }

    public boolean contains(T item) {
        return this.mData.contains(item);
    }

    public int indexOf(T item) {
        return this.mData.indexOf(item);
    }

    public void clear() {
        int oldSize = this.mData.size();
        if (oldSize == 0) {
            return;
        }
        this.mData.clear();
        this.fireIntervalRemoved(this, 0, oldSize - 1);
    }

    public void sort(Comparator<T> comparator) {
        Collections.sort(this.mData, comparator);
        this.fireContentsChanged(this, 0, this.mData.size() - 1);
    }

    public List<T> getList() {
        return this.mData;
    }

    public void setContents(Collection<T> data) {
        this.mData.clear();
        this.mData.addAll(data);
        this.fireContentsChanged(this, 0, this.mData.size() - 1);
    }

    public T removeItem(int index) {
        T item = this.mData.remove(index);
        this.fireIntervalRemoved(this, index, index);
        return item;
    }

    public boolean setItemAt(int idx, T item) {
        try {
            this.mData.set(idx, item);
            this.fireContentsChanged(this, idx, idx);
            return true;
        }
        catch (IndexOutOfBoundsException iob) {
            return false;
        }
    }

    public T getItemAt(int idx) {
        if (idx < 0 || idx >= this.mData.size()) {
            return null;
        }
        return this.getElementAt(idx);
    }
}

