/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.RegexFilterField;
import com.sigrity.acl.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class AListSearcher {
    public static final ListItemToString DefaultListItemToString = new ListItemToString(){

        @Override
        public String toString(Object listItem) {
            return listItem == null ? "" : listItem.toString();
        }
    };
    protected JList<?> mList;
    protected ListItemToString mListItemToString;
    protected Pattern mPattern = null;
    protected ArrayList<Integer> mFound = new ArrayList();
    protected int mActiveMatchIdx = -1;
    protected LinkedList<ActivateListener> mActivateListeners = new LinkedList();
    public Action Previous = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AListSearcher.this.previous();
        }
    };
    public Action Next = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AListSearcher.this.next();
        }
    };

    public AListSearcher(JList<?> list) {
        this(list, DefaultListItemToString);
    }

    public AListSearcher(JList<?> list, ListItemToString toStr) {
        this.mList = list;
        this.mListItemToString = toStr;
        this.mList.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                AListSearcher.this.searchFor(AListSearcher.this.mPattern);
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                AListSearcher.this.searchFor(AListSearcher.this.mPattern);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                AListSearcher.this.searchFor(AListSearcher.this.mPattern);
            }
        });
    }

    public Pattern getPattern() {
        return this.mPattern;
    }

    public int getMatchCount() {
        return this.mFound.size();
    }

    public int searchFor(Pattern pattern) {
        this.mPattern = pattern;
        this.mFound = new ArrayList();
        this.mActiveMatchIdx = -1;
        ListModel<?> model = this.mList.getModel();
        if (this.mPattern != null) {
            for (int i = 0; i < model.getSize(); ++i) {
                Object o = model.getElementAt(i);
                String s = this.mListItemToString.toString(o);
                if (s == null || !pattern.matcher(s).matches()) continue;
                this.mFound.add(i);
            }
        }
        this.fireReset();
        return this.mFound.size();
    }

    public int getListIndex(int matchIndex) {
        if (matchIndex < 0 || matchIndex >= this.mFound.size()) {
            return -1;
        }
        return this.mFound.get(matchIndex);
    }

    public int getActiveMatchIndex() {
        return this.mActiveMatchIdx;
    }

    public int getActiveListIndex() {
        return this.mActiveMatchIdx < 0 ? -1 : this.mFound.get(this.mActiveMatchIdx);
    }

    public void next() {
        ++this.mActiveMatchIdx;
        if (this.mActiveMatchIdx >= this.mFound.size()) {
            this.mActiveMatchIdx = this.mFound.size() > 0 ? 0 : -1;
        }
        this.activate(this.mActiveMatchIdx);
    }

    public void previous() {
        --this.mActiveMatchIdx;
        if (this.mActiveMatchIdx < 0) {
            this.mActiveMatchIdx = this.mFound.size() > 0 ? this.mFound.size() - 1 : -1;
        }
        this.activate(this.mActiveMatchIdx);
    }

    protected void activate(int matchIdx) {
        if (matchIdx < 0 || matchIdx >= this.mFound.size()) {
            return;
        }
        this.mList.clearSelection();
        int listIdx = this.mFound.get(matchIdx);
        this.mList.setSelectedIndex(listIdx);
        this.mList.ensureIndexIsVisible(listIdx);
        this.fireActivateMatch(listIdx);
    }

    protected void fireReset() {
        for (ActivateListener l : this.mActivateListeners) {
            l.reset();
        }
    }

    protected void fireActivateMatch(int listIdx) {
        for (ActivateListener l : this.mActivateListeners) {
            l.activateMatch(listIdx);
        }
    }

    public void addUpdateListener(ActivateListener l) {
        this.mActivateListeners.add(l);
    }

    public void removeActivateListener(ActivateListener l) {
        this.mActivateListeners.remove(l);
    }

    public static class UI
    extends JPanel {
        protected RegexFilterField mFilterField;
        protected JButton mBtnPrev;
        protected JButton mBtnNext;
        protected JLabel mLblStatus;
        protected AListSearcher mSearcher;

        public UI(String label, JList<?> list, ListItemToString itemToString) {
            GridBagManager l = GridBagManager.layout((Container)this);
            if (label != null) {
                l.add(label);
            }
            this.mFilterField = (RegexFilterField)l.add((Component)new RegexFilterField(new RegexFilterField.FilterListener(){

                public void filter(Pattern pattern) {
                    if (pattern == null) {
                        mSearcher.searchFor(null);
                        return;
                    }
                    Pattern curPattern = mSearcher.getPattern();
                    if (curPattern == null || !curPattern.pattern().equals(pattern.pattern())) {
                        mSearcher.searchFor(pattern);
                    }
                    mSearcher.next();
                }
            }), (GridBagConstraints)GridBagManager.FILLX);
            this.mFilterField.setDotStarIsNone(false);
            this.mBtnPrev = (JButton)l.add((Component)new JButton(), (GridBagConstraints)GridBagManager.LEFT.noInsets());
            this.mBtnPrev.setMargin(new Insets(0, 0, 0, 0));
            this.mBtnNext = (JButton)l.add((Component)new JButton(), (GridBagConstraints)GridBagManager.LEFT.noInsets());
            this.mBtnNext.setMargin(new Insets(0, 0, 0, 0));
            this.setButtonText("Previous", "Next");
            this.mSearcher = new AListSearcher(list, itemToString);
            this.mBtnPrev.setAction(this.mSearcher.Previous);
            this.mBtnNext.setAction(this.mSearcher.Next);
            this.mLblStatus = (JLabel)l.add((Component)new JLabel(), (GridBagConstraints)GridBagManager.LEFT.insets(0, 2, 0, 1));
            this.mSearcher.addUpdateListener(new ActivateListener(){

                @Override
                public void reset() {
                    this.activateMatch(-1);
                }

                @Override
                public void activateMatch(int listIndex) {
                    if (mSearcher.getPattern() == null || mSearcher.getPattern().pattern() == null || mSearcher.getPattern().pattern().length() == 0) {
                        mLblStatus.setText(null);
                    } else {
                        String s = String.format("%d/%d", mSearcher.getActiveMatchIndex() + 1, mSearcher.getMatchCount());
                        mLblStatus.setText(s);
                    }
                }
            });
        }

        public void setButtonIcons(Icon prev, Icon prevDisabled, Icon next, Icon nextDisabled) {
            this.mBtnPrev.setIcon(prev);
            if (prevDisabled != null) {
                this.mBtnPrev.setDisabledIcon(prevDisabled);
            }
            this.mBtnNext.setIcon(next);
            if (nextDisabled != null) {
                this.mBtnNext.setDisabledIcon(nextDisabled);
            }
        }

        public void setButtonText(String prev, String next) {
            this.mBtnPrev.setText(prev);
            this.mBtnNext.setText(next);
        }

        @Override
        public void requestFocus() {
            UI nf;
            Component curFocus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (curFocus != null && (nf = (UI)UIUtil.getAncestorOfType((Component)curFocus, UI.class)) != null && nf == this) {
                return;
            }
            this.mFilterField.requestFocus();
        }
    }

    public static interface ActivateListener {
        public void reset();

        public void activateMatch(int var1);
    }

    public static interface ListItemToString {
        public String toString(Object var1);
    }
}

