/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import com.sigrity.acl.AFileExplorer;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.AclInfo;
import com.sigrity.acl.MutableInteger;
import com.sigrity.acl.app.ABuildInfo;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.log.ALogElement;
import com.sigrity.acl.log.ALogElementRegistry;
import com.sigrity.acl.ui.ADecoratedIcon;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.log.ALogHelper;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;

public class ALogPanel
extends JPanel {
    protected static final Icon ICON_ERR = UIUtil.ICON_ERR;
    protected static final Icon ICON_WARN = UIUtil.ICON_WARN;
    protected static final Icon ICON_INFO = UIUtil.ICON_INFO;
    protected static final Icon ICON_DEBUG = UIUtil.ICON_DEBUG;
    protected static final Icon ICON_ERR_MORE = new ADecoratedIcon(ICON_ERR, UIUtil.ICON_MORE);
    protected static final Icon ICON_WARN_MORE = new ADecoratedIcon(ICON_WARN, UIUtil.ICON_MORE);
    protected static final Icon ICON_INFO_MORE = new ADecoratedIcon(ICON_INFO, UIUtil.ICON_MORE);
    protected static final Icon ICON_DEBUG_MORE = new ADecoratedIcon(ICON_DEBUG, UIUtil.ICON_MORE);
    public static final String SettingSection = ALogPanel.class.getName();
    public static final String SettingPaintImmediately = "PaintImmediately";
    public static final boolean SettingPaintImmediately_Default = true;
    private Map<ALog.ALogLevel, MutableInteger> mLogStat = new HashMap<ALog.ALogLevel, MutableInteger>();
    protected Model mModel;
    protected JTable mTable;
    protected JScrollPane mScrollPane;
    protected boolean mPaintImmediatelyOnLog = (Boolean)Settings.get((String)SettingSection, (String)"PaintImmediately", (Object)true);
    protected TableCellRenderer mIconCellRenderer = new DefaultTableCellRenderer(){

        @Override
        public void setValue(Object value) {
            if (!(value instanceof Entry)) {
                return;
            }
            this.setText(null);
            Entry e = (Entry)value;
            if (e.mLogLevel == ALog.LVL_ERR) {
                this.setIcon(e.mThrowable == null ? ICON_ERR : ICON_ERR_MORE);
            } else if (e.mLogLevel == ALog.LVL_WARN) {
                this.setIcon(e.mThrowable == null ? ICON_WARN : ICON_WARN_MORE);
            } else if (e.mLogLevel == ALog.LVL_INFO) {
                this.setIcon(e.mThrowable == null ? ICON_INFO : ICON_INFO_MORE);
            } else if (e.mLogLevel == ALog.LVL_DEBUG) {
                this.setIcon(e.mThrowable == null ? ICON_DEBUG : ICON_DEBUG_MORE);
            }
        }
    };
    protected ClipboardOwner mClipboardOwner = new ClipboardOwner(){

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    };
    protected MouseListener mMouseListener = new MouseAdapter(){
        protected Point mRefPoint = null;
        protected JPopupMenu mContextMenu = this.createContextMenu();

        public JPopupMenu createContextMenu() {
            this.mContextMenu = new JPopupMenu();
            this.mContextMenu.add(new ActionClearAll());
            JMenu explorer = new JMenu("Reveal in Explorer");
            explorer.add(ALogPanel.newRevealLogFileAction());
            explorer.add(ALogPanel.newRevealCmdFileAction());
            this.mContextMenu.add(explorer);
            this.mContextMenu.addSeparator();
            this.mContextMenu.add(new AbstractAction("Details.."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rowIndex = ALogPanel.this.mTable.rowAtPoint(mRefPoint);
                    ALogPanel.this.showLogDetailUI(rowIndex);
                }
            });
            this.mContextMenu.add(new AbstractAction("Copy"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringBuilder data = new StringBuilder();
                    int row = ALogPanel.this.mTable.rowAtPoint(mRefPoint);
                    if (!ALogPanel.this.mTable.isRowSelected(row)) {
                        data = new StringBuilder(ALogPanel.this.getLogFullText(row, true));
                    } else {
                        int[] selRows;
                        for (int curRow : selRows = ALogPanel.this.mTable.getSelectedRows()) {
                            data.append(ALogPanel.this.getLogFullText(curRow, true) + "\n");
                        }
                    }
                    StringSelection transferable = new StringSelection(data.toString());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(transferable, ALogPanel.this.mClipboardOwner);
                }
            });
            if (AclInfo.getDebugMode()) {
                this.mContextMenu.add(new ActionSendReport());
            }
            return this.mContextMenu;
        }

        void showIfPopupTrigger(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.mRefPoint = mouseEvent.getPoint();
                try {
                    OrbitIO.getGuiWorkspace().getContextMenuWorkspace().beautify(this.mContextMenu);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mContextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (!e.isConsumed()) {
                this.showIfPopupTrigger(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (!e.isConsumed()) {
                this.showIfPopupTrigger(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 1) {
                Document doc;
                Point p = e.getPoint();
                int row = ALogPanel.this.mTable.rowAtPoint(p);
                int col = ALogPanel.this.mTable.columnAtPoint(p);
                if (col != 1) {
                    return;
                }
                Rectangle r = ALogPanel.this.mTable.getCellRect(row, col, false);
                Point relativePoint = new Point((int)(p.getX() - (double)r.x), (int)(p.getY() - (double)r.y));
                JTextPane pane = new JTextPane();
                pane.setContentType("text/html");
                pane.setText((String)ALogPanel.this.mModel.getValueAt(row, col));
                pane.setSize(r.getSize());
                int pos = pane.viewToModel2D(relativePoint);
                if (pos >= 0 && (doc = pane.getDocument()) instanceof HTMLDocument) {
                    Element el = ((HTMLDocument)doc).getCharacterElement(pos);
                    ALogElementRegistry.triggerAction((Element)el, (Component)e.getComponent(), (int)e.getX(), (int)e.getY());
                }
            }
            if (e.getClickCount() == 2) {
                this.mRefPoint = e.getPoint();
                int rowIndex = ALogPanel.this.mTable.rowAtPoint(this.mRefPoint);
                ALogPanel.this.showLogDetailUI(rowIndex);
            }
        }
    };
    protected Observer mObserver;
    private static RecordScriptAction sRecordAction;

    public ALogPanel(ALog.ALogger log) {
        super(new BorderLayout());
        this.setPreferredSize(new Dimension(400, 150));
        this.mModel = new Model();
        this.mTable = new JTable(this.mModel){

            @Override
            public String getToolTipText(MouseEvent event) {
                Point p = event.getPoint();
                int rowIndex = ALogPanel.this.mTable.rowAtPoint(p);
                return "" + this.getValueAt(rowIndex, 1);
            }

            @Override
            public Point getToolTipLocation(MouseEvent event) {
                Point p = event.getPoint();
                int rowIndex = ALogPanel.this.mTable.rowAtPoint(p);
                Rectangle rect = ALogPanel.this.mTable.getCellRect(rowIndex, 1, true);
                return rect.getLocation();
            }
        };
        this.mTable.setFocusable(false);
        TableColumn c = this.mTable.getColumnModel().getColumn(0);
        c.setPreferredWidth(20);
        c.setMinWidth(20);
        c.setMaxWidth(20);
        c.setCellRenderer(this.mIconCellRenderer);
        this.mTable.setTableHeader(null);
        this.mTable.setShowGrid(false);
        this.mTable.addMouseListener(this.mMouseListener);
        this.mObserver = new Observer();
        log.addObserver((ALog.ALogObserverElements)this.mObserver);
        this.mScrollPane = new JScrollPane(this.mTable);
        this.add(this.mScrollPane);
    }

    public Observer getObserver() {
        return this.mObserver;
    }

    protected String getLogFullText(Point p, boolean includeThrowable) {
        int rowIndex = this.mTable.rowAtPoint(p);
        return this.getLogFullText(rowIndex, includeThrowable);
    }

    protected String getLogFullText(int rowIndex, boolean includeThrowable) {
        if (rowIndex < 0) {
            return "";
        }
        Entry entry = (Entry)this.mTable.getValueAt(rowIndex, 0);
        Object[] args = new Object[]{entry.mTimeStamp, entry.mLogLevel.getPrefix(), entry.mLogLevel.getDesc(), entry.mText};
        String text = ALog.ALogDefaultObserver.FMT_DT_DESC.format(args);
        if (includeThrowable) {
            text = ALog.appendThrowableToMessage((Throwable)entry.mThrowable, (String)text);
        }
        return text;
    }

    public void clearMessages() {
        this.mModel.clear();
        this.mLogStat.clear();
        this.notifyState();
    }

    private Icon getIcon() {
        MutableInteger warn;
        Icon c = UIUtil.getScaledIcon((Icon)OrbitIcons.CONSOLE, (int)16, (int)16);
        MutableInteger error = this.mLogStat.get(ALog.LVL_ERR);
        if (error != null && error.get() > 0) {
            c = new ADecoratedIcon(c, UIUtil.getScaledIcon((Icon)ICON_ERR, (int)8, (int)8), ADecoratedIcon.POSX.RIGHT, ADecoratedIcon.POSY.BOTTOM);
        }
        if ((warn = this.mLogStat.get(ALog.LVL_WARN)) != null && warn.get() > 0) {
            c = new ADecoratedIcon(c, UIUtil.getScaledIcon((Icon)ICON_WARN, (int)8, (int)8), ADecoratedIcon.POSX.RIGHT, ADecoratedIcon.POSY.TOP);
        }
        return c;
    }

    private void notifyState() {
        OrbitIO app = OrbitIO.getApp();
        if (app == null || !OrbitIO.getInitializationComplete()) {
            return;
        }
        OrbitGuiWS ws = app.getWorkspace();
        if (ws != null) {
            DefaultSingleCDockable d = ws.getSingleDockable(OrbitGuiWS.DOCK_ID_CMD_MSG);
            Icon newIcon = this.getIcon();
            d.setTitleIcon(newIcon);
            ws.getDockToolBar().updateTitleIcon(d, newIcon);
        }
    }

    private static Action newRevealLogFileAction() {
        ALog.ALogFile logFile = OrbitIO.getApp().getDefaultLogFile();
        File file = logFile == null ? null : logFile.getFile();
        return new AFileExplorer.BrowseFileDirectoryAction("Log File", file);
    }

    private static Action newRevealCmdFileAction() {
        File cmdFile = OrbitIO.getApp().getCmdLogFile();
        return new AFileExplorer.BrowseFileDirectoryAction("Command File", cmdFile);
    }

    private void showLogDetailUI(int rowIndex) {
        String data = this.getLogFullText(rowIndex, true);
        Window w = UIUtil.getParentWindow((Component)this);
        AFloatWindow fw = w != null ? new AFloatWindow(w) : new AFloatWindow();
        fw.setTitle("Log Entry Details");
        Container contents = fw.getContentPane();
        contents.setLayout(new BorderLayout());
        final JTextArea textArea = new JTextArea(data);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        JScrollPane sp = new JScrollPane(textArea);
        sp.setHorizontalScrollBarPolicy(30);
        sp.setVerticalScrollBarPolicy(20);
        contents.add((Component)sp, "Center");
        sp.setMinimumSize(new Dimension(50, 50));
        Dimension size = sp.getPreferredSize();
        size.width = Math.max(50, Math.min(size.width, 600));
        size.height = Math.max(50, Math.min(size.height, 400));
        sp.setPreferredSize(size);
        fw.pack();
        Rectangle rect = this.mTable.getCellRect(rowIndex, 1, true);
        Point loc = rect.getLocation();
        loc.y += rect.height;
        SwingUtilities.convertPointToScreen(loc, this.mTable);
        fw.setLocation(loc);
        UIUtil.verifyWindowOnScreen((Window)((Object)fw));
        final JCheckBoxMenuItem cbmiWrap = new JCheckBoxMenuItem("Wrap"){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                super.fireActionPerformed(event);
                textArea.setLineWrap(!textArea.getLineWrap());
            }
        };
        JPopupMenu popup = new JPopupMenu(){

            @Override
            public void menuSelectionChanged(boolean isIncluded) {
                super.menuSelectionChanged(isIncluded);
                if (isIncluded) {
                    cbmiWrap.setSelected(textArea.getLineWrap());
                }
            }
        };
        popup.add(cbmiWrap);
        UIUtil.installPopupMenu((Component)textArea, (JPopupMenu)popup);
        fw.setVisible(true);
    }

    public static RecordScriptAction getRecordScriptAction() {
        return sRecordAction;
    }

    static {
        ALogHelper.register();
        sRecordAction = new RecordScriptAction();
    }

    public static class RecordScriptAction
    extends AbstractAction {
        protected boolean mIsRecording = false;
        protected List<String> mCmds = null;
        protected Cp.Listener mCpListener = new Cp.Listener(){

            public void cmdStart(String cmd, boolean record) {
            }

            public void cmdEnd(String cmd, boolean record) {
                if (mCmds != null && record) {
                    mCmds.add(cmd);
                }
            }
        };
        private List<Consumer<Boolean>> mConsumers = new LinkedList<Consumer<Boolean>>();
        private File mScriptFile;
        private File mBackupReferFile;
        private Cp.FileExpr mBackupFileExpr;

        public RecordScriptAction() {
            super("Record Script", UIUtil.getScaledIcon((Icon)OrbitIcons.RECORD_SCRIPT, (int)16, (int)16));
            this.putValue("ShortDescription", "Record commands in interval time");
        }

        private boolean setupRecorder() {
            RecordOptionDialog query = new RecordOptionDialog(OrbitIO.getMainWindow());
            query.setVisible(true);
            if (!query.isOK()) {
                return false;
            }
            Cp cp = OrbitIO.getApp().getCp();
            this.mCmds = new ArrayList<String>();
            cp.addListener(this.mCpListener);
            this.mScriptFile = query.getFile();
            this.mBackupFileExpr = Cp.getFileExpression();
            this.mBackupReferFile = Cp.getReferFilePath();
            if (query.isUseAbsolutePath()) {
                Cp.setFileExpression((Cp.FileExpr)Cp.FileExpr.ABSOLUTE);
            } else if (query.isUseRelativePath()) {
                Cp.setFileExpression((Cp.FileExpr)Cp.FileExpr.RELATIVE_SCRIPT);
                Cp.setReferFilePath((File)this.mScriptFile);
                Cp.getCp().setInterpreterValue("scriptDir", (Object)(this.mScriptFile.getAbsoluteFile().getParentFile() + File.separator));
            }
            return true;
        }

        private void stopRecorder() {
            Cp cp = OrbitIO.getApp().getCp();
            cp.removeListener(this.mCpListener);
            Cp.setFileExpression((Cp.FileExpr)this.mBackupFileExpr);
            Cp.setReferFilePath((File)this.mBackupReferFile);
            try (FileWriter out = new FileWriter(this.mScriptFile);){
                out.write("// " + OrbitIO.getApp().getBuildVersion() + "," + OrbitIO.getApp().getBuildTimestamp());
                out.write("\n");
                for (String cmd : this.mCmds) {
                    out.write(cmd);
                    out.write("\n");
                }
                ALog.logInfo((String)"Save script to '%s'.", (Object[])new Object[]{this.mScriptFile});
            }
            catch (IOException err) {
                ALog.logError((Throwable)err, (String)"Error writing to file '%s'.", (Object[])new Object[]{this.mScriptFile});
            }
            this.mCmds = null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.mIsRecording) {
                this.putValue("Name", "Record Script");
                this.putValue("SmallIcon", UIUtil.getScaledIcon((Icon)OrbitIcons.RECORD_SCRIPT, (int)16, (int)16));
                this.mIsRecording = false;
                this.stopRecorder();
                this.fireChanged();
            } else if (this.setupRecorder()) {
                this.mIsRecording = true;
                this.fireChanged();
                this.putValue("Name", "Stop Recording Script");
                this.putValue("SmallIcon", UIUtil.getScaledIcon((Icon)OrbitIcons.RECORDING, (int)16, (int)16));
            }
        }

        public boolean isRecording() {
            return this.mIsRecording;
        }

        public void register(Consumer<Boolean> consumer) {
            this.mConsumers.add(consumer);
        }

        private void fireChanged() {
            try {
                this.mConsumers.forEach(e -> e.accept(this.mIsRecording));
            }
            catch (Exception e2) {
                ALog.logDebug((Throwable)e2, (String)"Ignored UI trigger", (Object[])new Object[0]);
            }
        }

        public class RecordOptionDialog
        extends ADialog {
            private final AFileChooserControl mFileChooser;
            private boolean mOK;
            private final JRadioButton mAbsolutePath;
            private final JRadioButton mRelativePath;

            public RecordOptionDialog(Window owner) {
                super(owner, "Record Script");
                this.mOK = false;
                this.setModal(true);
                GridBagManager l = new GridBagManager(this.getContentPane());
                l.pushFillX("Script");
                l.add("File:");
                this.mFileChooser = (AFileChooserControl)l.add((Component)new AFileChooserControl(), (GridBagConstraints)GridBagManager.FILLX);
                this.mFileChooser.setChoosableFileFilter(OrbitIO.SCRIPT_FILE_FILTER);
                this.mFileChooser.setUseSaveChooser(true);
                l.pop();
                l.newline();
                this.mAbsolutePath = new JRadioButton("Absolute");
                this.mRelativePath = new JRadioButton("Relative");
                ButtonGroup pathGroup = new ButtonGroup();
                pathGroup.add(this.mAbsolutePath);
                pathGroup.add(this.mRelativePath);
                this.mAbsolutePath.setSelected(true);
                this.mRelativePath.setToolTipText("Relative to the location of script file path");
                l.pushFillX("Options");
                l.add("Record File Path:");
                l.add((Component)this.mAbsolutePath);
                l.newline();
                l.indent();
                l.add((Component)this.mRelativePath);
                l.addFillX();
                l.pop();
                l.newline();
                l.pushFillXRemainX();
                l.addFillX();
                JButton btnOK = (JButton)l.add((Component)new JButton("OK"));
                btnOK.addActionListener(e -> {
                    this.mOK = true;
                    UIUtil.closeWindow((Window)((Object)this));
                });
                JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
                l.pop();
                this.setMinimumSize(this.getPreferredSize());
                UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOK);
                this.pack();
                UIUtil.center((Component)((Object)this));
            }

            public boolean isOK() {
                if (this.mFileChooser.getTextField().getText().isBlank()) {
                    return false;
                }
                return this.mOK;
            }

            public File getFile() {
                return new File(this.mFileChooser.getTextField().getText());
            }

            public boolean isUseAbsolutePath() {
                return this.mAbsolutePath.isSelected();
            }

            public boolean isUseRelativePath() {
                return this.mRelativePath.isSelected();
            }
        }
    }

    protected static class Model
    extends AbstractTableModel {
        protected ArrayList<Entry> mData = new ArrayList();

        protected Model() {
        }

        public void addEntry(Entry e) {
            this.mData.add(e);
            int newRowIdx = this.mData.size() - 1;
            this.fireTableRowsInserted(newRowIdx, newRowIdx);
        }

        public void clear() {
            this.mData.clear();
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.mData.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Entry e = this.mData.get(rowIndex);
            if (columnIndex == 1) {
                return e.getRenderText();
            }
            return e;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 1) {
                return "Description";
            }
            return "";
        }
    }

    protected static class Entry {
        protected final Date mTimeStamp;
        protected final ALog.ALogLevel mLogLevel;
        protected final Throwable mThrowable;
        protected final String mText;
        protected final String mFormatString;
        protected final Object[] mFormatArgs;

        public Entry(Date timeStamp, ALog.ALogLevel level, Throwable t, String msg, String formatString, Object[] formatArgs) {
            this.mTimeStamp = timeStamp;
            this.mLogLevel = level;
            this.mThrowable = t;
            this.mText = msg;
            this.mFormatString = formatString;
            this.mFormatArgs = formatArgs;
        }

        public String getRenderText() {
            if (this.mFormatArgs == null || this.mFormatArgs.length == 0) {
                return this.mText;
            }
            if (!this.hasSource()) {
                return this.mText;
            }
            Object[] objs = new Object[this.mFormatArgs.length];
            System.arraycopy(this.mFormatArgs, 0, objs, 0, this.mFormatArgs.length);
            for (int i = 0; i < objs.length; ++i) {
                Object obj = objs[i];
                ALogElement el = ALogElementRegistry.getALogElement((Object)obj);
                if (el != null) {
                    objs[i] = el.getHtmlText();
                    continue;
                }
                if (!(obj instanceof String)) continue;
                objs[i] = AUtil.escapeHtml((String)("" + obj));
            }
            try {
                return "<html>" + String.format(this.mFormatString, objs) + "</html>";
            }
            catch (Exception e) {
                assert (false);
                return this.mText;
            }
        }

        public boolean hasSource() {
            for (Object obj : this.mFormatArgs) {
                if (ALogElementRegistry.getALogElement((Object)obj) == null) continue;
                return true;
            }
            return false;
        }
    }

    private class ActionSendReport
    extends AbstractAction {
        public ActionSendReport() {
            super("Send Report...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StringBuilder data = new StringBuilder();
            data.append(String.format("Build: %s, %s\n", ABuildInfo.getVersion(), ABuildInfo.getTimestamp()));
            data.append("===================================================\n\n");
            int[] selRows = ALogPanel.this.mTable.getSelectedRows();
            if (selRows != null) {
                for (int curRow : selRows) {
                    data.append(ALogPanel.this.getLogFullText(curRow, true) + "\n");
                }
            }
            try {
                String title = URLEncoder.encode("OrbitIO: Log Report", "UTF-8").replace("+", "%20");
                String body = URLEncoder.encode(data.toString(), "UTF-8").replace("+", "%20");
                Desktop.getDesktop().mail(new URI("mailto:morrisy@cadence.com?subject=" + title + "&body=" + body));
            }
            catch (Exception err) {
                ALog.logWarn((String)"Your OS does not support 'mail' action");
            }
        }
    }

    protected class ActionClearAll
    extends AbstractAction {
        public ActionClearAll() {
            super("Clear All");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ALogPanel.this.clearMessages();
        }
    }

    public class Observer
    extends ALog.ALogDefaultFilter
    implements ALog.ALogObserverElements {
        ArrayList<Entry> mLogBuffer = new ArrayList();

        public Observer() {
            Executors.newSingleThreadExecutor().execute(() -> {
                while (true) {
                    this.task();
                    try {
                        Thread.sleep(30L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        ALog.logError((Throwable)e);
                        continue;
                    }
                    break;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void logBatch() {
            if (this.mLogBuffer.isEmpty()) {
                return;
            }
            try {
                ArrayList<Entry> arrayList = this.mLogBuffer;
                synchronized (arrayList) {
                    for (Entry e : this.mLogBuffer) {
                        ALogPanel.this.mModel.addEntry(e);
                    }
                    this.mLogBuffer.clear();
                }
                ALogPanel.this.mTable.scrollRectToVisible(ALogPanel.this.mTable.getCellRect(ALogPanel.this.mModel.getRowCount() - 1, 0, true));
                ALogPanel.this.mScrollPane.paintImmediately(ALogPanel.this.mScrollPane.getBounds());
                ALogPanel.this.notifyState();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        protected void task() {
            if (this.mLogBuffer.isEmpty()) {
                return;
            }
            if (EventQueue.isDispatchThread()) {
                boolean isPainting = UIUtil.isPainting((JComponent)ALogPanel.this);
                if (!isPainting) {
                    this.logBatch();
                } else {
                    EventQueue.invokeLater(this::logBatch);
                }
            } else {
                EventQueue.invokeLater(this::logBatch);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void log(ALog.ALogLevel level, Throwable t, String msg, String formatString, Object[] formatArgs) {
            if (!this.mOutputLevels.contains(level)) {
                return;
            }
            ArrayList<Entry> arrayList = this.mLogBuffer;
            synchronized (arrayList) {
                this.mLogBuffer.add(new Entry(new Date(), level, t, msg, formatString, formatArgs));
                if (level == ALog.LVL_ERR || level == ALog.LVL_WARN) {
                    MutableInteger cnt = ALogPanel.this.mLogStat.computeIfAbsent(level, k -> MutableInteger.create((int)0));
                    cnt.increment();
                }
            }
            if (ALogPanel.this.mPaintImmediatelyOnLog && EventQueue.isDispatchThread()) {
                this.task();
            }
        }
    }
}

