/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class ALookAndFeelSelector {
    public static void main(String[] args) {
        LAFSelDialog dlg = new LAFSelDialog(null);
        dlg.setVisible(true);
    }

    public static class LAFSelComboBox
    extends JComboBox<UIManager.LookAndFeelInfo> {
        public static final UIManager.LookAndFeelInfo SYSDEFAULT = new UIManager.LookAndFeelInfo("<Default>", UIManager.getCrossPlatformLookAndFeelClassName());

        public LAFSelComboBox() {
            super(new Model());
            this.setRenderer(new Renderer());
        }

        public boolean setSelLaf(String lafClassName) {
            if (lafClassName == null || lafClassName.length() == 0) {
                this.setSelectedIndex(0);
                return true;
            }
            for (int i = 1; i < this.getModel().getSize(); ++i) {
                if (!((UIManager.LookAndFeelInfo)this.getItemAt(i)).getClassName().equals(lafClassName)) continue;
                this.setSelectedIndex(i);
                return true;
            }
            return false;
        }

        public boolean getChanged() {
            UIManager.LookAndFeelInfo selLafInfo = (UIManager.LookAndFeelInfo)this.getModel().getSelectedItem();
            LookAndFeel curLaf = UIManager.getLookAndFeel();
            return !selLafInfo.getClassName().equals(curLaf.getClass().getName());
        }

        public String getSelectedLAF() {
            UIManager.LookAndFeelInfo selLafInfo = (UIManager.LookAndFeelInfo)this.getModel().getSelectedItem();
            return selLafInfo.getClassName();
        }

        public boolean isDefaultSelected() {
            return this.getModel().getSelectedItem() == SYSDEFAULT;
        }

        public boolean apply() {
            if (this.getChanged()) {
                UIManager.LookAndFeelInfo selLafInfo = (UIManager.LookAndFeelInfo)this.getModel().getSelectedItem();
                return UIUtil.setLookAndFeel((String)selLafInfo.getClassName());
            }
            return false;
        }

        protected static class Renderer
        extends DefaultListCellRenderer {
            protected Renderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof UIManager.LookAndFeelInfo) {
                    UIManager.LookAndFeelInfo lafi = (UIManager.LookAndFeelInfo)value;
                    this.setText(lafi.getName());
                }
                return c;
            }
        }

        protected static class Model
        extends DefaultComboBoxModel<UIManager.LookAndFeelInfo> {
            public Model() {
                this.addElement(SYSDEFAULT);
                for (UIManager.LookAndFeelInfo i : UIManager.getInstalledLookAndFeels()) {
                    this.addElement(i);
                }
            }
        }
    }

    public static class LAFSelDialog
    extends ADialog {
        public LAFSelDialog(Component owner) {
            super(owner, "Select Look and Feel");
            this.setModal(true);
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.add("Look and Feel:");
            final LAFSelComboBox lafSelCbo = (LAFSelComboBox)l.add((Component)new LAFSelComboBox());
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnApply = (JButton)l.add((Component)new JButton("Apply"));
            JButton btnClose = (JButton)l.add((Component)new JButton("Close"));
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnApply);
            this.pack();
            UIUtil.center((Component)((Object)this));
            btnApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    lafSelCbo.apply();
                }
            });
        }
    }
}

