/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AMemStatus;
import com.sigrity.acl.Stopwatch;
import com.sigrity.acl.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.Timer;

public class AMemStatusComponent
extends JComponent {
    public static final String TEXT_START_GC = "Garbage collection in process...";
    public static final String TEXT_FINISH_GC = "Garbage collection complete, time elapsed %s.";
    public static final String TEXT_FINISH_MULTIPLE_GC = "Garbage collection complete, %d iterations, time elapsed %s.";
    protected int mUpdateDelay = 1000;
    protected AMemStatus.Stats mCurrent;
    protected Timer mTimer;
    protected boolean mDrawArmed = false;
    protected boolean mDrawPressed = false;
    protected JPopupMenu mPopupMenu = null;
    protected MouseAdapter mMouseHandler = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            AMemStatusComponent.this.mDrawArmed = true;
            AMemStatusComponent.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AMemStatusComponent.this.mDrawArmed = false;
            AMemStatusComponent.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup(e);
            }
            if (e.isConsumed()) {
                return;
            }
            if (e.getButton() == 1) {
                AMemStatusComponent.this.mDrawPressed = true;
                AMemStatusComponent.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            boolean wasPressed = AMemStatusComponent.this.mDrawPressed && AMemStatusComponent.this.mDrawArmed;
            AMemStatusComponent.this.mDrawPressed = false;
            AMemStatusComponent.this.repaint();
            if (e.isPopupTrigger()) {
                this.popup(e);
            }
            if (e.isConsumed()) {
                return;
            }
            if (wasPressed && e.getButton() == 1) {
                ALog.logInfo((String)AMemStatusComponent.TEXT_START_GC);
                Stopwatch sw = new Stopwatch();
                System.gc();
                sw.stop();
                ALog.logInfo((String)AMemStatusComponent.TEXT_FINISH_GC, (Object[])new Object[]{sw.elapsedStr()});
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup(e);
            }
        }

        protected void popup(MouseEvent e) {
            e.consume();
            if (AMemStatusComponent.this.mPopupMenu == null) {
                AMemStatusComponent.this.mPopupMenu = new JPopupMenu("Memory");
                AMemStatusComponent.this.mPopupMenu.add(new AbstractAction("Single garbage collection"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ALog.logInfo((String)AMemStatusComponent.TEXT_START_GC);
                        Stopwatch sw = new Stopwatch();
                        System.gc();
                        sw.stop();
                        ALog.logInfo((String)AMemStatusComponent.TEXT_FINISH_GC, (Object[])new Object[]{sw.elapsedStr()});
                    }
                });
                AMemStatusComponent.this.mPopupMenu.add(new AbstractAction("Multiple garbage collections"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ALog.logInfo((String)AMemStatusComponent.TEXT_START_GC);
                        Stopwatch sw = new Stopwatch();
                        int iterations = AMemStatus.gcMax();
                        sw.stop();
                        ALog.logInfo((String)AMemStatusComponent.TEXT_FINISH_MULTIPLE_GC, (Object[])new Object[]{iterations, sw.elapsedStr()});
                    }
                });
                AMemStatusComponent.this.mPopupMenu.add(new AbstractAction("Log status"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AMemStatus.logStatus();
                    }
                });
            }
            AMemStatusComponent.this.mPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    };

    public AMemStatusComponent() {
        Insets insets = this.getInsets();
        Dimension preferredSize = new Dimension(insets.left + insets.right, 16);
        this.setPreferredSize(preferredSize);
        this.setMinimumSize(preferredSize);
        this.setOpaque(true);
        this.setBackground(Color.BLACK);
        this.setFocusable(false);
        this.setToolTipText("(Click to garbage collect)");
    }

    protected void updateStats() {
        this.mCurrent = new AMemStatus.Stats();
        this.repaint();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.isVisible()) {
            this.startTimer();
        }
        this.addMouseListener(this.mMouseHandler);
        this.addMouseMotionListener(this.mMouseHandler);
    }

    @Override
    public void removeNotify() {
        this.stopTimer();
        this.removeMouseListener(this.mMouseHandler);
        this.removeMouseMotionListener(this.mMouseHandler);
        super.removeNotify();
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (flag) {
            this.startTimer();
        } else {
            this.stopTimer();
        }
    }

    protected void startTimer() {
        if (this.isTimerRuning()) {
            return;
        }
        if (this.getParent() == null) {
            return;
        }
        this.mTimer = new Timer(this.mUpdateDelay, e -> this.updateStats());
        this.updateStats();
        this.mTimer.start();
    }

    protected void stopTimer() {
        if (!this.isTimerRuning()) {
            return;
        }
        this.mTimer.stop();
        this.mTimer = null;
    }

    protected boolean isTimerRuning() {
        return this.mTimer != null;
    }

    protected Rectangle getPaintBounds() {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        return new Rectangle(insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
    }

    @Override
    protected void paintComponent(Graphics gIn) {
        super.paintComponent(gIn);
        Rectangle bounds = this.getPaintBounds();
        Graphics2D g = (Graphics2D)gIn.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setClip(bounds);
        g.setColor(this.getBackground());
        g.fill(bounds);
        AMemStatus.Stats cur = this.mCurrent;
        if (cur != null) {
            g.setFont(this.getFont());
            Rectangle rTextArea = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
            String text = AMemStatus.getMemInfo((long)cur.getUsedMemory(), (long)cur.getAllocMemory());
            Rectangle2D rTextBounds = UIUtil.getTextBounds((Graphics2D)g, (String)text);
            float x = (float)(rTextArea.x + rTextArea.width) - (float)Math.round(rTextBounds.getWidth());
            float y = (float)bounds.y + (float)bounds.height;
            g.setColor(this.getForeground());
            g.drawString(text, x, y);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return String.format("<html>Current status:<br/><div style='margin-left:12px'>%s</div>%s</html>", AMemStatus.getMemInfo((Runtime)Runtime.getRuntime()), super.getToolTipText());
    }
}

