/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JComponent;

public class AMultiLineDynamicGraph
extends JComponent {
    protected final int graphBorder = 0;
    protected int pipRadius = 40;
    static int colorIndex = 0;
    public static AMultiLineDynamicGraph theGeneticOptGraph = null;
    long maxSeconds;
    String statusMessage = null;
    protected HashMap<String, ConstraintDescriptor> nameToDescriptor = new HashMap();
    Rectangle graphArea = this.getBounds();

    public static Color nextColor() {
        Color[] stdTable = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.CYAN, Color.BLACK};
        Color retColor = stdTable[colorIndex];
        if (++colorIndex >= stdTable.length) {
            colorIndex = 0;
        }
        return retColor;
    }

    public void setMaxTime(long seconds) {
        this.maxSeconds = seconds;
    }

    public void addConstraintDef(String constraintName, Color c, boolean drawLine, int order) {
        ConstraintDescriptor cd = this.nameToDescriptor.get(constraintName);
        if (cd == null) {
            cd = new ConstraintDescriptor(constraintName);
            this.nameToDescriptor.put(constraintName, cd);
            cd.color = c;
            cd.valuesOverTime = new ConstraintValues();
            cd.drawLine = drawLine;
            cd.order = order;
        }
    }

    public void setConstraintValue(Long time, String constraintName, double val) {
        ConstraintDescriptor cd = this.nameToDescriptor.get(constraintName);
        if (cd == null) {
            cd = new ConstraintDescriptor(constraintName);
            this.nameToDescriptor.put(constraintName, cd);
            cd.valuesOverTime = new ConstraintValues();
            cd.color = AMultiLineDynamicGraph.nextColor();
        }
        cd.add(time, val);
    }

    public void setStatus(String status) {
        this.statusMessage = status;
    }

    public void updateGraph(String status) {
        this.statusMessage = status;
        this.paintComponent(this.getGraphics());
    }

    public void clear() {
        this.statusMessage = "Not Active";
        this.nameToDescriptor.clear();
        colorIndex = 0;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!(graphics instanceof Graphics2D)) {
            assert (false);
            return;
        }
        Graphics2D g = (Graphics2D)graphics;
        this.drawGraph(g);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    protected void drawGraph(Graphics2D g) {
        this.graphArea = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        Rectangle r = new Rectangle(this.graphArea);
        int pipSeconds = 20;
        this.pipRadius = r.width / 10;
        g.setColor(Color.WHITE);
        g.fillRect(this.graphArea.x, this.graphArea.y, this.graphArea.width, this.graphArea.height);
        g.setColor(new Color(0, 255, 0, 32));
        g.fillRect(this.graphArea.x, this.graphArea.y, this.graphArea.width, this.graphArea.height);
        g.setColor(Color.BLACK);
        g.drawRect(this.graphArea.x, this.graphArea.y, this.graphArea.width, this.graphArea.height);
        r.height -= this.pipRadius;
        r.width -= 5;
        r.height -= 5;
        if (this.maxSeconds == 0L) {
            return;
        }
        if (this.statusMessage != null && !this.statusMessage.isEmpty()) {
            int w = (int)UIUtil.getTextBounds((Graphics2D)g, (String)this.statusMessage).getWidth();
            int h = (int)UIUtil.getTextBounds((Graphics2D)g, (String)this.statusMessage).getHeight() + 2;
            int x = r.x + r.width / 2 - w / 2;
            int y = r.y + h;
            g.setColor(Color.black);
            g.drawString(this.statusMessage, x, y);
        }
        int ith = 1;
        long maxTime = 10L;
        for (String constraintName : this.nameToDescriptor.keySet()) {
            ConstraintDescriptor cd = this.nameToDescriptor.get(constraintName);
            if (cd == null || cd.maxTime == null) continue;
            maxTime = Math.max(maxTime, cd.maxTime);
        }
        double pixelsWPerSecond = (double)r.width / (double)maxTime;
        ArrayList<ConstraintDescriptor> sortedConstraints = new ArrayList<ConstraintDescriptor>();
        for (ConstraintDescriptor cd : this.nameToDescriptor.values()) {
            sortedConstraints.add(cd);
        }
        Collections.sort(sortedConstraints, new ConstraintSorter());
        long lastTime = 0L;
        double lastVal = 0.0;
        double pixelsHPerUnit = 0.0;
        int pipBottom = r.y + r.height;
        int pipTop = r.y;
        for (ConstraintDescriptor cd : sortedConstraints) {
            int y;
            int x;
            ++ith;
            if (cd.maxVal == null || cd.minVal == null) continue;
            double spread = cd.maxVal - cd.minVal;
            if (spread == 0.0) {
                spread = 10.0;
            }
            pixelsHPerUnit = (double)r.height / spread;
            g.setColor(cd.color.darker());
            boolean first = true;
            GeneralPath screenPath = new GeneralPath();
            for (ConstraintValue cv : cd.valuesOverTime) {
                x = (int)((double)cv.time.longValue() * pixelsWPerSecond);
                x = r.x + x;
                y = (int)((cv.value - cd.minVal) * pixelsHPerUnit);
                y = r.y + r.height - y;
                if (cv.time > 20L) {
                    pipBottom = Math.max(pipBottom, y);
                    pipTop = Math.min(pipTop, y);
                }
                if (first) {
                    screenPath.moveTo(x, y);
                } else {
                    screenPath.lineTo(x, y);
                }
                first = false;
                lastVal = cv.value;
                lastTime = Math.max(lastTime, cv.time);
            }
            if (cd.drawLine) {
                g.draw(screenPath);
            }
            String s = String.format("%s = %2.0f", cd.name, lastVal);
            String test = "X";
            x = r.x;
            y = r.y + ith * (int)(UIUtil.getTextBounds((Graphics2D)g, (String)test).getHeight() + 5.0);
            g.drawString(s, x, y);
        }
        long beginningTime = lastTime - 20L;
        if (beginningTime <= 0L) {
            return;
        }
        long smallRadius = 4L;
        Point pipCenter = new Point(r.x + r.width - this.pipRadius - r.height / 5, r.y + r.height - r.height / 3);
        g.setStroke(new BasicStroke(1.0f));
        APoint2D e = new APoint2D((long)(r.x + r.width) - smallRadius, (long)(r.y + r.height));
        g.setColor(new Color(255, 255, 255, 250));
        g.fillOval(pipCenter.x - this.pipRadius, pipCenter.y - this.pipRadius, this.pipRadius * 2, this.pipRadius * 2);
        g.setColor(new Color(0, 0, 0));
        g.drawOval(pipCenter.x - this.pipRadius, pipCenter.y - this.pipRadius, this.pipRadius * 2, this.pipRadius * 2);
        g.setColor(new Color(255, 255, 255, 16));
        g.fillOval((int)(e.getX() - smallRadius), (int)(e.getY() - smallRadius), (int)smallRadius * 2, (int)smallRadius * 2);
        g.setColor(new Color(0, 0, 0));
        g.drawOval((int)(e.getX() - smallRadius), (int)(e.getY() - smallRadius), (int)smallRadius * 2, (int)smallRadius * 2);
        ALine v = new ALine(e.getX(), e.getY(), (long)pipCenter.getX(), (long)pipCenter.getY());
        double aV = v.getAngle();
        double a1 = aV - 90.0;
        double aR = Math.toRadians(a1);
        double dxLarge = Math.cos(aR) * (double)this.pipRadius;
        double dyLarge = Math.sin(aR) * (double)this.pipRadius;
        double dxSmall = Math.cos(aR) * (double)smallRadius;
        double dySmall = Math.sin(aR) * (double)smallRadius;
        ALine v1 = new ALine((long)((int)((double)v.getP1().getX() + dxLarge)), (long)((int)((double)v.getP1().getY() + dyLarge)), (long)((int)((double)v.getP0().getX() + dxSmall)), (long)((int)((double)v.getP0().getY() + dySmall)));
        ALine v2 = new ALine((long)((int)((double)v.getP1().getX() - dxLarge)), (long)((int)((double)v.getP1().getY() - dyLarge)), (long)((int)((double)v.getP0().getX() - dxSmall)), (long)((int)((double)v.getP0().getY() - dySmall)));
        GeneralPath sp = new GeneralPath();
        sp.moveTo(v1.getP0().getX(), v1.getP0().getY());
        sp.lineTo(v1.getP1().getX(), v1.getP1().getY());
        sp.moveTo(v2.getP0().getX(), v2.getP0().getY());
        sp.lineTo(v2.getP1().getX(), v2.getP1().getY());
        g.draw(sp);
        for (ConstraintDescriptor cd : sortedConstraints) {
            if (!cd.drawLine) continue;
            boolean first = true;
            double maxVal = 0.0;
            double minVal = 0.0;
            first = true;
            for (ConstraintValue cv : cd.valuesOverTime) {
                if (cv.time < beginningTime) continue;
                if (first) {
                    maxVal = cv.value;
                    minVal = cv.value;
                    first = false;
                    continue;
                }
                maxVal = Math.max(cv.value, maxVal);
                minVal = Math.min(cv.value, minVal);
            }
            GeneralPath screenPath = new GeneralPath();
            double pps = (double)(this.pipRadius * 2 - 1) / 20.0;
            double ppv = ((double)this.pipRadius / 2.0 - 1.0) / (maxVal - minVal);
            g.setColor(cd.color);
            first = true;
            for (ConstraintValue cv : cd.valuesOverTime) {
                if (cv.time < beginningTime) continue;
                int x = (int)((double)(cv.time - beginningTime) * pps);
                x = pipCenter.x + x - this.pipRadius;
                int y = (int)((cv.value - minVal) * ppv);
                y = pipCenter.y - y;
                int dist = (int)Math.sqrt(Math.pow(x - pipCenter.x, 2.0) + Math.pow(y - pipCenter.y, 2.0));
                if (dist > this.pipRadius) continue;
                if (first) {
                    screenPath.moveTo(x, y);
                } else {
                    screenPath.lineTo(x, y);
                }
                first = false;
            }
            g.setStroke(new BasicStroke(2.0f));
            g.draw(screenPath);
        }
    }

    public static class ConstraintSorter
    implements Comparator<ConstraintDescriptor> {
        @Override
        public int compare(ConstraintDescriptor o1, ConstraintDescriptor o2) {
            int d = Integer.compare(o1.order, o2.order);
            if (d != 0) {
                return d;
            }
            return o1.name.compareTo(o2.name);
        }
    }

    static class ConstraintValues
    extends LinkedList<ConstraintValue> {
        ConstraintValues() {
        }

        public void add(Long time, double val) {
            ConstraintValue cv = new ConstraintValue(time, val);
            this.add(cv);
        }
    }

    static class ConstraintValue {
        Long time;
        double value;

        public ConstraintValue(Long time, double value) {
            this.time = time;
            this.value = value;
        }
    }

    static class ConstraintDescriptor {
        String name;
        ConstraintValues valuesOverTime;
        Double minVal = null;
        Double maxVal = null;
        Long minTime = null;
        Long maxTime = null;
        Color color;
        int order = 0;
        boolean drawLine = true;

        public ConstraintDescriptor(String name) {
            this.name = name;
        }

        public void add(Long time, double val) {
            this.minVal = this.minVal == null ? Double.valueOf(val) : Double.valueOf(Math.min(this.minVal, val));
            this.maxVal = this.maxVal == null ? Double.valueOf(val) : Double.valueOf(Math.max(this.maxVal, val));
            this.minTime = this.minTime == null ? time : Long.valueOf(Math.min(this.minTime, time));
            this.maxTime = this.maxTime == null ? time : Long.valueOf(Math.max(this.maxTime, time));
            this.valuesOverTime.add(time, val);
        }
    }
}

