/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.ADrawPatterns;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.ui.AColorChooserDlg;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class APatternColorChooser
extends ADialog {
    private Color mReturnColor;
    private ADrawPatterns.PATTERN mReturnPattern;
    private ButtonGroup mColorGroup = new ButtonGroup();
    private ButtonGroup mPatternGroup = new ButtonGroup();
    private boolean mOK = false;

    public static APatternColorChooser show(Component w, String title, APatternColor pColor) {
        APatternColorChooser d = null;
        d = new APatternColorChooser(w instanceof Window ? (Window)w : null, pColor);
        d.setTitle(title);
        d.setVisible(true);
        return d;
    }

    public APatternColorChooser(Window w, APatternColor pColor) {
        super(w);
        this.mReturnColor = pColor == null ? Color.WHITE : pColor.getColor();
        this.mReturnPattern = pColor == null ? ADrawPatterns.PATTERN.SOLID : pColor.getPattern();
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        l.addFillX();
        l.addFillX();
        l.add("Custom", (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new GridLayout(1, 10));
        Color[] cList = new Color[]{Color.WHITE, Color.RED, Color.GREEN, Color.BLUE, Color.YELLOW, Color.PINK, Color.CYAN, Color.ORANGE, Color.MAGENTA};
        boolean match = false;
        for (Color c : cList) {
            JToggleButton btn = new JToggleButton((Icon)new AColorIcon(20, 20, c));
            this.mColorGroup.add(btn);
            UIUtil.makeToolBarButton((AbstractButton)btn);
            if (c.equals(this.mReturnColor)) {
                btn.setSelected(true);
                match = true;
            }
            btn.addItemListener(e -> {
                if (btn.isSelected()) {
                    this.mReturnColor = c;
                }
            });
            colorPanel.add(btn);
        }
        JToggleButton custom = new JToggleButton((Icon)new AColorIcon(20, 20, this.mReturnColor));
        custom.setToolTipText("Custom");
        this.mColorGroup.add(custom);
        if (!match) {
            custom.setSelected(true);
        }
        UIUtil.makeToolBarButton((AbstractButton)custom);
        custom.addActionListener(e -> {
            AColorChooserDlg dlg = AColorChooserDlg.createDialog((Component)((Object)this), "Choose Custom Color", this.mReturnColor);
            Color c = dlg.doModal();
            if (c != null) {
                this.mReturnColor = c;
                custom.setIcon((Icon)new AColorIcon(20, 20, c));
            }
        });
        l.add("Color:");
        l.add((Component)colorPanel);
        l.add((Component)custom, (GridBagConstraints)GridBagManager.CENTER);
        JPanel patternPanel = new JPanel();
        patternPanel.setLayout(new GridLayout(3, 10));
        for (ADrawPatterns.PATTERN p : ADrawPatterns.PATTERN.values()) {
            APatternColor pc = APatternColor.create((Color)Color.BLACK, (ADrawPatterns.PATTERN)p);
            JToggleButton btn = new JToggleButton(UIUtil.getScaledIcon((Icon)pc.getIcon(), (int)20, (int)20));
            btn.addItemListener(e -> {
                if (btn.isSelected()) {
                    this.mReturnPattern = p;
                }
            });
            btn.setToolTipText(p.name());
            this.mPatternGroup.add(btn);
            UIUtil.makeToolBarButton((AbstractButton)btn);
            if (p == this.mReturnPattern) {
                btn.setSelected(true);
            }
            patternPanel.add(btn);
        }
        l.newline();
        l.add("Pattern:");
        l.add((Component)patternPanel);
        l.newline();
        l.push((GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton mBtnOK = new JButton("OK");
        l.add((Component)mBtnOK, (GridBagConstraints)GridBagManager.RIGHT);
        mBtnOK.addActionListener(e -> {
            this.mOK = true;
            UIUtil.closeWindow((Window)((Object)this));
        });
        JButton mBtnCancel = new JButton("Cancel");
        l.add((Component)mBtnCancel, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        this.setResizable(false);
        this.setModal(true);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)mBtnCancel, (JButton)mBtnOK);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
    }

    public boolean isOK() {
        return this.mOK;
    }

    public APatternColor getPatternColor() {
        return APatternColor.create((Color)this.mReturnColor, (ADrawPatterns.PATTERN)this.mReturnPattern);
    }
}

