/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;

public class AStrokeFactory {
    public static final int INWARD_STROKE = 0;
    public static final int OUTWARD_STROKE = 1;
    private static final float FLATNESS = 1.0f;

    public static Stroke createComposite(final Stroke a, final Stroke b) {
        return new Stroke(){

            @Override
            public Shape createStrokedShape(Shape s) {
                return b.createStrokedShape(a.createStrokedShape(s));
            }
        };
    }

    public static Stroke createInOutwardStroke(Stroke base, int direction) {
        return new InOutwardStroke(base, 10.0f, 10.0f, direction);
    }

    public static class InOutwardStroke
    implements Stroke {
        private float amplitude = 10.0f;
        private float wavelength = 10.0f;
        private int direction = 0;
        private Stroke stroke;

        private static float measurePathLength(Shape shape) {
            FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
            float[] points = new float[6];
            float moveX = 0.0f;
            float moveY = 0.0f;
            float lastX = 0.0f;
            float lastY = 0.0f;
            float thisX = 0.0f;
            float thisY = 0.0f;
            int type = 0;
            float total = 0.0f;
            while (!it.isDone()) {
                type = it.currentSegment(points);
                switch (type) {
                    case 0: {
                        moveX = lastX = points[0];
                        moveY = lastY = points[1];
                        break;
                    }
                    case 4: {
                        points[0] = moveX;
                        points[1] = moveY;
                    }
                    case 1: {
                        thisX = points[0];
                        thisY = points[1];
                        float dx = thisX - lastX;
                        float dy = thisY - lastY;
                        total += (float)Math.sqrt(dx * dx + dy * dy);
                        lastX = thisX;
                        lastY = thisY;
                    }
                }
                it.next();
            }
            return total;
        }

        public InOutwardStroke(Stroke stroke, float amplitude, float wavelength, int direction) {
            this.stroke = stroke;
            this.amplitude = amplitude;
            this.wavelength = wavelength;
            this.direction = direction;
        }

        @Override
        public Shape createStrokedShape(Shape shape) {
            boolean valid = InOutwardStroke.measurePathLength(shape) > this.amplitude * 5.0f;
            GeneralPath result = new GeneralPath();
            FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
            float[] points = new float[6];
            float moveX = 0.0f;
            float moveY = 0.0f;
            float lastX = 0.0f;
            float lastY = 0.0f;
            float thisX = 0.0f;
            float thisY = 0.0f;
            int type = 0;
            float next = 0.0f;
            while (!it.isDone()) {
                type = it.currentSegment(points);
                switch (type) {
                    case 0: {
                        moveX = lastX = points[0];
                        moveY = lastY = points[1];
                        result.moveTo(moveX, moveY);
                        next = this.wavelength / 2.0f;
                        break;
                    }
                    case 4: {
                        points[0] = moveX;
                        points[1] = moveY;
                    }
                    default: {
                        thisX = points[0];
                        thisY = points[1];
                        float dx = thisX - lastX;
                        float dy = thisY - lastY;
                        float distance = (float)Math.sqrt(dx * dx + dy * dy);
                        if (distance >= next && valid) {
                            float r = 1.0f / distance;
                            while (distance >= next) {
                                float x = lastX + next * dx * r;
                                float y = lastY + next * dy * r;
                                result.lineTo(x, y);
                                if (this.direction == 0) {
                                    result.lineTo(x + this.amplitude * (-dy + dx) / 2.0f * r, y + this.amplitude * (dx + dy) / 2.0f * r);
                                } else {
                                    result.lineTo(x + this.amplitude * (dy + dx) / 2.0f * r, y + this.amplitude * (-dx + dy) / 2.0f * r);
                                }
                                result.lineTo(x, y);
                                next += this.wavelength;
                            }
                        } else {
                            result.lineTo(thisX, thisY);
                        }
                        next -= distance;
                        lastX = thisX;
                        lastY = thisY;
                        if (type != 4) break;
                        result.closePath();
                    }
                }
                it.next();
            }
            return this.stroke.createStrokedShape(result);
        }
    }
}

