/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.GridBagManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ATabbedPane
extends JTabbedPane {
    protected boolean mTabsClosable = false;
    protected BiMap<Component, TabInfo> mTabInfoMap = HashBiMap.create();
    protected Action mActionCloseTab = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Component c = ATabbedPane.this.getSelectedComponent();
            if (c == null) {
                return;
            }
            TabInfo ti = (TabInfo)ATabbedPane.this.mTabInfoMap.get((Object)c);
            assert (ti != null);
            if (!ti.getClosable()) {
                return;
            }
            ATabbedPane.this.closeTab(c);
        }
    };

    public ATabbedPane() {
    }

    public ATabbedPane(int tabPlacement) {
        super(tabPlacement);
    }

    public ATabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        super.insertTab(title, icon, component, tip, index);
        this.mTabInfoMap.put((Object)component, (Object)new TabInfo());
        if (this.mTabsClosable) {
            this.setTabClosable(component, true);
        }
    }

    @Override
    public void removeTabAt(int index) {
        Component c = this.getComponentAt(index);
        if (c != null) {
            this.mTabInfoMap.remove((Object)c);
        }
        super.removeTabAt(index);
    }

    public void setDefaultToClosable(boolean closable) {
        this.mTabsClosable = closable;
    }

    public void setTabClosable(Component c, boolean closable) {
        TabInfo ti = (TabInfo)this.mTabInfoMap.get((Object)c);
        assert (ti != null);
        ti.setClosable(closable);
        this.setTabComponentFor(c);
    }

    public boolean closeTab(Component c) {
        if (this.indexOfComponent(c) < 0) {
            return false;
        }
        this.remove(c);
        return true;
    }

    public boolean closeTab(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            return false;
        }
        return this.closeTab(this.getComponentAt(index));
    }

    public void setTabComponentFor(Component c) {
        int index = this.indexOfComponent(c);
        if (index < 0) {
            return;
        }
        String title = this.getTitleAt(index);
        Icon iconTab = this.getIconAt(index);
        TabComponent tc = new TabComponent(c, title, iconTab);
        this.setTabComponentAt(index, tc);
    }

    @Override
    public void setTitleAt(int index, String title) {
        super.setTitleAt(index, title);
        Component c = this.getTabComponentAt(index);
        if (c instanceof TabComponent) {
            ((TabComponent)c).setTitle(title);
        }
    }

    public class TabComponent
    extends JPanel {
        protected JLabel mLabel;

        public TabComponent(final Component forComponent, String title, Icon iconTab) {
            this.setOpaque(false);
            this.setBackground(new Color(0, 0, 0, 0));
            GridBagManager l = new GridBagManager((Container)this);
            this.mLabel = new JLabel(title, iconTab, 10);
            l.add((Component)this.mLabel, (GridBagConstraints)GridBagManager.FILLX.noInsets());
            Icon icon = AFloatWindow.ICON_CLOSE;
            Dimension size = new Dimension(icon.getIconWidth() + 4, icon.getIconHeight() + 4);
            final JButton btn = new JButton(icon);
            btn.setMinimumSize(size);
            btn.setPreferredSize(size);
            btn.setMaximumSize(size);
            btn.setBorder(null);
            btn.setOpaque(false);
            btn.setBackground(new Color(0xEEBBBB));
            l.add((Component)btn, (GridBagConstraints)GridBagManager.RIGHT.insets(2, 4, 0, 0));
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ATabbedPane.this.closeTab(forComponent);
                }
            });
            btn.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    btn.setOpaque(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    btn.setOpaque(false);
                }
            });
        }

        protected void setTitle(String title) {
            this.mLabel.setText(title);
        }

        protected void setTabIcon(Icon icon) {
            this.mLabel.setIcon(icon);
        }
    }

    public class TabInfo {
        protected boolean mClosable = false;

        protected void setClosable(boolean closable) {
            this.mClosable = closable;
        }

        public boolean getClosable() {
            return this.mClosable;
        }
    }
}

