/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.APair;
import com.sigrity.acl.ui.UIUtil;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ATextField
extends JTextField {
    public static final Icon IconError = UIUtil.getIcon(ATextField.class, (String)"res/iconTextFieldError.png");
    protected Runnable mActionHandler = null;
    protected ActionListener mActionListener = null;
    protected boolean mInvokeActionOnTextUpdate = false;
    protected Timer mUpdateTimer;
    protected boolean mUpdatePending = false;
    protected Icon mStatusIcon = null;
    protected String mStatusMsg = null;
    protected DocumentListener mTextChanged = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            ATextField.this.scheduleUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ATextField.this.scheduleUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ATextField.this.scheduleUpdate();
        }
    };
    protected ActionListener mUpdateTask = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ATextField.this.callAction();
        }
    };

    public ATextField() {
    }

    public ATextField(Document doc, String text, int columns) {
        super(doc, text, columns);
    }

    public ATextField(int columns) {
        super(columns);
    }

    public ATextField(String text, int columns) {
        super(text, columns);
    }

    public ATextField(String text) {
        super(text);
    }

    public void setActionHandler(Runnable r) {
        this.mActionHandler = r;
        this.checkListeners(this.mActionHandler);
    }

    public void setInvokeActionOnTextUpdate(boolean invokeActionOnTextUpdate) {
        this.mInvokeActionOnTextUpdate = invokeActionOnTextUpdate;
    }

    public void setStatus(Icon icon, String msg) {
        Object tip;
        if (this.mStatusMsg != null) {
            int startIdx;
            tip = this.getToolTipText();
            if (tip == null) {
                tip = "";
            }
            if ((startIdx = ((String)tip).lastIndexOf(this.mStatusMsg)) >= 0) {
                tip = startIdx == 0 ? "" : ((String)tip).substring(0, startIdx);
                if (((String)tip).endsWith("\n")) {
                    tip = ((String)tip).substring(0, ((String)tip).length());
                }
                this.setToolTipText((String)tip);
            }
        }
        this.mStatusIcon = icon;
        this.mStatusMsg = msg;
        if (this.mStatusMsg != null) {
            tip = this.getToolTipText();
            if (tip == null) {
                tip = "";
            }
            if (((String)tip).length() > 0) {
                tip = (String)tip + "\n";
            }
            tip = (String)tip + this.mStatusMsg;
            this.setToolTipText((String)tip);
        }
        this.repaint();
    }

    public void clearStatus() {
        this.setStatus(null, null);
    }

    public APair<Icon, String> getStatus() {
        return APair.create((Object)this.mStatusIcon, (Object)this.mStatusMsg);
    }

    @Override
    public void removeNotify() {
        this.checkListeners(null);
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.checkListeners(this.mActionHandler);
    }

    protected void checkListeners(Runnable actionHandler) {
        if (actionHandler != null && this.mActionListener == null) {
            this.mActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ATextField.this.callAction();
                }
            };
            this.addActionListener(this.mActionListener);
            this.getDocument().addDocumentListener(this.mTextChanged);
        } else if (actionHandler == null && this.mActionListener != null) {
            this.removeActionListener(this.mActionListener);
            this.getDocument().removeDocumentListener(this.mTextChanged);
            this.mActionListener = null;
        }
    }

    protected void scheduleUpdate() {
        if (!this.mInvokeActionOnTextUpdate) {
            return;
        }
        if (this.mUpdateTimer == null) {
            this.mUpdateTimer = new Timer(1000, this.mUpdateTask);
            this.mUpdateTimer.setRepeats(false);
        }
        if (this.mUpdateTimer.isRunning()) {
            this.mUpdateTimer.restart();
        } else {
            this.mUpdateTimer.start();
        }
    }

    protected void callAction() {
        if (this.mUpdateTimer != null && this.mUpdateTimer.isRunning()) {
            this.mUpdateTimer.stop();
        }
        if (this.mUpdatePending) {
            return;
        }
        this.mUpdatePending = true;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ATextField.this.mUpdatePending = false;
                ATextField.this.mActionHandler.run();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mStatusIcon != null) {
            Insets insets = this.getBorder().getBorderInsets(this);
            insets.right += 2;
            int x = this.getWidth() - this.mStatusIcon.getIconWidth() - insets.right;
            int y = this.getHeight() / 2 - this.mStatusIcon.getIconHeight() / 2;
            this.mStatusIcon.paintIcon(this, g, x, y);
        }
    }
}

