/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class ATristateCheckBox
extends JCheckBox {
    protected boolean mIndeterminate = false;
    protected boolean mInStateChange = false;
    Rectangle mEmptyCbBounds;

    public ATristateCheckBox() {
        this.setModel(new JToggleButton.ToggleButtonModel(){

            @Override
            public void setSelected(boolean b) {
                if (!this.isSelected() && b && !ATristateCheckBox.this.mIndeterminate) {
                    b = false;
                    this.stateMask |= 2;
                    ATristateCheckBox.this.mIndeterminate = true;
                } else {
                    ATristateCheckBox.this.mIndeterminate = false;
                }
                super.setSelected(b);
            }
        });
        this.mEmptyCbBounds = null;
    }

    public ATristateCheckBox(Action a) {
        super(a);
        this.setModel(new /* invalid duplicate definition of identical inner class */);
        this.mEmptyCbBounds = null;
    }

    public ATristateCheckBox(Icon icon, boolean selected) {
        super(icon, selected);
        this.setModel(new /* invalid duplicate definition of identical inner class */);
        this.mEmptyCbBounds = null;
    }

    public ATristateCheckBox(Icon icon) {
        super(icon);
        this.setModel(new /* invalid duplicate definition of identical inner class */);
        this.mEmptyCbBounds = null;
    }

    public ATristateCheckBox(String text, boolean selected) {
        super(text, selected);
        this.setModel(new /* invalid duplicate definition of identical inner class */);
        this.mEmptyCbBounds = null;
    }

    public ATristateCheckBox(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.setModel(new /* invalid duplicate definition of identical inner class */);
        this.mEmptyCbBounds = null;
    }

    public ATristateCheckBox(String text, Icon icon) {
        super(text, icon);
        this.setModel(new /* invalid duplicate definition of identical inner class */);
        this.mEmptyCbBounds = null;
    }

    public ATristateCheckBox(String text) {
        super(text);
        this.setModel(new /* invalid duplicate definition of identical inner class */);
        this.mEmptyCbBounds = null;
    }

    public void setIndeterminate() {
        this.mIndeterminate = true;
    }

    public Boolean getState() {
        return this.mIndeterminate ? null : Boolean.valueOf(this.isSelected());
    }

    public void setState(Boolean state) {
        super.setSelected(state == null ? false : state);
        this.mIndeterminate = state == null;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.mIndeterminate) {
            super.paintComponent(g);
        } else {
            super.paintComponent(g);
            Icon icon = this.getIcon();
            if (icon == null) {
                icon = UIManager.getIcon("CheckBoxMenuItem.dashIcon");
            }
            if (this.mEmptyCbBounds == null) {
                String txt = this.getText();
                this.setText("");
                Dimension d = this.getPreferredSize();
                this.mEmptyCbBounds = new Rectangle(0, 0, d.width, d.height);
                this.setText(txt);
            }
            Rectangle compRect = new Rectangle(this.getSize());
            int dy = (int)(compRect.getCenterY() - this.mEmptyCbBounds.getCenterY() + 0.5);
            if (UIManager.getLookAndFeel().getID().equals("Aqua")) {
                ++dy;
            }
            if (icon != null) {
                icon.paintIcon(this, g, this.mEmptyCbBounds.x + (this.mEmptyCbBounds.width - icon.getIconWidth()) / 2, this.mEmptyCbBounds.y + dy + (this.mEmptyCbBounds.height - icon.getIconHeight()) / 2);
            } else {
                int s = 6;
                g.fillRect(this.mEmptyCbBounds.x + (this.mEmptyCbBounds.width - s) / 2, this.mEmptyCbBounds.y + dy + (this.mEmptyCbBounds.height - s) / 2, s, s);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        UIManager.LookAndFeelInfo[] lfs;
        JFrame frame = new JFrame("TristateCheckBoxTest");
        frame.setLayout(new GridLayout(0, 1, 15, 15));
        for (UIManager.LookAndFeelInfo lf : lfs = UIManager.getInstalledLookAndFeels()) {
            UIManager.setLookAndFeel(lf.getClassName());
            frame.add(ATristateCheckBox.makeTestPanel(lf));
        }
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    protected static JPanel makeTestPanel(UIManager.LookAndFeelInfo lf) {
        final ATristateCheckBox tristateBox = new ATristateCheckBox("Tristate checkbox");
        tristateBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Boolean b = tristateBox.getState();
                if (b == null) {
                    System.out.println("itemStateChanged: Indeterminate");
                } else if (b.booleanValue()) {
                    System.out.println("itemStateChanged: Selected");
                } else {
                    System.out.println("itemStateChanged: Deselected");
                }
            }
        });
        final JCheckBox normalBox = new JCheckBox("Normal checkbox");
        final JCheckBox enabledBox = new JCheckBox("Enable", true);
        enabledBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                tristateBox.setEnabled(enabledBox.isSelected());
                normalBox.setEnabled(enabledBox.isSelected());
            }
        });
        JPanel panel = new JPanel(new GridLayout(0, 1, 5, 5));
        panel.add(new JLabel(UIManager.getLookAndFeel().getName()));
        panel.add(tristateBox);
        panel.add(normalBox);
        panel.add(enabledBox);
        return panel;
    }
}

