/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.ui.AColorIcon;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class AUIManagerInfo {
    protected Object[][] mTableData;
    protected TableCellRenderer mColorUIResourceRenderer = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int h = table.getRowHeight();
            this.setIcon((Icon)new AColorIcon(h - 2, h - 2, (Color)value));
            return this;
        }
    };

    public static void main(String[] args) {
        new AUIManagerInfo();
    }

    protected AUIManagerInfo() {
        UIDefaults defaults = UIManager.getDefaults();
        Object[] colName = new String[]{"Look", "Key", "Value"};
        UIManager.LookAndFeelInfo[] lfs = UIManager.getInstalledLookAndFeels();
        this.mTableData = new Object[defaults.size() * lfs.length][colName.length];
        LinkedList keys = AUtil.linkedList((Iterator)AUtil.getIterator(defaults.keys()));
        Collections.sort(keys, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        int row = 0;
        for (UIManager.LookAndFeelInfo lf : lfs) {
            try {
                UIManager.setLookAndFeel(lf.getClassName());
                int i = 0;
                while (i < keys.size()) {
                    Object key = keys.get(i);
                    this.mTableData[row][0] = lf.getClassName();
                    this.mTableData[row][1] = key;
                    this.mTableData[row][2] = defaults.get(key);
                    ++i;
                    ++row;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                ALog.logError((Throwable)e, (String)"Unable to set look and feel to '%s'.", (Object[])new Object[]{lf.getClassName()});
            }
        }
        JFrame f = new JFrame("UIDefaults Key-Value sheet");
        Tbl t = new Tbl(this.mTableData, colName);
        f.setContentPane(new JScrollPane(t));
        f.pack();
        f.setVisible(true);
    }

    protected class Tbl
    extends JTable {
        public Tbl(Object[][] rowData, Object[] columnNames) {
            super(rowData, columnNames);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            Object val = AUIManagerInfo.this.mTableData[row][column];
            if (val instanceof ColorUIResource) {
                return AUIManagerInfo.this.mColorUIResourceRenderer;
            }
            return super.getCellRenderer(row, column);
        }
    }
}

