/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.ABrowserControl;
import com.sigrity.acl.app.ABuildInfo;
import com.sigrity.acl.ui.AImageIcon;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.OverlayLayout;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLEditorKit;

public class About
extends JDialog {
    protected JTextPane mTxtPaneScrollArea;
    protected JButton mBtnUpdateCheck;

    public About(Frame owner, String titleBarName, String name, String version, String copyright, String scrolltext, Image imgHead, Image imgFoot, final Image imgBackground, Color colorBackground, int imgHeadBorderThickness) {
        super(owner, false);
        this.setTitle("About " + titleBarName);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        if (colorBackground != null) {
            this.setBackground(colorBackground);
        }
        int insetX = 16;
        String buildInfo = String.format("Build %s (%s)", ABuildInfo.getVersion(), ABuildInfo.getTimestamp());
        JPanel contentPanel = new JPanel();
        GridBagManager gbu = new GridBagManager((Container)contentPanel);
        if (imgHead != null) {
            JLabel lblHead = new JLabel((Icon)new AImageIcon(imgHead));
            if (imgHeadBorderThickness != 0) {
                LineBorder b2 = new LineBorder(Color.WHITE, imgHeadBorderThickness);
                lblHead.setBorder(b2);
            }
            gbu.addNl((Component)lblHead, (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
        }
        JLabel appName = new JLabel(name);
        gbu.add((Component)appName, (GridBagConstraints)GridBagManager.FILLX.insets(4, insetX, 0, insetX));
        Font font = new Font("SansSerif", 1, 24);
        appName.setFont(font);
        appName.setForeground(new Color(204, 0, 0));
        appName.setAlignmentX(0.0f);
        gbu.newline();
        JLabel lblAppVersion = new JLabel();
        gbu.add((Component)lblAppVersion, (GridBagConstraints)GridBagManager.RIGHT.insets(0, insetX, 0, insetX));
        font = new Font("Arial", 1, 14);
        lblAppVersion.setFont(font);
        lblAppVersion.setForeground(new Color(0x606060));
        lblAppVersion.setAlignmentX(0.0f);
        gbu.newline();
        JTextField txtAppBuild = new JTextField(buildInfo);
        gbu.add((Component)txtAppBuild, (GridBagConstraints)GridBagManager.FILLX.insets(0, insetX, 0, insetX));
        txtAppBuild.setEditable(false);
        txtAppBuild.setForeground(Color.DARK_GRAY);
        txtAppBuild.setSelectedTextColor(Color.WHITE);
        txtAppBuild.setSelectionColor(Color.BLACK);
        txtAppBuild.setBorder(BorderFactory.createEmptyBorder());
        font = new Font("SansSerif", 0, 10);
        txtAppBuild.setFont(font);
        txtAppBuild.setHorizontalAlignment(4);
        txtAppBuild.setCaretPosition(0);
        txtAppBuild.setOpaque(false);
        gbu.newline();
        this.mTxtPaneScrollArea = new JTextPane(){

            @Override
            public void paintComponent(Graphics g) {
                if (imgBackground != null) {
                    g.setColor(new Color(0, 0, 0, 128));
                    Rectangle r = g.getClipBounds();
                    g.fillRect(r.x, r.y, r.width, r.height);
                }
                super.paintComponent(g);
            }
        };
        HTMLEditorKit ek = new HTMLEditorKit();
        this.mTxtPaneScrollArea.setEditorKit(ek);
        this.mTxtPaneScrollArea.setEditable(false);
        this.mTxtPaneScrollArea.setOpaque(false);
        this.mTxtPaneScrollArea.setForeground(Color.DARK_GRAY);
        this.mTxtPaneScrollArea.setBackground(new Color(0, 0, 0, 0));
        this.mTxtPaneScrollArea.setSelectedTextColor(Color.white);
        this.mTxtPaneScrollArea.setSelectionColor(Color.darkGray);
        this.mTxtPaneScrollArea.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                ABrowserControl.displayURL((String)e.getDescription());
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.mTxtPaneScrollArea);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setOpaque(false);
        scrollPane.setBackground(new Color(0, 0, 0, 0));
        scrollPane.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        Component[] comps = scrollPane.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            ((JComponent)comps[i]).setOpaque(false);
        }
        gbu.add((Component)scrollPane, (GridBagConstraints)GridBagManager.FILLALL.insets(0, insetX, 0, insetX));
        gbu.newline();
        JPanel pnlCopyright = gbu.pushFillXRemainX();
        pnlCopyright.setOpaque(false);
        pnlCopyright.setBackground(new Color(0, 0, 0, 0));
        if (copyright != null && !copyright.isBlank()) {
            JTextPane txtCopyright = (JTextPane)gbu.add((Component)new JTextPane(), (GridBagConstraints)GridBagManager.FILLX.insetVert(12));
            txtCopyright.setEditable(false);
            txtCopyright.setOpaque(false);
            txtCopyright.setText(copyright);
            font = new Font("Arial", 0, 9);
            txtCopyright.setFont(font);
            txtCopyright.setForeground(Color.DARK_GRAY);
            StyledDocument doc = txtCopyright.getStyledDocument();
            SimpleAttributeSet center = new SimpleAttributeSet();
            StyleConstants.setAlignment(center, 1);
            doc.setParagraphAttributes(0, doc.getLength(), center, false);
        } else {
            gbu.add((Component)new JLabel(), (GridBagConstraints)GridBagManager.FILLX.insetVert(12));
        }
        this.mBtnUpdateCheck = new JButton();
        gbu.add((Component)this.mBtnUpdateCheck, (GridBagConstraints)GridBagManager.RIGHT);
        font = new Font("SansSerif", 0, 10);
        this.mBtnUpdateCheck.setFont(font);
        this.mBtnUpdateCheck.setContentAreaFilled(false);
        this.mBtnUpdateCheck.setForeground(Color.DARK_GRAY);
        this.mBtnUpdateCheck.setAlignmentX(1.0f);
        this.mBtnUpdateCheck.setMargin(new Insets(1, 1, 1, 1));
        this.mBtnUpdateCheck.setText("Check for updates");
        this.mBtnUpdateCheck.setVisible(false);
        gbu.popNl();
        lblAppVersion.setText(version);
        if (imgFoot != null) {
            JLabel lblFoot = new JLabel((Icon)new AImageIcon(imgFoot));
            gbu.addNl((Component)lblFoot, (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
        }
        JPanel content = new JPanel();
        this.setContentPane(content);
        content.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        content.setLayout(new OverlayLayout(content));
        contentPanel.setAlignmentX(1.0f);
        contentPanel.setAlignmentY(0.0f);
        content.add(contentPanel);
        JLabel lblBackgroundImage = null;
        if (imgBackground != null) {
            lblBackgroundImage = new JLabel();
            lblBackgroundImage.setIcon((Icon)new AImageIcon(imgBackground));
            lblBackgroundImage.setAlignmentX(1.0f);
            lblBackgroundImage.setAlignmentY(0.0f);
            content.add(lblBackgroundImage);
            contentPanel.setOpaque(false);
        } else {
            contentPanel.setOpaque(true);
            contentPanel.setBackground(colorBackground == null ? new Color(0, 0, 0, 0) : colorBackground);
        }
        if (lblBackgroundImage != null) {
            Dimension dim = lblBackgroundImage.getSize();
            this.setPreferredSize(dim);
            this.setSize(dim);
            this.setMaximumSize(dim);
            this.setMinimumSize(dim);
        } else {
            int w = txtAppBuild.getPreferredSize().width;
            scrollPane.setPreferredSize(new Dimension(w, 250));
        }
        this.pack();
        this.setScrollText(scrolltext);
        UIUtil.enableEscapeClose((Window)this, null);
        UIUtil.center((Component)this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                UIUtil.closeWindow((Window)About.this);
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }
        });
    }

    public void setScrollText(String text) {
        String st = "<style type='text/css'>body {color: #404040; font-size: 12pt; font-family: arial, sans-serif}</style><body>" + text + "</body>";
        this.mTxtPaneScrollArea.setText(st);
        this.mTxtPaneScrollArea.setCaretPosition(0);
        this.mTxtPaneScrollArea.requestFocus();
    }

    public void setCheckForUpdate(Action action) {
        this.mBtnUpdateCheck.setAction(action);
        this.mBtnUpdateCheck.setVisible(action != null);
    }

    protected class WindowEventHandler
    implements MouseListener,
    MouseMotionListener {
        protected Point mPtPressOrigin = new Point();

        protected WindowEventHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mPtPressOrigin.x = e.getX();
            this.mPtPressOrigin.y = e.getY();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point p = About.this.getLocation();
            About.this.setLocation(p.x + e.getX() - this.mPtPressOrigin.x, p.y + e.getY() - this.mPtPressOrigin.y);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

