/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.ObjectCopyOrMoveUI;
import com.sigrity.orbit.ui.PlaceableItemUI;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;

public class ActionOnPlaceableItem
extends AbstractAction {
    final String mType;
    final ACTION mAction;
    final DbObject mObj;
    Boolean mIncludeLoc = false;
    String mArgs;
    DevicePath mDevicePath = null;
    Selection.SelSet mObjSet = null;
    Selection mSelection = null;
    DbClass mDbc;
    APoint2D mStartLoc = null;

    public ActionOnPlaceableItem(Selection selection, int count, String type, ACTION action, boolean includeLoc, String args, String userCommand) {
        super(String.format("%s (%d)", userCommand, count));
        this.mType = type;
        this.mAction = action;
        this.mIncludeLoc = includeLoc;
        this.mArgs = args;
        this.mSelection = selection;
        this.mObj = null;
    }

    public ActionOnPlaceableItem(Selection s, DbClass dbc, ACTION copyOrMove, String userCommand) {
        super(String.format("%s (%d)", userCommand, s.getCount(dbc)));
        assert (copyOrMove == ACTION.COPY || copyOrMove == ACTION.MOVE);
        if (dbc.getJavaClass() == Device.class) {
            this.mType = "Device";
        } else if (dbc.getJavaClass() == PinTemplate.class || dbc.getJavaClass() == PinInstance.class) {
            this.mType = "Pin";
        } else {
            assert (false);
            this.mType = "";
        }
        this.mAction = copyOrMove;
        this.mDbc = dbc;
        this.mSelection = s;
        this.mObj = null;
    }

    public ActionOnPlaceableItem(DevicePath devicePath, DbObject obj, ACTION copyOrMove, String userCommand) {
        super(String.format("%s", userCommand));
        assert (copyOrMove == ACTION.COPY || copyOrMove == ACTION.MOVE);
        this.mDevicePath = devicePath;
        if (obj instanceof Device) {
            this.mType = "Device";
        } else if (obj instanceof PinTemplate || obj instanceof PinInstance) {
            this.mType = "Pin";
        } else {
            assert (false);
            this.mType = "";
        }
        this.mDbc = obj.getDbClass();
        this.mObjSet = Selection.getSelSet((DevicePath)devicePath, (DbObject)obj);
        this.mAction = copyOrMove;
        this.mObj = null;
    }

    public ActionOnPlaceableItem(DevicePath devicePath, DbObject obj, ACTION action, boolean includeLoc, String args, String userCommand) {
        super(String.format("%s", userCommand));
        this.mDevicePath = devicePath;
        this.mObj = obj;
        if (obj instanceof Device) {
            this.mType = "Device";
        } else if (obj instanceof PinTemplate || obj instanceof PinInstance) {
            this.mType = "Pin";
        } else {
            assert (false);
            this.mType = "";
        }
        this.mAction = action;
        this.mIncludeLoc = includeLoc;
        this.mArgs = args;
    }

    private void processData() {
        if (this.mSelection != null && this.mObjSet == null) {
            this.mObjSet = this.mSelection.getSelSet(this.mDbc);
            if (this.mObjSet == null) {
                this.mObjSet = new Selection.SelSet();
            }
        }
    }

    public void setStartLoc(APoint2D worldLoc) {
        if (worldLoc != null) {
            this.mStartLoc = worldLoc.copy();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.processData();
        this.cpPerformed();
    }

    private void cpPerformed() {
        APoint2D startLoc;
        if (this.mSelection != null && this.mSelection != OrbitIO.getCurDesign().getCurSelection()) {
            CpHelper.cpClearSelection();
            CpHelper.cpSelect((Iterator<? extends DbObject>)this.mSelection.getAll());
            CpHelper.cpHierSelect(this.mSelection.getAllHierInsts());
        }
        DesignCanvas2D d2d = ((DesignView2D)OrbitIO.getCurView()).getCanvas();
        if (this.mAction == ACTION.MOVE || this.mAction == ACTION.COPY) {
            ObjectCopyOrMoveUI.showMoveObject(OrbitIO.getMainWindow(), OrbitIO.getCurView(), this.mObjSet, this.mType, this.mAction == ACTION.COPY);
            d2d.refresh();
            return;
        }
        String locStr = "";
        APoint2D aPoint2D = startLoc = this.mStartLoc != null ? this.mStartLoc : d2d.getWorldPt(AbstractViewMode.getLastInspectedPoint());
        if (Boolean.TRUE.equals(this.mIncludeLoc)) {
            locStr = String.format("%dL, %dL,", startLoc.getX(), startLoc.getY());
        }
        Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.Do%s.Start()", (Object[])new Object[]{this.mType});
        if (this.mObj == null) {
            Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.%s(%s %s)", (Object[])new Object[]{this.mAction.getCommand(), locStr, this.mArgs});
        } else {
            Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.setKeepInsideParentInitialValue(\"%s\")", (Object[])new Object[]{this.mObj.getKeyStr()});
            if (!this.mArgs.isEmpty()) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.%s(%s \"%s\",\"%s\", %s)", (Object[])new Object[]{this.mAction.getCommand(), locStr, this.mDevicePath, this.mObj.getKeyStr(), this.mArgs});
            } else if (this.mAction == ACTION.DELETE_OBJ) {
                Cp.exec((String)"// com.sigrity.orbit.ui.PlaceableItemUI.%s(%s \"%s\",\"%s\");", (Object[])new Object[]{this.mAction.getCommand(), locStr, this.mDevicePath, this.mObj.getKeyStr()});
                PlaceableItemUI.deleteObject(this.mDevicePath.toString(), this.mObj.getKeyStr());
            } else {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.%s(%s \"%s\",\"%s\")", (Object[])new Object[]{this.mAction.getCommand(), locStr, this.mDevicePath, this.mObj.getKeyStr()});
            }
        }
        d2d.refresh();
    }

    public static enum ACTION {
        MOVE_SEL_INT("moveSelectedInteractively"),
        MOVE_OBJ_INT("moveObjectInteractively"),
        MOVE(null),
        COPY(null),
        DELETE_SEL("deleteSelected"),
        DELETE_OBJ("deleteObject");

        private String command;

        private ACTION(String cmd) {
            this.command = cmd;
        }

        public String getCommand() {
            return this.command;
        }
    }
}

