/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.AExceptionHandler;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APlatformUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;

public class OrbitUIEventQueue
extends EventQueue {
    protected static boolean isMac = APlatformUtil.isMacPlatform();
    protected static Set<Integer> RemapCmdToCtlOnMac = null;
    protected HashMap<Class<? extends Throwable>, AExceptionHandler> mExceptionHandlers = new HashMap();

    @Override
    protected void dispatchEvent(AWTEvent event) {
        block6: {
            if (isMac && event instanceof KeyEvent) {
                KeyEvent ke;
                if (RemapCmdToCtlOnMac == null) {
                    int[] chars = new int[]{88, 67, 86, 65};
                    RemapCmdToCtlOnMac = Arrays.stream(chars).boxed().collect(Collectors.toSet());
                }
                if (RemapCmdToCtlOnMac.contains((ke = (KeyEvent)event).getKeyCode()) && ke.getModifiersEx() == 256 && ke.getSource() instanceof Component) {
                    ke.consume();
                    int newModifiers = 128;
                    event = new KeyEvent((Component)ke.getSource(), ke.getID(), ke.getWhen(), newModifiers, ke.getKeyCode(), ke.getKeyChar(), ke.getKeyLocation());
                }
            }
            try {
                super.dispatchEvent(event);
            }
            catch (Throwable t) {
                boolean handled = false;
                AExceptionHandler eh = this.mExceptionHandlers.get(t.getClass());
                if (eh != null) {
                    handled = eh.handle(t);
                }
                if (handled) break block6;
                ALog.logError((Throwable)t, (String)"Unexpected %s: %s", (Object[])new Object[]{t.getClass().getSimpleName(), t.getMessage()});
            }
        }
    }

    public AExceptionHandler addExceptionHandler(Class<? extends Throwable> c, AExceptionHandler eh) {
        return this.mExceptionHandlers.put(c, eh);
    }

    public AExceptionHandler removeExceptionHandler(Class<? extends Throwable> c) {
        return this.mExceptionHandlers.remove(c);
    }
}

