/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.ui.AImageIcon;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class Splash
extends JFrame {
    protected Color mBorderColor = Color.BLACK;
    protected Color mNameColor = Color.WHITE;
    protected Color mAppVerColor = Color.WHITE;
    protected Color mBuildVerColor = Color.WHITE;
    protected Color mMsgColor = Color.WHITE;
    protected int mBorderSize = 1;
    protected int mInsetSize = 6;
    protected String mAppVersion;
    protected String mBuildVersion;
    protected String mCopyright = null;
    protected boolean mBackgroundImageOnly = false;
    protected Image mImgBackground = null;
    protected JLabel mLblAppName = new JLabel();
    protected JTextPane mTxtCopyright = null;
    protected JTextArea mTxtMsgArea = new JTextArea();
    protected MouseAdapter mMouseHandler = new MouseAdapter(){
        Point mouseAnchor = null;
        Point windowAnchor = null;

        @Override
        public void mousePressed(MouseEvent e) {
            this.mouseAnchor = e.getLocationOnScreen();
            this.windowAnchor = Splash.this.getLocation();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mouseAnchor = null;
            this.windowAnchor = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.mouseAnchor == null) {
                return;
            }
            Splash.this.setLocation(this.windowAnchor.x + e.getLocationOnScreen().x - this.mouseAnchor.x, this.windowAnchor.y + e.getLocationOnScreen().y - this.mouseAnchor.y);
        }
    };

    public Splash(String name, String appVersion, String buildVersion, File bgImagePath, File iconPath) {
        this(name, name, appVersion, buildVersion, bgImagePath, iconPath, false);
    }

    public Splash(String title, String name, String appVersion, String buildVersion, File bgImagePath, File iconPath, boolean backgroundImageOnly) {
        super(title);
        this.setUndecorated(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.mLblAppName.setText(name);
        this.mAppVersion = appVersion;
        this.mBuildVersion = buildVersion;
        this.mBackgroundImageOnly = backgroundImageOnly;
        AImageIcon icon = null;
        AImageIcon imageIcon = null;
        try {
            if (iconPath != null) {
                icon = new AImageIcon(iconPath.toURI().toURL());
            }
            imageIcon = new AImageIcon(bgImagePath.toURI().toURL());
        }
        catch (MalformedURLException e) {
            ALog.logWarn((Throwable)e, (String)"Error loading splash screen image '%s'.", (Object[])new Object[]{bgImagePath.getPath()});
        }
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        this.mImgBackground = imageIcon != null ? imageIcon.getImage() : null;
    }

    @Override
    public void addNotify() {
        int width = 400;
        int height = 300;
        if (this.mImgBackground == null) {
            this.setBackground(Color.black);
        } else {
            width = this.mImgBackground.getWidth(null) + 2 * this.mBorderSize;
            height = this.mImgBackground.getHeight(null) + 2 * this.mBorderSize;
        }
        Dimension dimScreen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dimScreen.width - width) / 2;
        int y = (dimScreen.height - height) / 2;
        this.setSize(width, height);
        this.setLocation(x, y);
        Container contents = null;
        contents = this.mBackgroundImageOnly ? new ImageOnlyContents(width, height) : new Contents(this.mAppVersion, this.mBuildVersion, width, height);
        this.setContentPane(contents);
        this.validate();
        contents.addMouseListener(this.mMouseHandler);
        contents.addMouseMotionListener(this.mMouseHandler);
        super.addNotify();
    }

    public String getCopyright() {
        return this.mCopyright;
    }

    public void setCopyright(String copyright) {
        this.mCopyright = copyright;
    }

    public Color getNameColor() {
        return this.mNameColor;
    }

    public void setNameColor(Color color) {
        this.mNameColor = color;
    }

    public Color getAppVersionColor() {
        return this.mAppVerColor;
    }

    public void setAppVersionColor(Color color) {
        this.mAppVerColor = color;
    }

    public Color getBuildVersionColor() {
        return this.mBuildVerColor;
    }

    public void setBuildVersionColor(Color color) {
        this.mBuildVerColor = color;
    }

    public Color getMsgColor() {
        return this.mMsgColor;
    }

    public void setMsgColor(Color color) {
        this.mMsgColor = color;
    }

    public Color getBorderColor() {
        return this.mBorderColor;
    }

    public void setBorderColor(Color color) {
        this.mBorderColor = color;
    }

    public int getBorderSize() {
        return this.mBorderSize;
    }

    public void setBorderSize(int size) {
        this.mBorderSize = size;
    }

    public int getInsetSize() {
        return this.mInsetSize;
    }

    public void setInsetSize(int size) {
        this.mInsetSize = size;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.paintNow();
        }
    }

    public void setAppName(String s) {
        this.mLblAppName.setText(s);
        this.mLblAppName.setSize(this.mLblAppName.getPreferredSize());
        this.paintNow();
    }

    public void paintNow() {
        Runnable painter = () -> {
            Graphics g = this.getGraphics();
            if (g == null) {
                return;
            }
            this.toFront();
            this.paint(g);
        };
        if (EventQueue.isDispatchThread()) {
            painter.run();
        } else {
            try {
                EventQueue.invokeAndWait(painter);
            }
            catch (InterruptedException | InvocationTargetException e) {
                ALog.logDebug((Throwable)e);
            }
        }
    }

    public void setMessage(String text) {
        this.mTxtMsgArea.setText(text);
        this.paintNow();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public void setTimer(int sec) {
        Timer timer = new Timer(sec * 1000, e -> this.dispose());
        timer.setRepeats(false);
        timer.start();
    }

    public static void main(String[] args) {
        File imagePath = new File(AApp.getInstallDir(), "res/img/splashBG.jpg");
        File iconPath = new File(AApp.getInstallDir(), "res/img/icon32.png");
        Splash s = new Splash("Splash", "1.0-Development ", "Build 1.0.0", imagePath, iconPath);
        s.setVisible(true);
    }

    public class Contents
    extends Container {
        public Contents(String appVersion, String buildVersion, int width, int height) {
            this.setSize(width, height);
            this.setLayout(null);
            Font font = new Font("SansSerif", 1, 20);
            Splash.this.mLblAppName.setFont(font);
            Splash.this.mLblAppName.setForeground(Splash.this.mNameColor);
            Dimension dimName = Splash.this.mLblAppName.getPreferredSize();
            Splash.this.mLblAppName.setSize(dimName);
            Splash.this.mLblAppName.setLocation(Splash.this.mInsetSize, Splash.this.mInsetSize);
            this.add(Splash.this.mLblAppName);
            JLabel lblAppVer = new JLabel("version " + appVersion);
            font = new Font("Arial", 1, 14);
            lblAppVer.setFont(font);
            lblAppVer.setForeground(Splash.this.mAppVerColor);
            Dimension dimAppVer = lblAppVer.getPreferredSize();
            lblAppVer.setSize(dimAppVer);
            lblAppVer.setLocation(width - Splash.this.mInsetSize - dimAppVer.width, 124);
            this.add(lblAppVer);
            JLabel lblBuildVer = new JLabel(buildVersion);
            font = new Font("Arial", 0, 12);
            lblBuildVer.setFont(font);
            lblBuildVer.setForeground(Splash.this.mBuildVerColor);
            Dimension dimBldVer = lblBuildVer.getPreferredSize();
            lblBuildVer.setSize(dimBldVer);
            lblBuildVer.setLocation(width - Splash.this.mInsetSize - dimBldVer.width, height - Splash.this.mInsetSize - dimBldVer.height);
            this.add(lblBuildVer);
            Splash.this.mTxtMsgArea.setEditable(false);
            Splash.this.mTxtMsgArea.setOpaque(false);
            Splash.this.mTxtMsgArea.setForeground(Splash.this.mMsgColor);
            Splash.this.mTxtMsgArea.setBackground(new Color(0, 0, 0, 0));
            Splash.this.mTxtMsgArea.setSelectedTextColor(Color.black);
            Splash.this.mTxtMsgArea.setSelectionColor(Color.lightGray);
            Splash.this.mTxtMsgArea.setBorder(BorderFactory.createEmptyBorder());
            int msgAreaHeight = Splash.this.mTxtMsgArea.getPreferredSize().height;
            Dimension dimMsg = new Dimension(width - 2 * Splash.this.mInsetSize, msgAreaHeight);
            Splash.this.mTxtMsgArea.setSize(dimMsg);
            Splash.this.mTxtMsgArea.setLocation(Splash.this.mInsetSize, lblBuildVer.getLocation().y - dimMsg.height);
            this.add(Splash.this.mTxtMsgArea);
            if (Splash.this.mCopyright != null && !Splash.this.mCopyright.isEmpty()) {
                Splash.this.mTxtCopyright = new JTextPane();
                Splash.this.mTxtCopyright.setEditable(false);
                Splash.this.mTxtCopyright.setOpaque(false);
                Splash.this.mTxtCopyright.setText(Splash.this.mCopyright);
                font = new Font("Arial", 0, 9);
                Splash.this.mTxtCopyright.setFont(font);
                Splash.this.mTxtCopyright.setForeground(Color.DARK_GRAY);
                StyledDocument doc = Splash.this.mTxtCopyright.getStyledDocument();
                SimpleAttributeSet center = new SimpleAttributeSet();
                StyleConstants.setAlignment(center, 1);
                doc.setParagraphAttributes(0, doc.getLength(), center, false);
                Dimension dimCopyright = Splash.this.mTxtCopyright.getPreferredSize();
                Splash.this.mTxtCopyright.setSize(dimCopyright.width + 8, dimCopyright.height + 8);
                Splash.this.mTxtCopyright.setLocation(34, Splash.this.mTxtMsgArea.getLocation().y - 9 - Splash.this.mTxtCopyright.getSize().height);
                this.add(Splash.this.mTxtCopyright);
            }
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            RenderingHints oldRenderingHints = g2d.getRenderingHints();
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            super.paint(g);
            int r = this.getWidth() - 1;
            int b = this.getHeight() - 1;
            for (int i = 0; i < Splash.this.getBorderSize(); ++i) {
                g.setColor(Splash.this.mBorderColor);
                g.drawLine(i, i, r - i, i);
                g.drawLine(i, i, i, b - i);
                g.drawLine(i, b - i, r - i, b - i);
                g.drawLine(r - i, i, r - i, b - i);
            }
            if (Splash.this.mImgBackground != null) {
                g.drawImage(Splash.this.mImgBackground, Splash.this.mBorderSize, Splash.this.mBorderSize, Splash.this.mImgBackground.getWidth(null), Splash.this.mImgBackground.getHeight(null), null);
            }
            this.paintComponents(g);
            g2d.setRenderingHints(oldRenderingHints);
        }
    }

    public class ImageOnlyContents
    extends Container {
        public ImageOnlyContents(int width, int height) {
            this.setSize(width, height);
            this.setLayout(null);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            RenderingHints oldRenderingHints = g2d.getRenderingHints();
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            super.paint(g);
            int r = this.getWidth() - 1;
            int b = this.getHeight() - 1;
            for (int i = 0; i < Splash.this.getBorderSize(); ++i) {
                g.setColor(Splash.this.mBorderColor);
                g.drawLine(i, i, r - i, i);
                g.drawLine(i, i, i, b - i);
                g.drawLine(i, b - i, r - i, b - i);
                g.drawLine(r - i, i, r - i, b - i);
            }
            if (Splash.this.mImgBackground != null) {
                g.drawImage(Splash.this.mImgBackground, Splash.this.mBorderSize, Splash.this.mBorderSize, Splash.this.mImgBackground.getWidth(null), Splash.this.mImgBackground.getHeight(null), null);
            }
            g2d.setRenderingHints(oldRenderingHints);
        }
    }
}

