/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui.dlg;

import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SelectFromListDlg<T>
extends ADialog {
    protected JList<T> mList;
    protected boolean mUserSaidOkeyDokey = false;
    protected ActionListener OK = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectFromListDlg.this.mUserSaidOkeyDokey = true;
            UIUtil.closeWindow((Window)((Object)SelectFromListDlg.this));
        }
    };

    public static <T> T show(Component owner, String title, List<T> list, Initializer<T> init) {
        SelectFromListDlg<T> dlg = new SelectFromListDlg<T>(owner, title, list);
        if (init != null) {
            init.init(dlg);
        }
        dlg.setVisible(true);
        if (dlg.getUserAccepted()) {
            return dlg.getList().getSelectedValue();
        }
        return null;
    }

    public SelectFromListDlg(Component owner, String title, List<T> choices) {
        super(owner, "Select", Dialog.ModalityType.APPLICATION_MODAL);
        this.init(title, choices);
    }

    protected void init(String title, List<T> choices) {
        if (title != null) {
            this.setTitle(title);
        }
        this.setRecallBounds(false);
        GridBagManager gbm = GridBagManager.layout((JDialog)((Object)this));
        Object[] choiceArray = choices.toArray();
        this.mList = new JList<Object>(choiceArray);
        JScrollPane sp = new JScrollPane(this.mList);
        this.mList.setSelectionMode(0);
        this.mList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SelectFromListDlg.this.mList.locationToIndex(e.getPoint()) != -1) {
                    SelectFromListDlg.this.OK.actionPerformed(null);
                }
            }
        });
        gbm.add((Component)sp, (GridBagConstraints)GridBagManager.FILLALL);
        gbm.newline();
        gbm.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton btnOk = new JButton("OK");
        gbm.add((Component)btnOk);
        btnOk.addActionListener(this.OK);
        JButton btnCancel = new JButton("Cancel");
        gbm.add((Component)btnCancel);
        gbm.pop();
        this.mList.setSelectedIndex(0);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
        this.pack();
        UIUtil.center((Component)((Object)this));
    }

    public JList<T> getList() {
        return this.mList;
    }

    public boolean getUserAccepted() {
        return this.mUserSaidOkeyDokey;
    }

    public static class Initializer<T> {
        public void init(SelectFromListDlg<T> dlg) {
        }
    }
}

