/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui.editors;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.HasPreferredGridBagConstraints;
import com.sigrity.acl.ui.editors.AValueEditor;
import java.awt.GridBagConstraints;
import java.util.Properties;

public abstract class AValueEditorAbstract<T>
implements AValueEditor<T>,
HasPreferredGridBagConstraints {
    protected Class<T> mType;
    protected T mOrigVal;

    public AValueEditorAbstract(Class<T> type, T val) {
        this.mType = type;
        this.mOrigVal = val;
    }

    @Override
    public Class<T> getType() {
        return this.mType;
    }

    @Override
    public T getOriginalValue() {
        return this.mOrigVal;
    }

    @Override
    public boolean isModified() {
        return !AUtil.equals(this.getOriginalValue(), this.getNewValue());
    }

    @Override
    public GridBagConstraints getPreferredGridBagConstraints() {
        return GridBagManager.LEFT;
    }

    public static boolean containsHint(Properties hints, Object key) {
        return hints != null && hints.containsKey(key);
    }

    public static <T> T getHint(Properties hints, Object key, Class<T> type, T defVal) {
        Object v;
        Object object = v = hints == null ? null : hints.get(key);
        if (v == null) {
            return defVal;
        }
        if (!type.isAssignableFrom(v.getClass())) {
            ALog.logWarn((Throwable)new InvalidHintValue(), (String)"AValueEditor hint with invalid value '%s' of type %s, expected value of type %s; hint is being ignored.", (Object[])new Object[]{"" + v, type.getSimpleName()});
            return defVal;
        }
        return type.cast(v);
    }

    public static class InvalidHintValue
    extends Exception {
    }
}

