/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui.editors;

import bsh.EvalError;
import bsh.Interpreter;
import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.geom.ADistance;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.AColorChooserDlg;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.editors.AValueEditor;
import com.sigrity.acl.ui.editors.AValueEditorAbstract;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class AValueEditorBasic {
    public static final int COLS_NUM = 12;
    public static final int COLS_STR = 30;

    private AValueEditorBasic() {
    }

    public static class ColorEditor
    extends AValueEditorAbstract<Color> {
        public static final AValueEditor.Factory<Color> Factory = new AValueEditor.Factory<Color>(){

            @Override
            public AValueEditor<Color> create(Class<Color> type, Color val, Properties hints) {
                return new ColorEditor(val);
            }
        };
        protected JLabel mEditor = new JLabel();

        public ColorEditor(Color val) {
            super(Color.class, val);
            if (val != null) {
                this.mEditor.setIcon((Icon)new AColorIcon(12, 12, val));
            } else {
                this.mEditor.setIcon((Icon)new AColorIcon(12, 12, Color.WHITE));
            }
            this.mEditor.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    String title = "Color";
                    Color c = ((AColorIcon)mEditor.getIcon()).getColor();
                    AColorChooserDlg dlg = AColorChooserDlg.createDialog((Component)mEditor, title, c);
                    Color newColor = dlg.doModal();
                    if (newColor != null) {
                        mEditor.setIcon((Icon)new AColorIcon(12, 12, newColor));
                    }
                }
            });
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Color getNewValue() {
            return this.mEditor == null ? (Color)this.getOriginalValue() : ((AColorIcon)this.mEditor.getIcon()).getColor();
        }

        @Override
        public JComponent getEditComp() {
            return this.mEditor;
        }

        @Override
        public GridBagConstraints getPreferredGridBagConstraints() {
            return GridBagManager.LEFT;
        }

        @Override
        public String getValueAsString(Color val) {
            if (val == null) {
                return "null";
            }
            return AColor.formatColor((Color)val);
        }

        @Override
        public String getValueAsStringArg(Color val) {
            if (val == null) {
                return "null";
            }
            return String.format("new java.awt.Color(%d, %d, %d)", val.getRed(), val.getGreen(), val.getBlue());
        }

        @Override
        public String getValueUnitName() {
            return null;
        }

        @Override
        public void setNewValueAsString(String s) {
            this.mEditor.setText(s);
        }
    }

    public static class AGeomEditor
    extends AValueEditorAbstract<AGeom> {
        public static final AValueEditor.Factory<AGeom> Factory = new AValueEditor.Factory<AGeom>(){

            @Override
            public AValueEditor<AGeom> create(Class<AGeom> type, AGeom val, Properties hints) {
                return new AGeomEditor(val, hints);
            }
        };
        protected final String FMT_INTEGRAL = "%d %d";
        protected final String FMT_FLOATINGPOINT = "%s %s";
        protected JScrollPane mScrollPane;
        protected JTextArea mEditor;
        protected boolean mAcceptEmpty = false;
        protected Unit mUnit = null;

        public AGeomEditor(AGeom val, Properties hints) {
            super(AGeom.class, val);
            this.mAcceptEmpty = AGeomEditor.getHint(hints, (Object)HintKey.AcceptEmpty, Boolean.class, false);
            if (AGeomEditor.containsHint(hints, (Object)HintKey.Unit)) {
                this.mUnit = AGeomEditor.getHint(hints, (Object)HintKey.Unit, Unit.class, null);
            }
        }

        public boolean getAcceptEmpty() {
            return this.mAcceptEmpty;
        }

        public void setAcceptEmpty(boolean b) {
            this.mAcceptEmpty = b;
        }

        @Override
        public boolean isValid() {
            return this.getNewValue() != null || this.mAcceptEmpty && this.mEditor.getText().isEmpty();
        }

        @Override
        public AGeom getNewValue() {
            if (this.mEditor == null) {
                return (AGeom)this.getOriginalValue();
            }
            return this.fromString(this.mEditor.getText());
        }

        private void prepareEditComp() {
            if (this.mEditor != null) {
                return;
            }
            this.mEditor = new JTextArea(1, 26);
            this.mEditor.setLineWrap(true);
            this.mEditor.setWrapStyleWord(true);
            this.mEditor.setText(this.getValueAsString((AGeom)this.getOriginalValue()));
            this.mScrollPane = new JScrollPane(this.mEditor);
        }

        @Override
        public JComponent getEditComp() {
            this.prepareEditComp();
            return this.mScrollPane;
        }

        public AGeom fromString(String s) {
            if ((s = s.trim()).isEmpty()) {
                return null;
            }
            try {
                Interpreter interpreter = Cp.getCp().createChildInterpreter();
                interpreter.eval("import com.sigrity.acl.geom.*;");
                Object o = interpreter.eval(s);
                if (o instanceof AGeom) {
                    return (AGeom)o;
                }
            }
            catch (EvalError ee) {
                ALog.logWarn((Throwable)ee, (String)"Error creating AGeom.", (Object[])new Object[0]);
            }
            return null;
        }

        @Override
        public GridBagConstraints getPreferredGridBagConstraints() {
            return GridBagManager.FILLALL;
        }

        @Override
        public String getValueAsString(AGeom val) {
            return val == null ? null : val.getAsStringArg();
        }

        @Override
        public String getValueAsStringArg(AGeom val) {
            if (val == null) {
                return "null";
            }
            return val.getAsStringArg();
        }

        @Override
        public String getValueUnitName() {
            if (this.mUnit != null) {
                return this.mUnit.getUserName();
            }
            return null;
        }

        @Override
        public void setNewValueAsString(String s) {
            this.prepareEditComp();
            this.mEditor.setText(s);
        }

        public static enum HintKey {
            Unit,
            AcceptEmpty;

        }
    }

    public static class APoint2DEditor
    extends AValueEditorAbstract<APoint2D> {
        public static final AValueEditor.Factory<APoint2D> Factory = new AValueEditor.Factory<APoint2D>(){

            @Override
            public AValueEditor<APoint2D> create(Class<APoint2D> type, APoint2D val, Properties hints) {
                return new APoint2DEditor(val, hints);
            }
        };
        protected final String FMT_INTEGRAL = "%d %d";
        protected final String FMT_FLOATINGPOINT = "%s %s";
        protected JTextField mEditor;
        protected boolean mAcceptEmpty = false;
        protected Unit mUnit = null;

        public APoint2DEditor(APoint2D val, Properties hints) {
            super(APoint2D.class, val);
            this.mAcceptEmpty = APoint2DEditor.getHint(hints, (Object)HintKey.AcceptEmpty, Boolean.class, false);
            if (APoint2DEditor.containsHint(hints, (Object)HintKey.Unit)) {
                this.mUnit = APoint2DEditor.getHint(hints, (Object)HintKey.Unit, Unit.class, null);
            }
        }

        public boolean getAcceptEmpty() {
            return this.mAcceptEmpty;
        }

        public void setAcceptEmpty(boolean b) {
            this.mAcceptEmpty = b;
        }

        @Override
        public boolean isValid() {
            return this.getNewValue() != null || this.mAcceptEmpty && this.mEditor.getText().isEmpty();
        }

        @Override
        public APoint2D getNewValue() {
            if (this.mEditor == null) {
                return (APoint2D)this.getOriginalValue();
            }
            return this.fromString(this.mEditor.getText());
        }

        @Override
        public JComponent getEditComp() {
            if (this.mEditor == null) {
                this.mEditor = new JTextField(26);
                this.mEditor.setText(this.getValueAsString((APoint2D)this.getOriginalValue()));
            }
            return this.mEditor;
        }

        public APoint2D fromString(String s) {
            if ((s = s.trim()).length() < 3) {
                return null;
            }
            String[] comps = s.split("\\s+");
            if (comps.length != 2) {
                return null;
            }
            try {
                if (this.mUnit != null) {
                    return new APoint2D(this.mUnit.fromUserString(comps[0]).longValue(), this.mUnit.fromUserString(comps[1]).longValue());
                }
                return new APoint2D(Long.parseLong(comps[0]), Long.parseLong(comps[1]));
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }

        @Override
        public GridBagConstraints getPreferredGridBagConstraints() {
            return GridBagManager.LEFT;
        }

        @Override
        public String getValueAsString(APoint2D val) {
            if (val == null) {
                return "";
            }
            if (this.mUnit != null) {
                return String.format("%s %s", this.mUnit.toUserStr(val.getX()), this.mUnit.toUserStr(val.getY()));
            }
            return String.format("%d %d", val.getX(), val.getY());
        }

        @Override
        public String getValueAsStringArg(APoint2D val) {
            return APoint2D.getAsStringArg((APoint2D)val);
        }

        @Override
        public String getValueUnitName() {
            if (this.mUnit != null) {
                return this.mUnit.getUserName();
            }
            return null;
        }

        @Override
        public void setNewValueAsString(String s) {
            if (this.mEditor == null) {
                this.mEditor = new JTextField(26);
            }
            this.mEditor.setText(s);
        }

        public static enum HintKey {
            Unit,
            AcceptEmpty;

        }
    }

    public static class StringEditor
    extends AValueEditorAbstract<String> {
        public static final AValueEditor.Factory<String> Factory = new AValueEditor.Factory<String>(){

            @Override
            public AValueEditor<String> create(Class<String> type, String val, Properties hints) {
                return new StringEditor(val, hints);
            }
        };
        protected boolean mAcceptEmpty = false;
        protected JTextComponent mEditor;
        protected JScrollPane mScrollPane = null;
        protected int mCols = 0;
        protected int mLines = 0;

        public StringEditor(String val, Properties hints) {
            super(String.class, val);
            this.mCols = StringEditor.getHint(hints, (Object)HintKey.Cols, Integer.class, 0);
            this.mLines = StringEditor.getHint(hints, (Object)HintKey.Lines, Integer.class, 0);
            this.mAcceptEmpty = StringEditor.getHint(hints, (Object)HintKey.AcceptEmpty, Boolean.class, false);
            if (StringEditor.getHint(hints, (Object)HintKey.Scroll, Boolean.class, false).booleanValue()) {
                this.mScrollPane = new JScrollPane(){

                    @Override
                    public void requestFocus() {
                        mEditor.requestFocus();
                    }
                };
            }
        }

        public boolean getAcceptEmpty() {
            return this.mAcceptEmpty;
        }

        public void setAcceptEmpty(boolean b) {
            this.mAcceptEmpty = b;
        }

        @Override
        public boolean isValid() {
            return this.mAcceptEmpty || !this.mEditor.getText().isEmpty();
        }

        @Override
        public String getNewValue() {
            return this.mEditor == null ? (String)this.getOriginalValue() : this.mEditor.getText();
        }

        private void prepareEditComp() {
            int cols;
            int n = cols = this.mCols != 0 ? this.mCols : 30;
            if (this.mLines > 1 || this.mScrollPane != null) {
                this.mEditor = new JTextArea(this.mLines, cols){

                    @Override
                    public void addNotify() {
                        super.addNotify();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.setCaretPosition(0);
                            }
                        });
                    }
                };
                this.mScrollPane.setViewportView(this.mEditor);
                this.mScrollPane.setPreferredSize(this.mScrollPane.getPreferredSize());
                this.mEditor.setText((String)this.getOriginalValue());
            } else {
                this.mEditor = new JTextField(30);
                this.mEditor.setPreferredSize(this.mEditor.getPreferredSize());
                this.mEditor.setText((String)this.getOriginalValue());
            }
        }

        @Override
        public JComponent getEditComp() {
            if (this.mEditor == null) {
                this.prepareEditComp();
            }
            if (this.mScrollPane != null) {
                return this.mScrollPane;
            }
            return this.mEditor;
        }

        @Override
        public GridBagConstraints getPreferredGridBagConstraints() {
            if (this.mScrollPane != null) {
                return GridBagManager.FILLALL;
            }
            return GridBagManager.FILLX;
        }

        @Override
        public String getValueAsString(String val) {
            return val;
        }

        @Override
        public String getValueAsStringArg(String val) {
            return String.format("\"%s\"", val);
        }

        @Override
        public String getValueUnitName() {
            return null;
        }

        @Override
        public void setNewValueAsString(String s) {
            if (this.mEditor == null) {
                this.prepareEditComp();
            }
            this.mEditor.setText(s);
        }

        public static enum HintKey {
            AcceptEmpty,
            Cols,
            Lines,
            Scroll;

        }
    }

    public static class DoubleEditor
    extends NumberEditor<Double> {
        public static final AValueEditor.Factory<Double> Factory = new AValueEditor.Factory<Double>(){

            @Override
            public AValueEditor<Double> create(Class<Double> type, Double val, Properties hints) {
                return new DoubleEditor(val);
            }
        };

        public DoubleEditor(Double val) {
            super(Double.class, val);
        }

        @Override
        public Double fromString(String s) {
            return Double.parseDouble(s);
        }

        @Override
        public String getValueAsString(Double val) {
            if (val == null) {
                return null;
            }
            return Double.toString(val);
        }

        @Override
        public String getValueAsStringArg(Double val) {
            return this.getValueAsString(val);
        }

        @Override
        public String getValueUnitName() {
            return null;
        }
    }

    public static class FloatEditor
    extends NumberEditor<Float> {
        public static final AValueEditor.Factory<Float> Factory = new AValueEditor.Factory<Float>(){

            @Override
            public AValueEditor<Float> create(Class<Float> type, Float val, Properties hints) {
                return new FloatEditor(val);
            }
        };

        public FloatEditor(Float val) {
            super(Float.class, val);
        }

        @Override
        public Float fromString(String s) {
            return Float.valueOf(Float.parseFloat(s));
        }

        @Override
        public String getValueAsString(Float val) {
            return Float.toString(val.floatValue());
        }

        @Override
        public String getValueAsStringArg(Float val) {
            return this.getValueAsString(val) + "f";
        }

        @Override
        public String getValueUnitName() {
            return null;
        }
    }

    public static class DbLengthEditor
    extends NumberEditor<ADistance> {
        public static final AValueEditor.Factory<ADistance> Factory = new AValueEditor.Factory<ADistance>(){

            @Override
            public AValueEditor<ADistance> create(Class<ADistance> type, ADistance val, Properties hints) {
                return new DbLengthEditor(val, hints);
            }
        };
        protected Unit mUnit = null;

        public DbLengthEditor(ADistance val, Properties hints) {
            super(ADistance.class, val);
            if (DbLengthEditor.containsHint(hints, (Object)LongEditor.HintKey.Unit)) {
                this.mUnit = DbLengthEditor.getHint(hints, (Object)LongEditor.HintKey.Unit, Unit.class, null);
            }
        }

        @Override
        public String getValueAsString(ADistance val) {
            if (this.mUnit != null) {
                return this.mUnit.toUserStr(val.val());
            }
            return Long.toString(val.val());
        }

        @Override
        public String getValueAsStringArg(ADistance val) {
            return Long.toString(val.val()) + "L";
        }

        @Override
        public ADistance fromString(String s) {
            if (this.mUnit != null) {
                return new ADistance(this.mUnit.fromUserString(s).longValue());
            }
            return new ADistance(Long.parseLong(s));
        }

        @Override
        public String getValueUnitName() {
            if (this.mUnit != null) {
                return this.mUnit.getUserName();
            }
            return null;
        }
    }

    public static class LongDateEditor
    extends AValueEditorAbstract<Long> {
        public static final AValueEditor.Factory<Long> Factory = new AValueEditor.Factory<Long>(){

            @Override
            public AValueEditor<Long> create(Class<Long> type, Long val, Properties hints) {
                return new LongDateEditor(val, hints);
            }
        };
        protected boolean mAcceptEmpty = false;
        protected JTextComponent mEditor;
        protected JScrollPane mScrollPane = null;
        protected int mCols = 0;
        protected int mLines = 0;

        public LongDateEditor(Long val, Properties hints) {
            super(Long.class, val);
        }

        public boolean getAcceptEmpty() {
            return this.mAcceptEmpty;
        }

        public void setAcceptEmpty(boolean b) {
            this.mAcceptEmpty = b;
        }

        @Override
        public boolean isValid() {
            return this.mAcceptEmpty || !this.mEditor.getText().isEmpty();
        }

        @Override
        public Long getNewValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            try {
                date = sdf.parse(this.mEditor.getText());
            }
            catch (ParseException e) {
                ALog.logError((Throwable)e);
            }
            return this.mEditor == null ? ((Long)this.getOriginalValue()).longValue() : date.getTime();
        }

        private void prepareEditComp() {
            int cols;
            int n = cols = this.mCols != 0 ? this.mCols : 30;
            if (this.mLines > 1 || this.mScrollPane != null) {
                this.mEditor = new JTextArea(this.mLines, cols){

                    @Override
                    public void addNotify() {
                        super.addNotify();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.setCaretPosition(0);
                            }
                        });
                    }
                };
                this.mScrollPane.setViewportView(this.mEditor);
                this.mScrollPane.setPreferredSize(this.mScrollPane.getPreferredSize());
                this.mEditor.setText("" + this.getOriginalValue());
            } else {
                this.mEditor = new JTextField(30);
                this.mEditor.setPreferredSize(this.mEditor.getPreferredSize());
                this.mEditor.setText("" + this.getOriginalValue());
            }
        }

        @Override
        public JComponent getEditComp() {
            if (this.mEditor == null) {
                this.prepareEditComp();
            }
            if (this.mScrollPane != null) {
                return this.mScrollPane;
            }
            return this.mEditor;
        }

        @Override
        public GridBagConstraints getPreferredGridBagConstraints() {
            if (this.mScrollPane != null) {
                return GridBagManager.FILLALL;
            }
            return GridBagManager.FILLX;
        }

        @Override
        public String getValueAsString(Long val) {
            return new Date(val).toString();
        }

        @Override
        public String getValueAsStringArg(Long val) {
            return val + "L";
        }

        @Override
        public String getValueUnitName() {
            return null;
        }

        @Override
        public void setNewValueAsString(String s) {
            if (this.mEditor == null) {
                this.prepareEditComp();
            }
            this.mEditor.setText(s);
        }
    }

    public static class LongEditor
    extends NumberEditor<Long> {
        public static final AValueEditor.Factory<Long> Factory = new AValueEditor.Factory<Long>(){

            @Override
            public AValueEditor<Long> create(Class<Long> type, Long val, Properties hints) {
                return new LongEditor(val, hints);
            }
        };
        protected Unit mUnit = null;

        public LongEditor(Long val, Properties hints) {
            super(Long.class, val);
            if (LongEditor.containsHint(hints, (Object)HintKey.Unit)) {
                this.mUnit = LongEditor.getHint(hints, (Object)HintKey.Unit, Unit.class, null);
            }
        }

        @Override
        public Long fromString(String s) {
            if (this.mUnit != null) {
                return this.mUnit.fromUserString(s);
            }
            return Long.parseLong(s);
        }

        @Override
        public String getValueAsString(Long val) {
            if (val == null) {
                return null;
            }
            if (this.mUnit != null) {
                return this.mUnit.toUserStr(val.longValue());
            }
            return Long.toString(val);
        }

        @Override
        public String getValueAsStringArg(Long val) {
            return Long.toString(val) + "L";
        }

        @Override
        public String getValueUnitName() {
            if (this.mUnit != null) {
                return this.mUnit.getUserName();
            }
            return null;
        }

        public static enum HintKey {
            Unit,
            NONE;

        }
    }

    public static class IntegerEditor
    extends NumberEditor<Integer> {
        public static final AValueEditor.Factory<Integer> Factory = new AValueEditor.Factory<Integer>(){

            @Override
            public AValueEditor<Integer> create(Class<Integer> type, Integer val, Properties hints) {
                return new IntegerEditor(val);
            }
        };

        public IntegerEditor(Integer val) {
            super(Integer.class, val);
        }

        @Override
        public Integer fromString(String s) {
            return Integer.parseInt(s);
        }

        @Override
        public String getValueAsString(Integer val) {
            if (val == null) {
                return null;
            }
            return Integer.toString(val);
        }

        @Override
        public String getValueAsStringArg(Integer val) {
            return this.getValueAsString(val);
        }

        @Override
        public String getValueUnitName() {
            return null;
        }
    }

    public static abstract class NumberEditor<T extends Number>
    extends AValueEditorAbstract<T> {
        protected JTextField mEditor;
        protected T mLastValid;

        public NumberEditor(Class<T> type, T val) {
            super(type, val);
            this.mLastValid = val;
        }

        @Override
        public boolean isValid() {
            try {
                this.mLastValid = this.fromString(this.mEditor.getText());
            }
            catch (NumberFormatException nfe) {
                this.mLastValid = null;
                return false;
            }
            return true;
        }

        @Override
        public T getNewValue() {
            if (this.mEditor == null) {
                return (T)((Number)this.getOriginalValue());
            }
            this.isValid();
            return this.mLastValid;
        }

        @Override
        public JComponent getEditComp() {
            if (this.mEditor == null) {
                this.mEditor = new JTextField(12);
                this.mEditor.setText(this.getValueAsString((Number)this.getOriginalValue()));
            }
            return this.mEditor;
        }

        public abstract T fromString(String var1);

        @Override
        public GridBagConstraints getPreferredGridBagConstraints() {
            return GridBagManager.LEFT;
        }

        @Override
        public void setNewValueAsString(String s) {
            if (this.mEditor == null) {
                this.mEditor = new JTextField(12);
            }
            this.mEditor.setText(s);
        }
    }

    public static class EnumEditor<T extends Enum<?>>
    extends AValueEditorAbstract<T> {
        public static final AValueEditor.Factory<Enum<?>> Factory = new AValueEditor.Factory<Enum<?>>(){

            @Override
            public AValueEditor<Enum<?>> create(Class<Enum<?>> type, Enum<?> val, Properties hints) {
                return new EnumEditor(type, val);
            }
        };
        protected JComboBox<T> mEditor;

        public EnumEditor(Class<T> type, T val) {
            super(type, val);
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public T getNewValue() {
            return (T)(this.mEditor == null ? (Enum)this.getOriginalValue() : (Enum)this.mEditor.getItemAt(this.mEditor.getSelectedIndex()));
        }

        @Override
        public JComponent getEditComp() {
            if (this.mEditor == null) {
                this.mEditor = new JComboBox<Enum>((Enum[])this.mType.getEnumConstants());
                this.mEditor.setSelectedItem(this.getOriginalValue());
            }
            return this.mEditor;
        }

        @Override
        public GridBagConstraints getPreferredGridBagConstraints() {
            return GridBagManager.LEFT;
        }

        @Override
        public String getValueAsString(T val) {
            return val == null ? "" : ((Enum)val).name();
        }

        @Override
        public String getValueAsStringArg(T val) {
            return String.format("%s.%s", val.getClass().getName(), ((Enum)val).name());
        }

        @Override
        public String getValueUnitName() {
            return null;
        }

        @Override
        public void setNewValueAsString(String s) {
            if (this.mEditor == null) {
                this.mEditor = new JComboBox<Enum>((Enum[])this.mType.getEnumConstants());
            }
            for (int i = 0; i < this.mEditor.getItemCount(); ++i) {
                if (!((Enum)this.mEditor.getItemAt(i)).toString().equals(s)) continue;
                this.mEditor.setSelectedIndex(i);
            }
        }
    }

    public static class BooleanEditor
    extends AValueEditorAbstract<Boolean> {
        public static final AValueEditor.Factory<Boolean> Factory = new AValueEditor.Factory<Boolean>(){

            @Override
            public AValueEditor<Boolean> create(Class<Boolean> type, Boolean val, Properties hints) {
                return new BooleanEditor(val);
            }
        };
        protected JComboBox<Boolean> mEditor;

        public BooleanEditor(Boolean val) {
            super(Boolean.class, val);
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Boolean getNewValue() {
            return this.mEditor == null ? (Boolean)this.getOriginalValue() : this.mEditor.getItemAt(this.mEditor.getSelectedIndex());
        }

        @Override
        public JComponent getEditComp() {
            if (this.mEditor == null) {
                this.mEditor = new JComboBox<Boolean>(new Boolean[]{true, false});
                this.mEditor.setSelectedItem(this.getOriginalValue());
            }
            return this.mEditor;
        }

        @Override
        public GridBagConstraints getPreferredGridBagConstraints() {
            return GridBagManager.LEFT;
        }

        @Override
        public String getValueAsString(Boolean val) {
            if (val == null) {
                return null;
            }
            return Boolean.toString(val);
        }

        @Override
        public String getValueAsStringArg(Boolean val) {
            return Boolean.toString(val);
        }

        @Override
        public String getValueUnitName() {
            return null;
        }

        @Override
        public void setNewValueAsString(String s) {
            s = s.toLowerCase();
            if (this.mEditor == null) {
                this.mEditor = new JComboBox<Boolean>(new Boolean[]{true, false});
            }
            this.mEditor.setSelectedItem(Boolean.valueOf(s));
        }
    }
}

