/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui.editors;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.sigrity.acl.AItrType;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.geom.ADistance;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.editors.AValueEditor;
import com.sigrity.acl.ui.editors.AValueEditorBasic;
import java.awt.Color;
import java.util.LinkedList;
import java.util.Properties;

public class AValueEditorRegistry {
    protected static final AValueEditorRegistry gDefaultRegistry = new AValueEditorRegistry();
    protected ListMultimap<Class<?>, AValueEditor.Factory<?>> mType2EditorFactories = LinkedListMultimap.create();

    public static AValueEditorRegistry getDefaultRegistry() {
        return gDefaultRegistry;
    }

    public boolean hasEditorFactory(Class<?> type) {
        return this.mType2EditorFactories.containsKey(type);
    }

    public <T> IterableIterator<AValueEditor.Factory<T>> getEditorFactories(Class<T> type) {
        LinkedList list = new LinkedList();
        for (Class<T> curType = type; curType != null; curType = curType.getSuperclass()) {
            list.addAll(this.mType2EditorFactories.get(curType));
        }
        AItrType res = new AItrType(list, AValueEditor.Factory.class);
        return res;
    }

    public <T> AValueEditor.Factory<T> getDefaultEditorFactory(Class<T> type) {
        IterableIterator<AValueEditor.Factory<T>> factories = this.getEditorFactories(type);
        if (factories.hasNext()) {
            return (AValueEditor.Factory)factories.next();
        }
        return null;
    }

    public <T> boolean addEditorFactory(Class<T> type, AValueEditor.Factory<? extends T> factory) {
        if (this.mType2EditorFactories.containsEntry(type, factory)) {
            return false;
        }
        return this.mType2EditorFactories.put(type, factory);
    }

    public <T> void setDefaultEditorFactory(Class<T> type, AValueEditor.Factory<T> factory) {
        this.mType2EditorFactories.remove(type, factory);
        LinkedList otherFactories = AUtil.linkedList(this.getEditorFactories(type));
        this.mType2EditorFactories.removeAll(type);
        this.addEditorFactory(type, factory);
        for (AValueEditor.Factory otherFactory : otherFactories) {
            this.addEditorFactory(type, otherFactory);
        }
    }

    public <T> boolean removeEditorFactory(Class<T> type, AValueEditor.Factory<T> factory) {
        return this.mType2EditorFactories.remove(type, factory);
    }

    public static <T> AValueEditor<T> getValueEditor(Class<T> type, T val, Properties hints) {
        AValueEditor.Factory<T> f = AValueEditorRegistry.getDefaultRegistry().getDefaultEditorFactory(type);
        if (f == null) {
            return null;
        }
        return f.create(type, val, hints);
    }

    static {
        gDefaultRegistry.addEditorFactory(Boolean.class, AValueEditorBasic.BooleanEditor.Factory);
        gDefaultRegistry.addEditorFactory(Boolean.TYPE, AValueEditorBasic.BooleanEditor.Factory);
        gDefaultRegistry.addEditorFactory(Integer.class, AValueEditorBasic.IntegerEditor.Factory);
        gDefaultRegistry.addEditorFactory(Integer.TYPE, AValueEditorBasic.IntegerEditor.Factory);
        gDefaultRegistry.addEditorFactory(Long.class, AValueEditorBasic.LongEditor.Factory);
        gDefaultRegistry.addEditorFactory(Long.TYPE, AValueEditorBasic.LongEditor.Factory);
        gDefaultRegistry.addEditorFactory(Float.class, AValueEditorBasic.FloatEditor.Factory);
        gDefaultRegistry.addEditorFactory(Float.TYPE, AValueEditorBasic.FloatEditor.Factory);
        gDefaultRegistry.addEditorFactory(Double.class, AValueEditorBasic.DoubleEditor.Factory);
        gDefaultRegistry.addEditorFactory(Double.TYPE, AValueEditorBasic.DoubleEditor.Factory);
        gDefaultRegistry.addEditorFactory(Enum.class, AValueEditorBasic.EnumEditor.Factory);
        gDefaultRegistry.addEditorFactory(String.class, AValueEditorBasic.StringEditor.Factory);
        gDefaultRegistry.addEditorFactory(APoint2D.class, AValueEditorBasic.APoint2DEditor.Factory);
        gDefaultRegistry.addEditorFactory(AGeom.class, AValueEditorBasic.AGeomEditor.Factory);
        gDefaultRegistry.addEditorFactory(ADistance.class, AValueEditorBasic.DbLengthEditor.Factory);
        gDefaultRegistry.addEditorFactory(Color.class, AValueEditorBasic.ColorEditor.Factory);
    }
}

