/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui.editors;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbFieldHandler;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.geom.ADistance;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.HasPreferredGridBagConstraints;
import com.sigrity.acl.ui.editors.AValueEditor;
import com.sigrity.acl.ui.editors.AValueEditorBasic;
import com.sigrity.acl.ui.editors.AValueEditorRegistry;
import java.awt.GridBagConstraints;
import java.util.Properties;
import javax.swing.JComponent;

public class DbFieldEditor<T> {
    protected DbFieldDef mField;
    protected DbObject mDbObject;
    protected AValueEditor<T> mValueEditor;

    public static boolean canEditField(DbFieldDef dbfd) {
        Class type = dbfd.getFieldClass();
        return null != AValueEditorRegistry.getValueEditor(type, null, null);
    }

    private static Class<?> getAssignableType(DbFieldDef dbfd, boolean upcast) {
        if (upcast && dbfd.getFieldClass().equals(Integer.class)) {
            return Long.class;
        }
        return dbfd.getFieldClass();
    }

    private static <T> DbFieldEditor<T> getFieldEditor(Class<T> type, DbFieldDef dbfd, DbObject dbo) {
        Object val = dbfd.getValue(dbo);
        Properties hints = new Properties();
        Unit unit = DbFieldEditor.getUnit(dbfd);
        if (String.class.isAssignableFrom(type)) {
            if (dbfd.getCData()) {
                hints.put((Object)AValueEditorBasic.StringEditor.HintKey.Lines, (Object)5);
                hints.put((Object)AValueEditorBasic.StringEditor.HintKey.Cols, (Object)40);
                hints.put((Object)AValueEditorBasic.StringEditor.HintKey.Scroll, (Object)true);
            } else if (!dbfd.getIsKey()) {
                hints.put((Object)AValueEditorBasic.StringEditor.HintKey.AcceptEmpty, (Object)true);
            }
        } else if (APoint2D.class.isAssignableFrom(type)) {
            if (unit != null) {
                hints.put((Object)AValueEditorBasic.APoint2DEditor.HintKey.Unit, unit);
            }
        } else if ((Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || ADistance.class.isAssignableFrom(type)) && unit != null) {
            hints.put((Object)AValueEditorBasic.LongEditor.HintKey.Unit, unit);
        }
        AValueEditor<Object> editor = AValueEditorRegistry.getValueEditor(type, val, hints);
        if (editor == null) {
            return null;
        }
        return new DbFieldEditor<Object>(dbfd, dbo, editor);
    }

    public static <T> DbFieldEditor<T> getFieldEditor(DbFieldDef dbfd, DbObject dbo) {
        try {
            Class defType = dbfd.getHandler();
            if (defType != null && DbFieldHandler.BasicLong.class.isAssignableFrom(defType)) {
                Properties hints = new Properties();
                AValueEditor<Long> editor = AValueEditorBasic.LongEditor.Factory.create(Long.class, (Long)dbfd.getValue(dbo), hints);
                return new DbFieldEditor<Long>(dbfd, dbo, editor);
            }
            if (defType != null && DbFieldHandler.LongDate.class.isAssignableFrom(defType)) {
                Properties hints = new Properties();
                AValueEditor<Long> editor = AValueEditorBasic.LongDateEditor.Factory.create(Long.class, (Long)dbfd.getValue(dbo), hints);
                return new DbFieldEditor<Long>(dbfd, dbo, editor);
            }
            Class<?> type = DbFieldEditor.getAssignableType(dbfd, false);
            return DbFieldEditor.getFieldEditor(type, dbfd, dbo);
        }
        catch (Exception e) {
            Class<?> type = DbFieldEditor.getAssignableType(dbfd, true);
            return DbFieldEditor.getFieldEditor(type, dbfd, dbo);
        }
    }

    protected static Unit getUnit(DbFieldDef dbfd) {
        DbClass dbc = dbfd.getDeclaringDbClass();
        Db db = dbc == null ? null : dbc.getDb();
        Design design = db == null ? null : Design.getDesign((Db)db, (boolean)false);
        return design == null ? null : design.getUnit();
    }

    public DbFieldEditor(DbFieldDef dbfd, DbObject dbo, AValueEditor<T> valueEditor) {
        this.mField = dbfd;
        this.mDbObject = dbo;
        this.mValueEditor = valueEditor;
        assert (this.mField.getValue(dbo) == null || this.mValueEditor.getType().isAssignableFrom(this.mField.getValue(dbo).getClass()));
    }

    public JComponent getEditor() {
        return this.mValueEditor.getEditComp();
    }

    public AValueEditor<T> getValueEditor() {
        return this.mValueEditor;
    }

    public T getOldValue() {
        Object val = this.mField.getValue(this.mDbObject);
        return (T)val;
    }

    public boolean hasNewValue() {
        return this.mValueEditor.isModified();
    }

    public boolean validateNewValue() {
        return this.mValueEditor.isValid();
    }

    public T getNewValue() {
        return this.mValueEditor.getNewValue();
    }

    public String getValueAsString(T val) {
        return this.mValueEditor.getValueAsString(val);
    }

    public String getOldValueAsString() {
        return this.getValueAsString(this.getOldValue());
    }

    public String getNewValueAsString() {
        return this.getValueAsString(this.getNewValue());
    }

    public String getValueAsStringArg(T val) {
        return this.mValueEditor.getValueAsStringArg(val);
    }

    public String getNewValueAsStringArg() {
        return this.getValueAsStringArg(this.getNewValue());
    }

    public String getValueUnitName() {
        return this.mValueEditor.getValueUnitName();
    }

    public GridBagConstraints getPreferredConstraints() {
        if (this.mValueEditor instanceof HasPreferredGridBagConstraints) {
            return ((HasPreferredGridBagConstraints)((Object)this.mValueEditor)).getPreferredGridBagConstraints();
        }
        return GridBagManager.LEFT;
    }

    public boolean saveNewValue() {
        if (!this.hasNewValue()) {
            return false;
        }
        if (!this.validateNewValue()) {
            return false;
        }
        DbClass dbc = this.mDbObject.getDbClass();
        if (dbc == null) {
            return this.mDbObject.setValue(this.mField.getName(), this.getNewValue());
        }
        if (!dbc.hasKeyFields()) {
            ALog.logWarn((String)"Save value with non-key fields object. The logged script might not be replayed.");
        }
        String strKey = this.mDbObject.getKeyStr();
        String className = this.mDbObject.getClass().getName();
        String fieldName = this.mField.getName();
        String strVal = this.getValueAsStringArg(this.getNewValue());
        if (strVal == null) {
            return false;
        }
        try {
            return (Boolean)Cp.exec((String)"curDb().getByKeyStr(%s.class, \"%s\").setValue(\"%s\", %s)", (Object[])new Object[]{className, strKey, fieldName, strVal});
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Error saving value.", (Object[])new Object[0]);
            return false;
        }
    }

    public void changeTarget(DbObject obj) {
        this.mDbObject = obj;
    }
}

