/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui.graph;

import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ui.OrbitIcons;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractModalGraphMouse;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.control.TranslatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.layout.LayoutTransition;
import edu.uci.ics.jung.visualization.renderers.BasicVertexRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import edu.uci.ics.jung.visualization.util.Animator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

public class AGraphPanel
extends JPanel {
    public static final Icon ICON_ZOOMIN = OrbitIcons.ZOOM_IN;
    public static final Icon ICON_ZOOMOUT = OrbitIcons.ZOOM_OUT;
    public static final Icon ICON_NAVIGATE = OrbitIcons.NAVIGATE;
    public static final Icon ICON_PICKANDMOVE = AGraphPanel.getIcon("res/iconPickAndMove.png");
    public static final Icon ICON_OPTIONS = OrbitIcons.COG;
    protected JPanel mViewContainer;
    protected JPanel mViewControlsContainer;
    protected Viewer mViewer;
    protected JComboBox<Layout<GPVertex, GPEdge>> mLayoutSelector;

    public AGraphPanel(Layout<GPVertex, GPEdge>[] layouts) {
        GridBagManager layout = new GridBagManager((Container)this);
        this.mViewContainer = new JPanel(new BorderLayout());
        this.mViewControlsContainer = new JPanel(new BorderLayout());
        layout.add((Component)this.mViewControlsContainer, (GridBagConstraints)GridBagManager.FILLX.noInsets());
        layout.newline();
        layout.add((Component)this.mViewContainer, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
        this.setLayouts(layouts);
    }

    public void setLayouts(Layout<GPVertex, GPEdge>[] layouts) {
        Layout<GPVertex, GPEdge> layout = layouts[0];
        Layout<GPVertex, GPEdge> prevLayout = this.getSelectedLayout();
        if (this.mLayoutSelector != null && prevLayout != null) {
            for (Layout<GPVertex, GPEdge> l : layouts) {
                if (l.getClass() != prevLayout.getClass()) continue;
                layout = l;
                break;
            }
        }
        this.mViewContainer.removeAll();
        this.mViewControlsContainer.removeAll();
        this.mViewer = this.createViewer(layout);
        this.mViewer.setGraphMouse((VisualizationViewer.GraphMouse)this.createGraphMouse());
        GraphZoomScrollPane panel = new GraphZoomScrollPane((VisualizationViewer)this.mViewer);
        panel.setBorder(BorderFactory.createEtchedBorder());
        this.mViewContainer.add((Component)panel);
        this.mViewControlsContainer.add(this.createViewControls(layouts, layout));
        if (this.getParent() != null) {
            this.getParent().validate();
        }
    }

    protected Viewer createViewer(Layout<GPVertex, GPEdge> layout) {
        return new Viewer(layout);
    }

    protected static void initViewControlButton(AbstractButton btn, Icon icon, String tip, ActionListener l) {
        btn.setIcon(icon);
        btn.setToolTipText(tip);
        btn.addActionListener(l);
        UIUtil.makeToolBarButton((AbstractButton)btn);
    }

    protected static JButton createViewControlButton(Icon icon, String tip, ActionListener l) {
        JButton btn = new JButton();
        AGraphPanel.initViewControlButton(btn, icon, tip, l);
        return btn;
    }

    protected static JToggleButton createViewControlToggleButton(Icon icon, String tip, ActionListener l) {
        JToggleButton btn = new JToggleButton();
        AGraphPanel.initViewControlButton(btn, icon, tip, l);
        return btn;
    }

    protected JComponent createViewControls(Layout<GPVertex, GPEdge>[] layouts, Layout<GPVertex, GPEdge> selLayout) {
        JPanel pnl = new JPanel();
        GridBagManager layout = GridBagManager.layout((Container)pnl);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        layout.add("Layout:");
        this.mLayoutSelector = (JComboBox)layout.add(this.createLayoutSelector(layouts), (GridBagConstraints)GridBagManager.LEFT);
        if (selLayout != null) {
            this.mLayoutSelector.setSelectedItem(selLayout);
        }
        layout.add("Mode:");
        layout.add((Component)this.createModeControl());
        layout.add("Zoom:");
        layout.add((Component)AGraphPanel.createViewControlButton(ICON_ZOOMIN, "Zoom in", arg_0 -> this.lambda$createViewControls$0((ScalingControl)scaler, arg_0)), (GridBagConstraints)GridBagManager.LEFT.noInsets());
        layout.add((Component)AGraphPanel.createViewControlButton(ICON_ZOOMOUT, "Zoom out", arg_0 -> this.lambda$createViewControls$1((ScalingControl)scaler, arg_0)), (GridBagConstraints)GridBagManager.LEFT.noInsets());
        pnl.setMinimumSize(pnl.getPreferredSize());
        return pnl;
    }

    protected JComboBox<Layout<GPVertex, GPEdge>> createLayoutSelector(Layout<GPVertex, GPEdge>[] layouts) {
        JComboBox<Layout<GPVertex, GPEdge>> cbLayout = new JComboBox<Layout<GPVertex, GPEdge>>(layouts);
        cbLayout.addItemListener(e -> {
            Layout<GPVertex, GPEdge> layout = this.getSelectedLayout();
            this.setLayout(layout);
        });
        cbLayout.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                this.setText(value.getClass().getSimpleName());
                return this;
            }
        });
        return cbLayout;
    }

    public Layout<GPVertex, GPEdge> getSelectedLayout() {
        return this.mLayoutSelector == null ? null : (Layout)this.mLayoutSelector.getModel().getElementAt(this.mLayoutSelector.getSelectedIndex());
    }

    public void setLayout(Layout<GPVertex, GPEdge> lNew) {
        RenderContext rc = this.mViewer.getRenderContext();
        Layout lOld = this.mViewer.getGraphLayout();
        LayoutTransition lt = new LayoutTransition((VisualizationViewer)this.mViewer, lOld, lNew);
        Animator animator = new Animator((IterativeContext)lt);
        animator.start();
        rc.getMultiLayerTransformer().setToIdentity();
        this.mViewer.repaint();
    }

    protected DefaultModalGraphMouse<GPVertex, GPEdge> createGraphMouse() {
        return new OrbitGraphMouse();
    }

    protected JComponent createModeControl() {
        AbstractModalGraphMouse mgm = (AbstractModalGraphMouse)this.mViewer.getGraphMouse();
        JToggleButton tbPan = AGraphPanel.createViewControlToggleButton(ICON_NAVIGATE, "Pan View", e -> mgm.setMode(ModalGraphMouse.Mode.TRANSFORMING));
        JToggleButton tbPick = AGraphPanel.createViewControlToggleButton(ICON_PICKANDMOVE, "Pick and move vertices", e -> mgm.setMode(ModalGraphMouse.Mode.PICKING));
        ButtonGroup bg = new ButtonGroup();
        bg.add(tbPan);
        bg.add(tbPick);
        tbPick.doClick();
        JPanel pnl = new JPanel();
        GridBagManager l = GridBagManager.layout((Container)pnl);
        pnl.setBorder(BorderFactory.createEmptyBorder());
        l.add((Component)tbPan, (GridBagConstraints)GridBagManager.LEFT.noInsets());
        l.add((Component)tbPick, (GridBagConstraints)GridBagManager.LEFT.noInsets());
        return pnl;
    }

    public static Icon getIcon(String name) {
        return UIUtil.getIcon(AGraphPanel.class, (String)name);
    }

    private /* synthetic */ void lambda$createViewControls$1(ScalingControl scaler, ActionEvent e) {
        scaler.scale((VisualizationServer)this.mViewer, 0.9090909f, this.mViewer.getCenter());
    }

    private /* synthetic */ void lambda$createViewControls$0(ScalingControl scaler, ActionEvent e) {
        scaler.scale((VisualizationServer)this.mViewer, 1.1f, this.mViewer.getCenter());
    }

    protected static class VertexRenderer
    extends BasicVertexRenderer<GPVertex, GPEdge> {
        protected VertexRenderer() {
        }

        public void paintIconForVertex(RenderContext<GPVertex, GPEdge> rc, GPVertex v, Layout<GPVertex, GPEdge> layout) {
            Point2D p = (Point2D)layout.transform((Object)v);
            p = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, p);
            float x = (float)p.getX();
            float y = (float)p.getY();
            GraphicsDecorator g = rc.getGraphicsContext();
            Transformer vertexIconFunction = rc.getVertexIconTransformer();
            Icon icon = (Icon)vertexIconFunction.transform((Object)v);
            Shape s = AffineTransform.getTranslateInstance(x, y).createTransformedShape((Shape)rc.getVertexShapeTransformer().transform((Object)v));
            this.paintShapeForVertex(rc, v, s);
            if (icon != null) {
                int xLoc = (int)((double)x - (double)icon.getIconWidth() / 2.0);
                int yLoc = (int)((double)y - (double)icon.getIconHeight() / 2.0);
                icon.paintIcon(rc.getScreenDevice(), g.getDelegate(), xLoc, yLoc);
            }
        }
    }

    protected static class VertexShape
    implements Transformer<GPVertex, Shape> {
        protected VertexShape() {
        }

        public Shape transform(GPVertex v) {
            Icon icon = v.getIcon();
            if (icon == null) {
                return null;
            }
            int w = icon.getIconWidth() + 5;
            int h = icon.getIconHeight() + 5;
            return new Ellipse2D.Float((float)(-w) / 2.0f - 1.0f, (float)(-h) / 2.0f - 1.0f, w, h);
        }
    }

    protected static class VertexIcon
    implements Transformer<GPVertex, Icon> {
        protected VertexIcon() {
        }

        public Icon transform(GPVertex v) {
            return v.getIcon();
        }
    }

    protected static class VertexPaint
    implements Transformer<GPVertex, Paint> {
        protected VertexPaint() {
        }

        public Paint transform(GPVertex v) {
            return v.getPaint();
        }
    }

    protected static class VertexNameLabeller
    implements Transformer<GPVertex, String> {
        protected VertexNameLabeller() {
        }

        public String transform(GPVertex v) {
            return v.getLabel();
        }
    }

    protected static class EdgeNameLabeller
    implements Transformer<GPEdge, String> {
        protected EdgeNameLabeller() {
        }

        public String transform(GPEdge e) {
            return e.getLabel();
        }
    }

    protected class Viewer
    extends VisualizationViewer<GPVertex, GPEdge> {
        public Viewer(Layout<GPVertex, GPEdge> layout) {
            super(layout);
            this.setBackground(Color.white);
            RenderContext rc = this.getRenderContext();
            rc.setEdgeShapeTransformer((Transformer)new EdgeShape.Line());
            rc.setEdgeLabelTransformer((Transformer)new EdgeNameLabeller());
            rc.setVertexLabelTransformer((Transformer)new VertexNameLabeller());
            ConstantTransformer arrowFill = new ConstantTransformer((Object)Color.lightGray);
            rc.setArrowFillPaintTransformer((Transformer)arrowFill);
            rc.setVertexFillPaintTransformer((Transformer)new VertexPaint());
            rc.setVertexIconTransformer((Transformer)new VertexIcon());
            rc.setVertexShapeTransformer((Transformer)new VertexShape());
            this.getRenderer().setVertexRenderer((Renderer.Vertex)new VertexRenderer());
            this.setVertexToolTipTransformer(new VertexNameLabeller());
            this.setEdgeToolTipTransformer(new EdgeNameLabeller());
        }
    }

    static class OrbitTranslatingMousePlugin
    extends TranslatingGraphMousePlugin {
        OrbitTranslatingMousePlugin() {
            super(8);
        }
    }

    static class OrbitGraphMouse
    extends DefaultModalGraphMouse<GPVertex, GPEdge> {
        private OrbitTranslatingMousePlugin mTranslatingPlugin = new OrbitTranslatingMousePlugin();

        OrbitGraphMouse() {
            super(0.9090909f, 1.1f);
        }

        protected void setPickingMode() {
            super.setPickingMode();
            this.add((GraphMousePlugin)this.mTranslatingPlugin);
        }

        protected void setTransformingMode() {
            super.setTransformingMode();
            this.add((GraphMousePlugin)this.mTranslatingPlugin);
        }
    }

    public static class GPEdge {
        Type mType;

        public GPEdge() {
            this(Type.SOLID);
        }

        public GPEdge(Type type) {
            this.mType = type;
        }

        public String getLabel() {
            return null;
        }

        public Type getType() {
            return this.mType;
        }

        public static enum Type {
            SOLID,
            DOTTED;

        }
    }

    public static class GPVertex {
        protected Point2D loc = new Point2D.Double(0.0, 0.0);

        public String getLabel() {
            return null;
        }

        public Paint getPaint() {
            return null;
        }

        public Icon getIcon() {
            return null;
        }

        public Point2D getLoc() {
            return this.loc;
        }

        public void setLoc(Point2D loc) {
            this.loc.setLocation(loc);
        }
    }
}

