/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui.log;

import com.sigrity.acl.AFileExplorer;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.log.ALogElementRegistry;
import com.sigrity.acl.log.ALogHyperElement;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;

public class ALogHelper {
    private static boolean isRegistered = false;

    private ALogHelper() {
    }

    public static void register() {
        if (isRegistered) {
            return;
        }
        ALogElementRegistry.registerElementAction((ALogElementRegistry.AElementAction)new ALogElementRegistry.AElementAction(){

            public boolean actionPerformed(Element elem, Component comp, int x, int y) {
                AttributeSet set = (AttributeSet)elem.getAttributes().getAttribute(HTML.Tag.A);
                return set != null && this.openHyperLink((String)set.getAttribute(HTML.Attribute.HREF));
            }

            private boolean openHyperLink(String hrefPath) {
                if (hrefPath == null) {
                    return false;
                }
                if (hrefPath.startsWith(ALogHyperElement.HyperSource.FILE.getSource())) {
                    try {
                        File f = new File(new URI(hrefPath));
                        AFileExplorer.browseFileDirectory((File)f);
                        return true;
                    }
                    catch (URISyntaxException e) {
                        ALog.logError((Throwable)e, (String)"Cannot find the '%s'", (Object[])new Object[]{hrefPath});
                    }
                }
                return false;
            }
        });
        ALogElementRegistry.registerElementAction((ALogElementRegistry.AElementAction)new ALogElementRegistry.AElementAction(){

            public boolean actionPerformed(Element elem, Component comp, int x, int y) {
                AttributeSet set = (AttributeSet)elem.getAttributes().getAttribute(HTML.Tag.A);
                return set != null && this.openHyperLink((String)set.getAttribute(HTML.Attribute.HREF), comp);
            }

            private boolean openHyperLink(String hrefPath, Component comp) {
                if (hrefPath == null) {
                    return false;
                }
                if (hrefPath.startsWith(ALogHyperElement.HyperSource.TEXT_FIELD.getSource())) {
                    try {
                        URI uri = new URI(hrefPath);
                        String message = URLDecoder.decode(uri.getRawQuery(), "UTF-8");
                        Window w = UIUtil.getParentWindow((Component)comp);
                        AFloatWindow fw = w != null ? new AFloatWindow(w) : new AFloatWindow();
                        fw.setTitle("Log Message Entry");
                        fw.setSize(800, 600);
                        Container contents = fw.getContentPane();
                        contents.setLayout(new BorderLayout());
                        JTextArea textArea = new JTextArea(message);
                        textArea.setEditable(false);
                        textArea.setLineWrap(true);
                        textArea.setWrapStyleWord(true);
                        JScrollPane sp = new JScrollPane(textArea);
                        sp.setHorizontalScrollBarPolicy(30);
                        sp.setVerticalScrollBarPolicy(20);
                        contents.add((Component)sp, "Center");
                        fw.setVisible(true);
                        return true;
                    }
                    catch (UnsupportedEncodingException | URISyntaxException e) {
                        ALog.logError((Throwable)e, (String)"Cannot find the '%s'", (Object[])new Object[]{hrefPath});
                    }
                }
                return false;
            }
        });
        ALogElementRegistry.registerElementAction((ALogElementRegistry.AElementAction)new ALogElementRegistry.AElementAction(){

            public boolean actionPerformed(Element elem, Component comp, int x, int y) {
                AttributeSet set = (AttributeSet)elem.getAttributes().getAttribute(HTML.Tag.A);
                return set != null && this.openHyperLink((String)set.getAttribute(HTML.Attribute.HREF));
            }

            private boolean openHyperLink(String hrefPath) {
                if (hrefPath == null) {
                    return false;
                }
                if (hrefPath.startsWith(ALogHyperElement.HyperSource.CP.getSource())) {
                    try {
                        URI uri = new URI(hrefPath);
                        Cp.exec((String)URLDecoder.decode(uri.getRawQuery(), "UTF-8"), (Object[])new Object[0]);
                        return true;
                    }
                    catch (UnsupportedEncodingException | URISyntaxException e) {
                        ALog.logError((Throwable)e, (String)"Cannot find the '%s'", (Object[])new Object[]{hrefPath});
                    }
                }
                return false;
            }
        });
        isRegistered = true;
    }

    public static void logInvalidDevicePath(String path) {
        ALog.logError((String)"DevicePath '%s' does not exist", (Object[])new Object[]{path});
    }

    public static void logInvalidDesign() {
        ALog.logError((String)"There is no current design");
    }

    public static ALogHyperElement createSelectElement(final HierInst<DbObject> hi, final String text) {
        return new ALogHyperElement(){

            public String getText() {
                return text;
            }

            public String getHyperSource() {
                String cp = "";
                try {
                    if (hi.getDbObject().getDb() == null) {
                        return cp;
                    }
                    cp = URLEncoder.encode(String.format("curSelection().add(%s, %s);", CpHelper.getCmdStr(hi.getPath()), CpHelper.getObjCmdStr(hi.getDbObject())), "UTF-8");
                }
                catch (Exception e) {
                    ALog.logDebug((Throwable)e);
                    return "";
                }
                return ALogHyperElement.HyperSource.CP.getSource() + "?" + cp;
            }

            public String getHtmlText() {
                return String.format("<a href='%s'>%s</a>", this.getHyperSource(), AUtil.escapeHtml((String)this.getText()));
            }
        };
    }

    public static ALogHyperElement createTextElement(final String titleText, final String contentText) {
        return new ALogHyperElement(){

            public String getText() {
                return titleText;
            }

            public String getHyperSource() {
                String message = "";
                try {
                    message = URLEncoder.encode(contentText, "UTF-8");
                }
                catch (Exception e) {
                    ALog.logDebug((Throwable)e);
                    return "";
                }
                return ALogHyperElement.HyperSource.TEXT_FIELD.getSource() + "?" + message;
            }

            public String getHtmlText() {
                return String.format("<a href='%s'>%s</a>", this.getHyperSource(), AUtil.escapeHtml((String)this.getText()));
            }
        };
    }

    static {
        ALogHelper.register();
    }
}

