/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui.waitcursor;

import com.sigrity.acl.DelayTimer;
import com.sigrity.acl.ui.waitcursor.DispatchedEvent;
import java.util.Stack;

class CursorManager {
    protected final DelayTimer mTimer;
    protected final Stack<DispatchedEvent> mEventStack = new Stack();
    protected boolean mCleanupRequired;

    public CursorManager(DelayTimer waitTimer) {
        this.mTimer = waitTimer;
    }

    protected void cleanUp() {
        this.mEventStack.peek().resetCursor();
    }

    public void push(Object source) {
        if (this.mCleanupRequired) {
            this.mTimer.stopTimer();
            this.cleanUp();
        }
        this.mEventStack.push(new DispatchedEvent(source));
        this.mCleanupRequired = true;
    }

    public void pop() {
        this.cleanUp();
        this.mEventStack.pop();
        if (!this.mEventStack.isEmpty()) {
            this.mTimer.startTimer();
        } else {
            this.mCleanupRequired = false;
        }
    }

    public void setCursor() {
        if (this.mEventStack.size() == 0) {
            return;
        }
        this.mEventStack.peek().setCursor();
    }
}

