/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui.waitcursor;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Window;
import java.util.HashMap;

class DispatchedEvent {
    protected HashMap<Window, Cursor> mInstalledWaitCursors = new HashMap();

    public DispatchedEvent(Object source) {
    }

    public synchronized void setCursor() {
        Cursor cursor = Cursor.getPredefinedCursor(3);
        for (Frame frame : Frame.getFrames()) {
            this.mInstalledWaitCursors.put(frame, this.getSetCursor(frame));
            frame.setCursor(cursor);
            for (Window window : frame.getOwnedWindows()) {
                this.mInstalledWaitCursors.put(window, this.getSetCursor(window));
                window.setCursor(cursor);
            }
        }
    }

    public synchronized boolean resetCursor() {
        if (this.mInstalledWaitCursors.size() == 0) {
            return false;
        }
        for (Window w : this.mInstalledWaitCursors.keySet()) {
            w.setCursor(this.mInstalledWaitCursors.get(w));
        }
        this.mInstalledWaitCursors.clear();
        return true;
    }

    protected Cursor getSetCursor(Window w) {
        return w.isCursorSet() ? w.getCursor() : null;
    }
}

