/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.acl.ui.waitcursor;

import com.sigrity.acl.DelayTimer;
import com.sigrity.acl.ui.OrbitUIEventQueue;
import com.sigrity.acl.ui.waitcursor.CursorManager;
import java.awt.AWTEvent;

public class WaitCursorEventQueue
extends OrbitUIEventQueue
implements DelayTimer.Callback {
    protected final CursorManager mCursorManager;
    protected final DelayTimer mWaitTimer;

    public WaitCursorEventQueue(int delay) {
        this.mWaitTimer = new DelayTimer((DelayTimer.Callback)this, (long)delay, "WaitCursorTimer");
        this.mCursorManager = new CursorManager(this.mWaitTimer);
    }

    public void close() {
        this.mWaitTimer.quit();
        this.pop();
    }

    @Override
    protected void dispatchEvent(AWTEvent event) {
        this.mCursorManager.push(event.getSource());
        this.mWaitTimer.startTimer();
        try {
            super.dispatchEvent(event);
        }
        finally {
            this.mWaitTimer.stopTimer();
            this.mCursorManager.pop();
        }
    }

    @Override
    public AWTEvent getNextEvent() throws InterruptedException {
        this.mWaitTimer.stopTimer();
        return super.getNextEvent();
    }

    public void timerFired() {
        this.mCursorManager.setCursor();
    }
}

