/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.decorators;

import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.LayerListRenderer;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BumpDecoratorDlg
extends JDialog {
    JComboBox<Layer> bumpLayer;
    JTextField pitch;
    JTextField startDx;
    JTextField startDy;
    JCheckBox stagger;
    JTextField bumpDiameter;
    JTextField netName1;
    JTextField ratio1;
    JTextField netName2;
    JTextField ratio2;
    JTextField netName3;
    JTextField ratio3;
    JTextField netName4;
    JTextField ratio4;
    JTextField netName5;
    JTextField ratio5;
    DoDecorate callback;
    protected ActionListener mApply = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            BumpDecoratorDlg.this.callback.start();
            BumpDecoratorDlg.this.callback.setBumpLayer((Layer)BumpDecoratorDlg.this.bumpLayer.getSelectedItem());
            BumpDecoratorDlg.this.callback.setBumpDiameter(Double.parseDouble(BumpDecoratorDlg.this.bumpDiameter.getText()));
            BumpDecoratorDlg.this.callback.setMinPitch(Double.parseDouble(BumpDecoratorDlg.this.pitch.getText()));
            BumpDecoratorDlg.this.callback.setStartDx(Double.parseDouble(BumpDecoratorDlg.this.startDx.getText()));
            BumpDecoratorDlg.this.callback.setStartDy(Double.parseDouble(BumpDecoratorDlg.this.startDy.getText()));
            BumpDecoratorDlg.this.callback.setStagger(BumpDecoratorDlg.this.stagger.isSelected());
            if (!BumpDecoratorDlg.this.netName1.getText().isEmpty()) {
                BumpDecoratorDlg.this.callback.addRatio(BumpDecoratorDlg.this.netName1.getText(), Integer.parseInt(BumpDecoratorDlg.this.ratio1.getText()));
            }
            if (!BumpDecoratorDlg.this.netName2.getText().isEmpty()) {
                BumpDecoratorDlg.this.callback.addRatio(BumpDecoratorDlg.this.netName2.getText(), Integer.parseInt(BumpDecoratorDlg.this.ratio2.getText()));
            }
            if (!BumpDecoratorDlg.this.netName3.getText().isEmpty()) {
                BumpDecoratorDlg.this.callback.addRatio(BumpDecoratorDlg.this.netName3.getText(), Integer.parseInt(BumpDecoratorDlg.this.ratio3.getText()));
            }
            if (!BumpDecoratorDlg.this.netName4.getText().isEmpty()) {
                BumpDecoratorDlg.this.callback.addRatio(BumpDecoratorDlg.this.netName4.getText(), Integer.parseInt(BumpDecoratorDlg.this.ratio4.getText()));
            }
            if (!BumpDecoratorDlg.this.netName5.getText().isEmpty()) {
                BumpDecoratorDlg.this.callback.addRatio(BumpDecoratorDlg.this.netName5.getText(), Integer.parseInt(BumpDecoratorDlg.this.ratio5.getText()));
            }
            BumpDecoratorDlg.this.callback.decorateCallBack();
        }
    };

    public static BumpDecoratorDlg createDialog(Window owner, DevicePath context, DoDecorate callback) {
        BumpDecoratorDlg dlg = null;
        dlg = new BumpDecoratorDlg(owner);
        dlg.init(context, callback);
        return dlg;
    }

    public BumpDecoratorDlg(Window owner) {
        super(owner);
    }

    protected void init(DevicePath path, DoDecorate callback) {
        this.callback = callback;
        this.setTitle("Parameters for Bump Creation for " + path.toString());
        this.setModal(true);
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.pushFillX();
        l.add((Component)new JLabel("Bump Layer"));
        this.bumpLayer = new JComboBox();
        this.bumpLayer.setRenderer(new LayerListRenderer());
        l.add(this.bumpLayer);
        this.updateLayerCombo(path.pathToLowestDie().getSubstrate(), this.bumpLayer);
        l.add("Bump Diameter:");
        this.bumpDiameter = new JTextField("100.0", 10);
        l.add((Component)this.bumpDiameter, (GridBagConstraints)GridBagManager.FILLX);
        l.pop();
        l.newline();
        l.pushNoFill();
        l.add("Bump Pitch: ");
        this.pitch = new JTextField("200.0", 10);
        l.add((Component)this.pitch, (GridBagConstraints)GridBagManager.FILLX);
        l.popNl();
        l.pushFillX();
        l.add("Start dX:");
        this.startDx = new JTextField("50.0", 10);
        l.add((Component)this.startDx, (GridBagConstraints)GridBagManager.FILLX);
        l.add("Start dY:");
        this.startDy = new JTextField("50.0", 10);
        l.add((Component)this.startDy, (GridBagConstraints)GridBagManager.FILLX);
        l.popNl();
        l.pushFillX();
        this.stagger = new JCheckBox("Stagger");
        l.add((Component)this.stagger, (GridBagConstraints)GridBagManager.FILLX);
        l.popNl();
        l.pushFillX();
        l.add("Net");
        l.add("Ratio");
        l.newline();
        this.netName1 = new JTextField("VCC", 10);
        l.add((Component)this.netName1, (GridBagConstraints)GridBagManager.FILLX);
        this.ratio1 = new JTextField("3", 10);
        l.add((Component)this.ratio1, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        this.netName2 = new JTextField("VREF", 10);
        l.add((Component)this.netName2, (GridBagConstraints)GridBagManager.FILLX);
        this.ratio2 = new JTextField("16", 10);
        l.add((Component)this.ratio2, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        this.netName3 = new JTextField("VSS", 10);
        l.add((Component)this.netName3, (GridBagConstraints)GridBagManager.FILLX);
        this.ratio3 = new JTextField("2", 10);
        l.add((Component)this.ratio3, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        this.netName4 = new JTextField("VSSREF", 10);
        l.add((Component)this.netName4, (GridBagConstraints)GridBagManager.FILLX);
        this.ratio4 = new JTextField("48", 10);
        l.add((Component)this.ratio4, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        this.netName5 = new JTextField(10);
        l.add((Component)this.netName5, (GridBagConstraints)GridBagManager.FILLX);
        this.ratio5 = new JTextField(10);
        l.add((Component)this.ratio5, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.popNl();
        this.updateUI();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton btnApply = new JButton("Apply");
        l.add((Component)btnApply, (GridBagConstraints)GridBagManager.RIGHT);
        btnApply.addActionListener(this.mApply);
        JButton btnClose = new JButton("Close");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)this, (AbstractButton)btnClose, (JButton)btnApply);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)this);
    }

    protected void updateLayerCombo(Substrate s, JComboBox<Layer> box) {
        ArrayList<Layer> sortedLayers = new ArrayList<Layer>();
        for (Layer l : s.getLayers()) {
            sortedLayers.add(l);
        }
        Collections.sort(sortedLayers);
        Collections.reverse(sortedLayers);
        for (Layer l : sortedLayers) {
            box.addItem(l);
        }
    }

    protected void updateUI() {
    }

    public static interface DoDecorate {
        public void decorateCallBack();

        public void start();

        public void setBumpLayer(Layer var1);

        public void setBumpDiameter(double var1);

        public void setMinPitch(double var1);

        public void setStartDx(double var1);

        public void setStartDy(double var1);

        public void setStagger(boolean var1);

        public void addRatio(String var1, int var2);
    }
}

