/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.decorators;

import com.sigrity.acl.AGridUtil;
import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.AOctagon;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPinT;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.iov.IOViewBlock;
import com.sigrity.orbit.iov.IOViewDecorator;
import com.sigrity.orbit.ui.wb_route.RouterInterface;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class BumpFactoryDecorator
extends IOViewDecorator {
    long unitPerMicron = Design.getDefaultUnitDistDbuCount();
    long startDx = 0L;
    long startDy = 0L;
    long dx = 85L * this.unitPerMicron;
    long dy = 85L * this.unitPerMicron;
    long maxXDist = 2000L * this.unitPerMicron;
    long bumpDiameter = 64L * this.unitPerMicron;
    long bumpToIoPadDist = 10L * this.unitPerMicron;
    double scale = 1.0;
    boolean stagger = false;
    boolean oppositeStagger = false;
    int maxRows = 5;
    int extraRows = 0;
    String bumpLayerName = "AP";
    Unit unit;
    boolean createBumpDevices = false;
    String bumpTemplateName;
    int staggerRepeatSize = 0;
    boolean repeat = true;
    boolean bySequence = true;
    String delim = "@";
    boolean align = false;
    boolean adaptive = false;
    ArrayList<BumpColumnDesc> bumpColumnArray = new ArrayList();
    ArrayList<String> ignoreTemplateNames = new ArrayList();
    HashMap<Integer, Integer> ioPortIndexToRefernces = new HashMap();
    final Db db;
    ArrayList<HierPinT> ioPortList = new ArrayList();
    Device interfaceDevice;
    DevicePath dpBase;
    DeviceTemplate coverTemplate;
    Device coverCell;
    DeviceTemplate bumpTemplate;
    PadTemplate padTemplateForBump;
    ARect coverCellRect = new ARect(0L, 0L, 0L, 0L);
    private Substrate mSubstrate;

    public BumpFactoryDecorator() {
        this.db = OrbitIO.getCurDb();
        this.unit = Design.getUnit((Db)this.db);
    }

    public void addIgnoreTemplateName(String templateName) {
        this.ignoreTemplateNames.add(templateName);
    }

    public void setStagger(boolean stagger) {
        this.stagger = stagger;
    }

    public void setOppositeStagger(boolean oppositeStagger) {
        this.oppositeStagger = oppositeStagger;
    }

    public void setStaggerRepeat(int repeatSize) {
        this.staggerRepeatSize = repeatSize;
    }

    public void setBumpLayerName(String bumpLayerName) {
        this.bumpLayerName = bumpLayerName;
    }

    public void setDx(double dx) {
        this.dx = this.unit.fromUser(dx);
    }

    public void setDy(double dy) {
        this.dy = this.unit.fromUser(dy);
    }

    public void setStartDx(double dx) {
        this.startDx = this.unit.fromUser(dx);
    }

    public void setStartDy(double dy) {
        this.startDy = this.unit.fromUser(dy);
    }

    public void setBumpDiameter(double d) {
        this.bumpDiameter = this.unit.fromUser(d);
    }

    public void setMaxXDist(double d) {
        this.maxXDist = this.unit.fromUser(d);
    }

    public void setMaxRows(int rows) {
        this.maxRows = rows;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setNoRepeat() {
        this.repeat = false;
    }

    public void setAlign(boolean align) {
        this.align = align;
    }

    public void setAdaptive(boolean adaptive) {
        this.adaptive = adaptive;
    }

    public void setBySequence(boolean bySequence) {
        this.bySequence = bySequence;
        if (!bySequence) {
            this.repeat = false;
        }
    }

    public void setDelim(String delim) {
        this.delim = delim;
    }

    public void addPattern(String netPattern) {
        netPattern = netPattern.replaceAll(" ", "");
        String[] p = netPattern.split(",", 0);
        BumpColumnDesc bc = new BumpColumnDesc();
        bc.patterns = p;
        bc.dx = this.dx;
        bc.dy = this.dy;
        this.bumpColumnArray.add(bc);
    }

    public void createBumpDevices(boolean mode) {
        this.createBumpDevices = mode;
    }

    public void setBumpTemplate(String bumpTemplateName) {
        this.bumpTemplateName = bumpTemplateName;
    }

    protected ARect getIOPadRect(PinInstance ioPin, DevicePath path) {
        AffineTransform t = path.getTransform();
        PinTemplate ioPinTemplate = ioPin.getPinTemplate();
        ARect bounds = null;
        for (PortTemplate portTmplt : ioPinTemplate.getPortTemplates()) {
            ARect r;
            PadTemplate pt;
            AffineTransform xform = portTmplt.getTransform();
            if (xform != null) {
                xform.preConcatenate(t);
            } else {
                xform = t;
            }
            if ((pt = portTmplt.getPadTemplate()) == null || (r = pt.getBounds(null)) == null) continue;
            r = r.transform(xform).getBounds();
            if (bounds == null) {
                bounds = r;
                continue;
            }
            bounds.expand(r);
        }
        return bounds;
    }

    protected void doByReference() {
        long startY = this.startDy;
        long curX = this.startDx;
        long curY = startY;
        if (this.oppositeStagger) {
            curY += this.bumpColumnArray.get((int)0).dy / 2L;
        }
        int curCol = 0;
        int ith = 0;
        for (BumpColumnDesc bcd : this.bumpColumnArray) {
            for (String p : bcd.patterns) {
                String bumpName = "Bump" + ith++;
                if (p.startsWith(this.delim)) {
                    int otherDelim = p.indexOf(this.delim, 1);
                    if (otherDelim > 1) {
                        String devName = p.substring(1, otherDelim);
                        String portName = p.substring(otherDelim + 1);
                        Device d = this.interfaceDevice.getTemplate().getChild(devName);
                        if (d != null) {
                            PinInstance pi = d.getPinByName(portName);
                            if (pi != null) {
                                HierPinT ioPort = new HierPinT(d.getADevicePath(), pi);
                                Net dieNet = ioPort.getSubstrateNet();
                                String bumpNetName = dieNet.isUnused() ? BumpFactoryDecorator.makeANetNameFromIOPort(ioPort) : dieNet.getName();
                                if (ioPort.getNet().isUnused()) {
                                    Net ioPortNet = Net.create((DeviceTemplate)ioPort.getPath().getDeviceTemplate(), (String)(ioPort.getPath().getLast().getName() + ":" + ioPort.getPin().getName()));
                                    ioPort.getPin().setNet(ioPortNet);
                                }
                                this.addBumpAt(ioPort, curX, curY, bumpName, bumpNetName);
                            } else {
                                ALog.logWarn((String)("Can not find a pin called " + portName + " on device " + devName));
                            }
                        } else {
                            ALog.logWarn((String)("Can not find device " + devName + "on interface " + this.interfaceDevice.getName()));
                        }
                    } else {
                        ALog.logWarn((String)("Irregular formed device/pin reference " + p));
                    }
                } else {
                    this.addBumpAt(null, curX, curY, bumpName, p);
                }
                curY += this.bumpColumnArray.get((int)curCol).dy;
            }
            if (++curCol >= this.bumpColumnArray.size()) break;
            curX += this.bumpColumnArray.get((int)curCol).dx;
            curY = startY;
            if (this.staggerRepeatSize > 0) {
                int colInSequence = curCol % this.staggerRepeatSize;
                if (this.stagger && colInSequence % 2 == 1) {
                    curY += this.bumpColumnArray.get((int)curCol).dy / 2L;
                    continue;
                }
                if (!this.oppositeStagger || colInSequence % 2 == 1) continue;
                curY += this.bumpColumnArray.get((int)curCol).dy / 2L;
                continue;
            }
            if (this.stagger && curCol % 2 == 1) {
                curY += this.bumpColumnArray.get((int)curCol).dy / 2L;
                continue;
            }
            if (!this.oppositeStagger || curCol % 2 == 1) continue;
            curY += this.bumpColumnArray.get((int)curCol).dy / 2L;
        }
    }

    @Override
    public void decorate() {
        if (this.input.size() == 0) {
            return;
        }
        if (this.scale != 1.0) {
            ALog.logInfo((String)("All dimensions will be scaled by " + this.scale));
            this.startDx = (long)((double)this.startDx * this.scale);
            ALog.logInfo((String)("startDx " + this.startDx));
            this.startDy = (long)((double)this.startDy * this.scale);
            ALog.logInfo((String)("startDy " + this.startDy));
            this.dx = (long)((double)this.dx * this.scale);
            ALog.logInfo((String)("dx " + this.dx));
            this.dy = (long)((double)this.dy * this.scale);
            ALog.logInfo((String)("dy " + this.dy));
            this.bumpDiameter = (long)((double)this.bumpDiameter * this.scale);
            ALog.logInfo((String)("Bump Diameter " + this.bumpDiameter));
        }
        for (IOViewBlock iovb : this.input) {
            Device thisPinDevice = iovb.getDevicePath().getLast();
            DeviceTemplate dt = thisPinDevice.getTemplate();
            if (this.ignoreTemplateNames.contains(dt.getName())) {
                ALog.logInfo((String)("Ignoring " + iovb.getDevicePath().toString()));
            } else {
                List ioPorts = dt.getIOPorts();
                for (PinTemplate thisPinTemplate : dt.getPins()) {
                    if (!ioPorts.contains(thisPinTemplate)) continue;
                    this.ioPortList.add(new HierPinT(iovb.getDevicePath(), thisPinTemplate));
                }
            }
            this.copyToOutput(iovb);
        }
        this.deriveEnvironment();
        if (this.adaptive) {
            this.doAdaptive();
        } else {
            if (this.bumpColumnArray.size() == 0) {
                return;
            }
            if (!this.bySequence) {
                this.doByReference();
            } else {
                this.doBySequence();
            }
            this.coverTemplate.setBounds((AGeom)this.coverCellRect);
            this.addToOutput(this.coverCell, this.coverCell.getName(), this.coverCell.getTemplate().getName(), 0L, 0L);
        }
    }

    protected void doAdaptive() {
        this.coverCellRect = new ARect(this.interfaceDevice.getTemplate().getBB());
        this.coverTemplate.setBounds((AGeom)this.coverCellRect);
    }

    protected void deriveEnvironment() {
        long snapDyStart;
        long snapDxStart;
        this.interfaceDevice = ((IOViewBlock)this.input.get(0)).getParent().getDevicePath().getLast();
        this.mSubstrate = this.interfaceDevice.getSubstrate();
        this.dpBase = ((IOViewBlock)this.input.get(0)).getParent().getDevicePath().getParent();
        NamedGrid ng = NamedGrid.get((Substrate)this.mSubstrate, (String)"Manufacturing Grid");
        AGrid grid = null;
        grid = ng != null ? ng.getGrid() : new AGrid(5L, 5L, 0L, 0L);
        long doubledGridX = grid.getDeltaX() * 2L;
        long doubledGridY = grid.getDeltaY() * 2L;
        long snapDx = AGridUtil.snap((long)this.dx, (long)0L, (long)doubledGridX);
        if (snapDx != this.dx) {
            ALog.logWarn((String)("Snapping bump dx to " + this.unit.toUser(snapDx)));
            this.dx = snapDx;
        }
        if ((snapDxStart = AGridUtil.snap((long)this.startDx, (long)0L, (long)doubledGridX)) != this.startDx) {
            ALog.logWarn((String)("Snapping bump startDx to " + this.unit.toUser(snapDxStart)));
            this.startDx = snapDxStart;
        }
        long snapDy = AGridUtil.snap((long)this.dy, (long)0L, (long)doubledGridY);
        if (snapDx != this.dx) {
            ALog.logWarn((String)("Snapping bump dy to " + this.unit.toUser(snapDy)));
            this.dy = snapDy;
        }
        if ((snapDyStart = AGridUtil.snap((long)this.startDy, (long)0L, (long)doubledGridY)) != this.startDy) {
            ALog.logWarn((String)("Snapping bump startDy to " + this.unit.toUser(snapDyStart)));
            this.startDy = snapDyStart;
        }
        for (BumpColumnDesc bcd : this.bumpColumnArray) {
            long snapdy;
            long snapdx;
            bcd.dx = snapdx = AGridUtil.snap((long)bcd.dx, (long)0L, (long)doubledGridX);
            bcd.dy = snapdy = AGridUtil.snap((long)bcd.dy, (long)0L, (long)doubledGridY);
        }
        String deviceName = "CoverFor" + this.interfaceDevice.getName();
        this.coverTemplate = DeviceTemplate.create((Substrate)this.mSubstrate, (String)deviceName, (boolean)true);
        this.coverTemplate.setType(DeviceTemplate.Type.COVER);
        this.coverTemplate.setBounds((AGeom)new ARect(0L, 0L, 1L, 1L));
        this.coverCell = Device.create((Db)this.db, (String)deviceName, (DeviceTemplate)this.coverTemplate, (DeviceTemplate)((IOViewBlock)this.input.get(0)).getDevicePath().getParent().getDeviceTemplate());
        this.coverCell.setLoc(new APoint2D(0L, 0L));
        this.coverCell.setSynthesized(true);
        this.coverTemplate.setIsSynthesized(true);
        this.bumpTemplate = null;
        if (this.bumpTemplateName != null && !this.bumpTemplateName.isEmpty()) {
            this.bumpTemplate = DeviceTemplate.getDeviceTemplate((Substrate)this.mSubstrate, (String)this.bumpTemplateName);
            if (this.bumpTemplate == null) {
                String errorMsg = String.format("Design should have device template %s for bump!", this.bumpTemplateName);
                throw new IllegalArgumentException(errorMsg);
            }
        } else {
            if (this.createBumpDevices) {
                this.bumpTemplate = DeviceTemplate.create((Substrate)this.mSubstrate, (String)"BUMP", (boolean)true);
                this.bumpTemplate.setSubstrate(this.mSubstrate);
                this.bumpTemplate.setType(DeviceTemplate.Type.BUMP);
                this.bumpTemplate.setBounds((AGeom)new AOctagon(this.bumpDiameter / 2L, grid));
            }
            this.padTemplateForBump = PadTemplate.create((Db)this.db, (Substrate)this.mSubstrate, (String)"CoverBump");
            Layer bumpLayer = Layer.get((Db)this.db, (Substrate)this.mSubstrate, (String)this.bumpLayerName);
            if (bumpLayer == null) {
                ALog.logWarn((String)("Layer " + this.bumpLayerName + " does not exist on the substrate of " + this.dpBase));
                return;
            }
            AOctagon padShape = new AOctagon(this.bumpDiameter / 2L, grid);
            LayerShape.create((Db)OrbitIO.getCurDb(), (Layer)bumpLayer, (DbObject)this.padTemplateForBump, (AGeom)padShape);
        }
    }

    protected void addBumpAt(HierPinT ioPort, long x, long y, String bumpName, String bumpNetName) {
        PinTemplate pt;
        Net netOnBumpPin;
        if (this.createBumpDevices) {
            netOnBumpPin = this.bumpTemplate.getNet("BumpNet");
            if (netOnBumpPin == null) {
                netOnBumpPin = Net.create((DeviceTemplate)this.bumpTemplate, (String)"BumpNet");
            }
            pt = PinTemplate.create((Net)netOnBumpPin, (String)bumpName);
        } else {
            netOnBumpPin = this.coverTemplate.getNet(bumpName);
            if (netOnBumpPin == null) {
                netOnBumpPin = Net.create((DeviceTemplate)this.coverTemplate, (String)bumpName);
            }
            pt = PinTemplate.create((Net)netOnBumpPin, (String)bumpName);
        }
        pt.setPadTemplate(this.padTemplateForBump);
        pt.setType(PinTemplate.Type.BUMPPAD);
        if (this.createBumpDevices) {
            Device thisBumpDevice = Device.create((Db)this.db, (String)bumpName, (DeviceTemplate)this.bumpTemplate, (DeviceTemplate)this.coverTemplate);
            DevicePath bumpPath = new DevicePath(this.dpBase);
            bumpPath.add(this.interfaceDevice);
            bumpPath.add(this.coverCell);
            bumpPath.add(thisBumpDevice);
            thisBumpDevice.setLoc(new APoint2D(x, y));
            pt.setLoc(new APoint2D(0L, 0L));
            PinInstance.create((Db)this.db, (String)bumpName, (Device)thisBumpDevice, (PinTemplate)pt);
            if (bumpNetName != null) {
                NetMap.mapThroughPath((DevicePath)bumpPath, (Net)netOnBumpPin, (String)bumpNetName);
            }
            this.coverCellRect.expand(thisBumpDevice.getLocalBB());
        } else {
            DevicePath bumpPath = new DevicePath(this.dpBase);
            bumpPath.add(this.interfaceDevice);
            bumpPath.add(this.coverCell);
            pt.setLoc(new APoint2D(x, y));
            PinInstance.create((Db)this.db, (String)bumpName, (Device)this.coverCell, (PinTemplate)pt);
            if (bumpNetName != null) {
                NetMap.mapThroughPath((DevicePath)bumpPath, (Net)netOnBumpPin, (String)bumpNetName);
            }
            this.coverCellRect.expand(pt.getBounds());
        }
        if (ioPort != null && bumpNetName != null) {
            NetMap.mapThroughPath((DevicePath)ioPort.getPath(), (Net)ioPort.getNet(), (String)bumpNetName);
        }
    }

    protected void doBySequence() {
        ALog.logInfo((String)("There are " + this.ioPortList.size() + " pins that will potentially be connected to bumps"));
        Collections.sort(this.ioPortList, new HorizontalIOPadSorter());
        Integer i = 0;
        while (i < this.ioPortList.size()) {
            this.ioPortIndexToRefernces.put(i, 0);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        int ith = 0;
        long startY = this.startDy;
        long curX = this.startDx;
        long curY = startY;
        if (this.oppositeStagger) {
            curY += this.bumpColumnArray.get((int)0).dy / 2L;
        }
        int curCol = 0;
        int patternColumnIndex = 0;
        int patternRowIndex = 0;
        boolean morePorts = true;
        int lastIOPadIndex = 0;
        HierPinT ioPort = this.ioPortList.get(0);
        int thisIOPadIndex = 0;
        int processedPads = 0;
        while (morePorts) {
            BumpColumnDesc currentBumpColumnDesc = this.bumpColumnArray.get(patternColumnIndex);
            String netAtThisIndex = currentBumpColumnDesc.patterns[patternRowIndex];
            String bumpNetName = null;
            Integer ioPadIndex = null;
            try {
                ioPadIndex = Integer.parseInt(netAtThisIndex) - 1;
            }
            catch (NumberFormatException err) {
                ioPadIndex = null;
            }
            if (ioPadIndex != null) {
                thisIOPadIndex = ioPadIndex + lastIOPadIndex;
                if (thisIOPadIndex < this.ioPortList.size()) {
                    this.ioPortIndexToRefernces.put(thisIOPadIndex, this.ioPortIndexToRefernces.get(thisIOPadIndex) + 1);
                    ++processedPads;
                    ioPort = this.ioPortList.get(thisIOPadIndex);
                    Net dieNet = ioPort.getSubstrateNet();
                    bumpNetName = dieNet.isUnused() ? BumpFactoryDecorator.makeANetNameFromIOPort(ioPort) : dieNet.getName();
                    if (ioPort.getNet().isUnused()) {
                        Net ioPortNet = Net.create((DeviceTemplate)ioPort.getPath().getDeviceTemplate(), (String)(ioPort.getPath().getLast().getName() + ":" + ioPort.getPin().getName()));
                        ioPort.getPin().setNet(ioPortNet);
                    }
                }
            } else {
                bumpNetName = netAtThisIndex;
                ioPort = null;
            }
            String bumpName = "Bump" + ith;
            this.addBumpAt(ioPort, curX, curY, bumpName, bumpNetName);
            if (ioPadIndex != null && bumpNetName != null) {
                ALog.logInfo((String)("setting " + ioPort.getPath().toString() + " to " + bumpNetName));
                NetMap.mapThroughPath((DevicePath)ioPort.getPath(), (Net)ioPort.getNet(), (String)bumpNetName);
            }
            if (++patternRowIndex >= currentBumpColumnDesc.patterns.length) {
                ++patternColumnIndex;
                if (processedPads >= this.ioPortList.size() - 1) {
                    morePorts = false;
                }
                if (patternColumnIndex >= this.bumpColumnArray.size()) {
                    if (!this.repeat) {
                        morePorts = false;
                    }
                    patternColumnIndex = 0;
                    lastIOPadIndex = processedPads;
                }
                patternRowIndex = 0;
                ++curCol;
                curX += this.bumpColumnArray.get((int)patternColumnIndex).dx;
                curY = startY;
                if (this.staggerRepeatSize > 0) {
                    int colInSequence = curCol % this.staggerRepeatSize;
                    if (this.stagger && colInSequence % 2 == 1) {
                        curY += this.bumpColumnArray.get((int)patternColumnIndex).dy / 2L;
                    } else if (this.oppositeStagger && colInSequence % 2 != 1) {
                        curY += this.bumpColumnArray.get((int)patternColumnIndex).dy / 2L;
                    }
                } else if (this.stagger && curCol % 2 == 1) {
                    curY += this.bumpColumnArray.get((int)patternColumnIndex).dy / 2L;
                } else if (this.oppositeStagger && curCol % 2 != 1) {
                    curY += this.bumpColumnArray.get((int)patternColumnIndex).dy / 2L;
                }
            } else {
                curY += this.bumpColumnArray.get((int)patternColumnIndex).dy;
            }
            ++ith;
        }
        Integer i2 = 0;
        while (i2 < this.ioPortList.size()) {
            int referenced = this.ioPortIndexToRefernces.get(i2);
            if (referenced == 0) {
                ALog.logInfo((String)("Pad " + this.ioPortList.get(i2).toString() + " is never referenced in decorator"));
            }
            if (referenced > 1) {
                ALog.logInfo((String)("Pad " + this.ioPortList.get(i2).toString() + " is referenced " + referenced + " times"));
            }
            Integer n = i2;
            Integer n3 = i2 = Integer.valueOf(i2 + 1);
        }
        ALog.logInfo((String)(ith + " bumps generated"));
    }

    static String makeANetNameFromIOPort(HierPinT ioPort) {
        String netName = ioPort.getPath().getParent().getLast().getName() + "_" + ioPort.getPath().getLast().getName() + "_" + ioPort.getPin().getName();
        return netName;
    }

    public static class HorizontalIOPadSorter
    implements Comparator<HierPinT> {
        RouterInterface.SortType mT;
        ARect mDieRect = null;

        @Override
        public int compare(HierPinT io0, HierPinT io1) {
            HierPinT p0 = new HierPinT(new DevicePath(io0.getPath().getLast()), io0.getPin());
            HierPinT p1 = new HierPinT(new DevicePath(io1.getPath().getLast()), io1.getPin());
            return Long.compare(p0.getWorldLoc().getX(), p1.getWorldLoc().getX());
        }
    }

    class BumpColumnDesc {
        long dx;
        long dy;
        String[] patterns;

        BumpColumnDesc() {
        }
    }
}

