/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.decorators;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.decorators.BumpFactoryDecorator;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.iov.IOView;
import com.sigrity.orbit.iov.IOViewBlock;
import com.sigrity.orbit.ui.PersonalityUI;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class BumpPatternDecorator
extends BumpFactoryDecorator {
    boolean byBumpPattern = true;
    private Map<String, Color> mNet2Color = new HashMap<String, Color>();
    private Map<String, Personality> mNet2Personality = new HashMap<String, Personality>();

    void doByBumpPattern() {
        int ith = 0;
        long startY = this.startDy;
        long curX = this.startDx;
        long curY = startY;
        if (this.oppositeStagger) {
            curY += ((BumpFactoryDecorator.BumpColumnDesc)this.bumpColumnArray.get((int)0)).dy / 2L;
        }
        int curCol = 0;
        int patternColumnIndex = 0;
        int patternRowIndex = 0;
        boolean moreBumps = true;
        while (moreBumps) {
            BumpFactoryDecorator.BumpColumnDesc currentBumpColumnDesc = (BumpFactoryDecorator.BumpColumnDesc)this.bumpColumnArray.get(patternColumnIndex);
            String netAtThisIndex = currentBumpColumnDesc.patterns[patternRowIndex];
            if (netAtThisIndex != null && !netAtThisIndex.isEmpty()) {
                String bumpNetName = netAtThisIndex;
                String bumpName = "Bump" + ith;
                String bumpPinName = "PAD";
                this.addBumpAt(curX, curY, bumpName, bumpPinName, bumpNetName);
            } else {
                ALog.logWarn((String)"SKIP BUMP");
            }
            if (++patternRowIndex >= currentBumpColumnDesc.patterns.length) {
                if (++patternColumnIndex >= this.bumpColumnArray.size()) {
                    moreBumps = false;
                    break;
                }
                patternRowIndex = 0;
                curX += ((BumpFactoryDecorator.BumpColumnDesc)this.bumpColumnArray.get((int)patternColumnIndex)).dx;
                curY = startY;
                if (this.stagger && ++curCol % 2 == 1) {
                    curY += ((BumpFactoryDecorator.BumpColumnDesc)this.bumpColumnArray.get((int)patternColumnIndex)).dy / 2L;
                } else if (this.oppositeStagger && curCol % 2 != 1) {
                    curY += ((BumpFactoryDecorator.BumpColumnDesc)this.bumpColumnArray.get((int)patternColumnIndex)).dy / 2L;
                }
            } else {
                curY += ((BumpFactoryDecorator.BumpColumnDesc)this.bumpColumnArray.get((int)patternColumnIndex)).dy;
            }
            ++ith;
        }
        ALog.logInfo((String)(ith + " bumps generated"));
    }

    @Override
    public void decorate() {
        if (this.input.size() == 0) {
            return;
        }
        if (this.scale != 1.0) {
            ALog.logInfo((String)("All dimensions will be scaled by " + this.scale));
            this.startDx = (long)((double)this.startDx * this.scale);
            ALog.logInfo((String)("startDx " + this.startDx));
            this.startDy = (long)((double)this.startDy * this.scale);
            ALog.logInfo((String)("startDy " + this.startDy));
            this.dx = (long)((double)this.dx * this.scale);
            ALog.logInfo((String)("dx " + this.dx));
            this.dy = (long)((double)this.dy * this.scale);
            ALog.logInfo((String)("dy " + this.dy));
            this.bumpDiameter = (long)((double)this.bumpDiameter * this.scale);
            ALog.logInfo((String)("Bump Diameter " + this.bumpDiameter));
        }
        for (IOViewBlock iovb : this.input) {
            Device thisPinDevice = iovb.getDevicePath().getLast();
            DeviceTemplate dt = thisPinDevice.getTemplate();
            if (this.ignoreTemplateNames.contains(dt.getName())) {
                ALog.logInfo((String)("Ignoring " + iovb.getDevicePath().toString()));
            }
            this.copyToOutput(iovb);
        }
        this.deriveEnvironment();
        this.addPersonalities(this.interfaceDevice.getTemplate());
        if (this.bumpColumnArray.size() == 0) {
            return;
        }
        if (this.byBumpPattern) {
            this.doByBumpPattern();
        } else {
            ALog.logError((String)"Only Support ByBmupPattern!");
        }
        this.coverTemplate.setBounds((AGeom)this.coverCellRect);
        this.addToOutput(this.coverCell, this.coverCell.getName(), this.coverCell.getTemplate().getName(), 0L, 0L);
    }

    protected void addBumpAt(long x, long y, String bumpName, String bumpPinName, String bumpNetName) {
        PinTemplate pt = this.bumpTemplate.getPinByName(bumpPinName);
        if (pt == null) {
            pt = this.bumpTemplate.getPins().stream().filter(p -> p.getType() == PinTemplate.Type.BUMPPAD).findAny().orElse(null);
        }
        if (pt == null) {
            ALog.logError((String)"For location (%d,%d), could not find pin:%s for bump!", (Object[])new Object[]{x, y, bumpPinName});
            return;
        }
        Net netOnBumpPin = pt.getNet();
        if (netOnBumpPin == null || netOnBumpPin.isUnused()) {
            netOnBumpPin = this.bumpTemplate.getNet(bumpPinName);
            if (netOnBumpPin == null) {
                netOnBumpPin = Net.create((DeviceTemplate)this.bumpTemplate, (String)bumpPinName);
            }
            pt.setNet(netOnBumpPin);
        }
        Device thisBumpDevice = Device.create((Db)this.db, (String)bumpName, (DeviceTemplate)this.bumpTemplate, (DeviceTemplate)this.coverTemplate);
        DevicePath bumpPath = new DevicePath(this.dpBase);
        bumpPath.add(this.interfaceDevice);
        bumpPath.add(this.coverCell);
        bumpPath.add(thisBumpDevice);
        Personality pers = this.getPersonality(bumpNetName);
        if (pers != null) {
            PinInstance pin = thisBumpDevice.getAnyPin();
            DevicePath relPath = bumpPath.getRelativePathFromAnchor(pers.getOwner());
            pers.apply(relPath, (DbObject)pin);
        }
        thisBumpDevice.setLoc(new APoint2D(x, y));
        NetMap.mapThroughPath((DevicePath)bumpPath, (Net)netOnBumpPin, (String)bumpNetName);
        this.coverCellRect.expand(thisBumpDevice.getLocalBB());
    }

    private Personality getPersonality(String netName) {
        Personality p = this.mNet2Personality.get(netName);
        if (p == null) {
            p = this.mNet2Personality.entrySet().stream().filter(e -> {
                String netPrefix = (String)e.getKey();
                return netName.startsWith(netPrefix);
            }).map(e -> (Personality)e.getValue()).findAny().orElse(null);
        }
        return p;
    }

    public void addColorPatternByPersonality(String netPrefix, int r, int g, int b) {
        Color color = new Color(r, g, b);
        this.mNet2Color.put(netPrefix, color);
    }

    private void addPersonalities(DeviceTemplate t) {
        if (t == null) {
            ALog.logWarn((String)"Can not add personalities to null template!");
            return;
        }
        this.mNet2Color.entrySet().forEach(e -> {
            Personality p;
            String netPrefix = (String)e.getKey();
            Color color = (Color)e.getValue();
            String name = IOView.getPersonalityNameForNet(netPrefix);
            Optional optP = Personality.getPersonality((DeviceTemplate)t, (Personality.Type)Personality.Type.PORT, (String)name);
            Personality personality = p = optP.isPresent() ? (Personality)optP.get() : PersonalityUI.addPersonalityByDevTemp(name, Personality.Type.PORT, t.getKeyStr(), AUtil.colorToString((Color)color));
            if (p != null) {
                this.mNet2Personality.put(netPrefix, p);
            }
        });
    }
}

