/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.decorators;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.JedecAlphabet;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.UserCommands;
import com.sigrity.orbit.colView.ColData;
import com.sigrity.orbit.colView.ColView;
import com.sigrity.orbit.colView.ColViewDecorator;
import com.sigrity.orbit.colView.ColViewDecoratorRegistry;
import com.sigrity.orbit.iov.IOView;
import com.sigrity.orbit.iov.IOViewDieDecorator;
import com.sigrity.orbit.iov.IOViewDieDecoratorRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class DieDecorator {
    private static boolean isNonFixedCoverDevice(Device coverDevice) {
        return !coverDevice.getIsFixed() && coverDevice.isTypeOf(DeviceTemplate.Type.COVER);
    }

    private static List<HierPort> getSortedChildBumpPins(Device coverDevice) {
        LinkedList<HierPort> sortedPins = new LinkedList<HierPort>();
        for (Device child : coverDevice.getChildren()) {
            for (PinTemplate pt : child.getTemplate().getPins()) {
                if (!pt.isTypeOf(PinTemplate.Type.BUMPPAD) && !child.isTypeOf(DeviceTemplate.Type.BUMP)) continue;
                DevicePath dp = new DevicePath(coverDevice);
                dp.add(child);
                sortedPins.add(new HierPort(dp, pt.getFirstPortTemplate()));
            }
        }
        Collections.sort(sortedPins, new UserCommands.DPSorter());
        return sortedPins;
    }

    private static Net netmapChildToParent(DeviceTemplate parentTemplate, String parentNetName, Device childDevice, Net childNet) {
        Net parentNet = Net.getOrCreate((DeviceTemplate)parentTemplate, (String)parentNetName);
        NetMap.mapChildNet((Device)childDevice, (Net)childNet, (Net)parentNet);
        return parentNet;
    }

    public static void registerSpecialNetlistCommand() {
        ColViewDecoratorRegistry.add(new RemakeAllNets());
        ColViewDecoratorRegistry.add(new MakeDieNets());
        IOViewDieDecoratorRegistry.add(new IOViewMakeDieNets());
        IOViewDieDecoratorRegistry.add(new MakeNetsOnCoverCells());
    }

    public static class IOViewMakeDieNets
    implements IOViewDieDecorator {
        LinkedList<Device> listOfCoverCells = new LinkedList();
        Device dieDevice;

        @Override
        public boolean decorate() {
            this.dieDevice = IOView.theIOView.getRootDevicePath().getLast();
            this.createDeviceNames(this.dieDevice);
            this.createNetsOnBumps(this.dieDevice);
            return true;
        }

        @Override
        public String toolTip() {
            return "<html>Promote cell nets to the die, makeing them unique. <br>No nets on the cell will be changed</html>";
        }

        @Override
        public String name() {
            return "Make Die Nets";
        }

        protected void calcSpecialNames(LinkedList<DevicePath> pathList) {
            int i = 0;
            for (DevicePath dp : pathList) {
                String name = "@" + i;
                Device d = dp.getLast();
                Personality p = d.getPersonality();
                if (p != null) {
                    p.setName(name);
                    dp.getParent().getLast().setName(name);
                }
                d.setName(name);
                ++i;
            }
            for (int o = 0; o < 8; ++o) {
                int o_ = o;
                List thisOct = pathList.stream().filter(path -> this.getOctant((DevicePath)path) == o_).sorted(new OSorter(o_)).collect(Collectors.toList());
                i = 0;
                for (DevicePath dp : thisOct) {
                    Device d = dp.getLast();
                    int alternateO = IOViewMakeDieNets.toAlternateOctant(o);
                    String name = Integer.toString(alternateO) + JedecAlphabet.getNth((int)i);
                    Personality p = d.getPersonality();
                    if (p != null) {
                        p.setName(name);
                        dp.getParent().getLast().setName(name);
                    }
                    d.setName(name);
                    ++i;
                }
            }
        }

        protected static int toAlternateOctant(int o) {
            int alternateO = o - 2;
            if (alternateO < 0) {
                alternateO += 8;
            }
            if (alternateO == 0) {
                alternateO = 8;
            }
            return alternateO;
        }

        protected void createDeviceNames(Device die) {
            LinkedList<DevicePath> results = new LinkedList<DevicePath>();
            for (DevicePath coverDevicePath : IOView.getDevicesInSequence()) {
                Device coverDevice = coverDevicePath.getLast();
                if (!DieDecorator.isNonFixedCoverDevice(coverDevice)) continue;
                results.add(coverDevicePath);
            }
            this.calcSpecialNames(results);
        }

        protected APoint2D getDeviceLocationOnEdge(DevicePath path) {
            DevicePath pathBelowSubstrate = new DevicePath(path);
            pathBelowSubstrate.removeFirst();
            ARect die = this.dieDevice.getTemplate().getBB();
            ARect device = pathBelowSubstrate.getBB();
            long topD = device.topEdge().distance(die.topEdge());
            long botD = device.bottomEdge().distance(die.bottomEdge());
            long leftD = device.leftEdge().distance(die.leftEdge());
            long rightD = device.rightEdge().distance(die.rightEdge());
            if (topD < botD && topD < leftD && topD < rightD) {
                return device.topEdge().center();
            }
            if (botD < topD && botD < leftD && botD < rightD) {
                return device.bottomEdge().center();
            }
            if (leftD < topD && leftD < botD && leftD < rightD) {
                return device.leftEdge().center();
            }
            return device.rightEdge().center();
        }

        int getOctant(DevicePath d) {
            ALine v = new ALine(this.dieDevice.getTemplate().getBB().center(), this.getDeviceLocationOnEdge(d));
            int octant = AGeomUtil.getOctant((ALine)v);
            return octant;
        }

        public void createNetsOnBumps(Device dieDevice) {
            DeviceTemplate dieTemplate = dieDevice.getTemplate();
            Net.deleteImmaterialNets((Db)dieTemplate.getDb(), (boolean)false);
            int seqNum = 0;
            for (DevicePath coverDevicePath : IOView.getDevicesInSequence()) {
                Device coverDevice = coverDevicePath.getLast();
                if (!DieDecorator.isNonFixedCoverDevice(coverDevice)) continue;
                this.listOfCoverCells.add(coverDevice);
                LinkedList<SeqPin> sortedPins = new LinkedList<SeqPin>();
                for (Device child : coverDevice.getChildren()) {
                    for (PinTemplate pt : child.getTemplate().getPins()) {
                        if (!pt.isTypeOf(PinTemplate.Type.BUMPPAD) && !child.isTypeOf(DeviceTemplate.Type.BUMP)) continue;
                        DevicePath dp = coverDevicePath.withChild(child);
                        sortedPins.add(new SeqPin(new HierPort(dp, pt.getFirstPortTemplate()), seqNum));
                    }
                }
                for (SeqPin sp : sortedPins) {
                    PinInstance pi;
                    Personality personality;
                    HierPort hp = sp.hp;
                    Device bumpDevice = ((DevicePath)hp.first).getLast();
                    PinTemplate pt = ((PortTemplate)hp.second).getPinTemplate();
                    Net bumpNet = ((PortTemplate)hp.second).getPinTemplate().getNet();
                    if (Net.isNullOrUnusedNet((Net)bumpNet) || (personality = (pi = PinInstance.getPinInstance((Device)bumpDevice, (PinTemplate)pt)).getPersonality()) == null) continue;
                    String netName = personality.getName();
                    Net coverNet = NetMap.getParentNet((Device)bumpDevice, (Net)bumpNet);
                    if (Net.isNullOrUnusedNet((Net)coverNet)) continue;
                    if (personality.getName().equalsIgnoreCase("signal")) {
                        DevicePath interfaceDevicePath = hp.getPath().getParent().getParent();
                        DevicePath dieDevicePath = interfaceDevicePath.getParent();
                        netName = coverNet.getName();
                        String fullName = hp.getPath().getParent().getLast().getName() + "_" + netName;
                        Net interfaceNet = DieDecorator.netmapChildToParent(interfaceDevicePath.getDeviceTemplate(), fullName, coverDevice, coverNet);
                        DieDecorator.netmapChildToParent(dieDevicePath.getDeviceTemplate(), fullName, interfaceDevicePath.getLast(), interfaceNet);
                        continue;
                    }
                    String powerName = personality.getName();
                    Boolean isShorted = (Boolean)personality.getValue("RatioDrivenShorted");
                    if (Boolean.TRUE.equals(isShorted)) {
                        Net.getOrCreate((DeviceTemplate)dieTemplate, (String)powerName);
                        NetMap.mapThroughPath((DevicePath)((DevicePath)hp.first), (Net)pt.getNet(), (String)powerName);
                        continue;
                    }
                    String dieNetName = coverDevice.getName() + "_" + powerName;
                    Net.getOrCreate((DeviceTemplate)dieTemplate, (String)dieNetName);
                    NetMap.mapThroughPath((DevicePath)((DevicePath)hp.first), (Net)pt.getNet(), (String)dieNetName);
                }
                ++seqNum;
            }
            Net.deleteImmaterialNets((Db)dieTemplate.getDb(), (boolean)false);
            OrbitIO.getApp().refreshCurrentView(false);
        }

        static class SeqPin {
            HierPort hp;
            int seq;

            public SeqPin(HierPort hp, int seq) {
                this.hp = hp;
                this.seq = seq;
            }
        }

        public class OSorter
        implements Comparator<DevicePath> {
            int o;

            public OSorter(int o) {
                this.o = IOViewMakeDieNets.toAlternateOctant(o);
            }

            @Override
            public int compare(DevicePath d0, DevicePath d1) {
                long x0 = IOViewMakeDieNets.this.getDeviceLocationOnEdge(d0).getX();
                long y0 = IOViewMakeDieNets.this.getDeviceLocationOnEdge(d0).getY();
                long x1 = IOViewMakeDieNets.this.getDeviceLocationOnEdge(d1).getX();
                long y1 = IOViewMakeDieNets.this.getDeviceLocationOnEdge(d1).getY();
                if (this.o == 1 || this.o == 6) {
                    return Long.compare(y1, y0);
                }
                if (this.o == 2 || this.o == 5) {
                    return Long.compare(y0, y1);
                }
                if (this.o == 3 || this.o == 8) {
                    return Long.compare(x0, x1);
                }
                if (this.o == 4 || this.o == 7) {
                    return Long.compare(x1, x0);
                }
                return 0;
            }
        }
    }

    public static class MakeNetsOnCoverCells
    implements IOViewDieDecorator {
        @Override
        public boolean decorate() {
            DeviceTemplate dieTemplate = IOView.theIOView.getRootDevicePath().getDeviceTemplate();
            this.createNetsOnBumps(dieTemplate);
            return true;
        }

        @Override
        public String toolTip() {
            return "<html>Make Net Names based on location<br> for all bumps</html>";
        }

        @Override
        public String name() {
            return "Create Default Net Name on Bumps";
        }

        public void createNetsOnBumps(DeviceTemplate dieTemplate) {
            String bumpNetName = "BumpNet";
            Net.deleteImmaterialNets((Db)dieTemplate.getDb(), (boolean)false);
            for (DevicePath coverDevicePath : IOView.getDevicesInSequence()) {
                Device coverDevice = coverDevicePath.getLast();
                if (!DieDecorator.isNonFixedCoverDevice(coverDevice)) continue;
                DeviceTemplate coverTemplate = coverDevice.getTemplate();
                List<HierPort> sortedPins = DieDecorator.getSortedChildBumpPins(coverDevice);
                int ith = 0;
                boolean p = false;
                for (HierPort hp : sortedPins) {
                    Device bumpDevice = ((DevicePath)hp.first).getLast();
                    PinTemplate pt = ((PortTemplate)hp.second).getPinTemplate();
                    Net bumpNet = Net.getOrCreate((DeviceTemplate)((DevicePath)hp.first).getDeviceTemplate(), (String)"BumpNet");
                    pt.setNet(bumpNet);
                    PinInstance pi = PinInstance.getPinInstance((Device)bumpDevice, (PinTemplate)pt);
                    Personality personality = pi.getPersonality();
                    if (personality == null) continue;
                    Object netName = personality.getName();
                    if ("signal".equalsIgnoreCase((String)netName)) {
                        String nOrP = p ? "p" : "n";
                        netName = "io_" + ith + nOrP;
                        if (p) {
                            ++ith;
                            p = false;
                        } else {
                            p = true;
                        }
                        pi.setPinInstanceName((String)netName);
                        DieDecorator.netmapChildToParent(coverTemplate, (String)netName, ((DevicePath)hp.first).getLast(), bumpNet);
                        continue;
                    }
                    String powerName = personality.getName();
                    DieDecorator.netmapChildToParent(coverTemplate, powerName, ((DevicePath)hp.first).getLast(), bumpNet);
                }
            }
            Net.deleteImmaterialNets((Db)dieTemplate.getDb(), (boolean)false);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    public static class MakeDieNets
    implements ColViewDecorator {
        @Override
        public boolean decorate() {
            DeviceTemplate dieTemplate = ColView.TheColView.getDieTemplate();
            ArrayList<ColData> columns = ColView.TheColView.getColumns();
            this.createNetsOnBumps(dieTemplate, columns);
            return true;
        }

        @Override
        public String toolTip() {
            return "<html>Promote cell nets to the die, makeing them unique. <br>No nets on the cell will be changed</html>";
        }

        @Override
        public String name() {
            return "Make Die Nets";
        }

        public void createNetsOnBumps(DeviceTemplate dieTemplate, ArrayList<ColData> columns) {
            String bumpNetName = "BumpNet";
            Net.deleteImmaterialNets((Db)dieTemplate.getDb(), (boolean)false);
            for (ColData cd : columns) {
                for (Device coverDevice : cd) {
                    if (!DieDecorator.isNonFixedCoverDevice(coverDevice)) continue;
                    List<HierPort> sortedBumpPins = DieDecorator.getSortedChildBumpPins(coverDevice);
                    for (HierPort hp : sortedBumpPins) {
                        PinInstance pi;
                        Personality personality;
                        Device bumpDevice = ((DevicePath)hp.first).getLast();
                        PinTemplate pt = ((PortTemplate)hp.second).getPinTemplate();
                        Net bumpNet = Net.get((DeviceTemplate)((DevicePath)hp.first).getDeviceTemplate(), (String)"BumpNet");
                        if (Net.isNullOrUnusedNet((Net)bumpNet) || (personality = (pi = PinInstance.getPinInstance((Device)bumpDevice, (PinTemplate)pt)).getPersonality()) == null) continue;
                        String netName = personality.getName();
                        Net coverNet = NetMap.getParentNet((Device)bumpDevice, (Net)bumpNet);
                        if (Net.isNullOrUnusedNet((Net)coverNet)) continue;
                        if (coverNet.getName().equals("clk")) {
                            ALog.logInfo((String)"");
                        }
                        String coverDeviceName = coverDevice.getName();
                        if ("signal".equalsIgnoreCase(netName)) {
                            netName = coverNet.getName();
                            String fullName = coverDeviceName + "_" + netName;
                            DieDecorator.netmapChildToParent(dieTemplate, fullName, coverDevice, coverNet);
                            continue;
                        }
                        String powerName = personality.getName();
                        Boolean isShorted = (Boolean)personality.getValue("RatioDrivenShorted");
                        if (Boolean.TRUE.equals(isShorted)) {
                            DieDecorator.netmapChildToParent(dieTemplate, powerName, coverDevice, coverNet);
                            continue;
                        }
                        String dieNetName = coverDevice.getName() + "_" + powerName;
                        DieDecorator.netmapChildToParent(dieTemplate, dieNetName, coverDevice, coverNet);
                    }
                }
            }
            Net.deleteImmaterialNets((Db)dieTemplate.getDb(), (boolean)false);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    public static class RemakeAllNets
    implements ColViewDecorator {
        @Override
        public boolean decorate() {
            DeviceTemplate dieTemplate = ColView.TheColView.getDieTemplate();
            ArrayList<ColData> columns = ColView.TheColView.getColumns();
            this.createNetsOnBumps(dieTemplate, columns);
            return true;
        }

        @Override
        public String toolTip() {
            return "<html>Make Net Names based on location<br> for all bumps</html>";
        }

        @Override
        public String name() {
            return "Regenerate All Nets";
        }

        private static void mapUpPGBumpNet(DeviceTemplate coverTemplate, Device coverDevice, Personality personality, HierPort hp, Net bumpNet, DeviceTemplate dieTemplate) {
            String pgNetName = personality.getName();
            Boolean isShorted = (Boolean)personality.getValue("RatioDrivenShorted");
            if (Boolean.TRUE.equals(isShorted)) {
                Net coverNet = DieDecorator.netmapChildToParent(coverTemplate, pgNetName, ((DevicePath)hp.first).getLast(), bumpNet);
                DieDecorator.netmapChildToParent(dieTemplate, pgNetName, coverDevice, coverNet);
            } else {
                Net coverNet = DieDecorator.netmapChildToParent(coverTemplate, pgNetName, ((DevicePath)hp.first).getLast(), bumpNet);
                String dieNetName = coverDevice.getName() + "_" + pgNetName;
                DieDecorator.netmapChildToParent(dieTemplate, dieNetName, coverDevice, coverNet);
            }
        }

        public void createNetsOnBumps(DeviceTemplate dieTemplate, ArrayList<ColData> columns) {
            String bumpNetName = "BumpNet";
            Net.deleteImmaterialNets((Db)dieTemplate.getDb(), (boolean)false);
            for (ColData cd : columns) {
                for (Device coverDevice : cd) {
                    if (!DieDecorator.isNonFixedCoverDevice(coverDevice)) continue;
                    DeviceTemplate coverTemplate = coverDevice.getTemplate();
                    List<HierPort> sortedBumpPins = DieDecorator.getSortedChildBumpPins(coverDevice);
                    int ith = 0;
                    boolean p = false;
                    for (HierPort hp : sortedBumpPins) {
                        Device bumpDevice = ((DevicePath)hp.first).getLast();
                        PinTemplate pt = ((PortTemplate)hp.second).getPinTemplate();
                        DeviceTemplate bumpTemplate = ((DevicePath)hp.first).getDeviceTemplate();
                        Net bumpNet = Net.getOrCreate((DeviceTemplate)bumpTemplate, (String)"BumpNet");
                        pt.setNet(bumpNet);
                        PinInstance pi = PinInstance.getPinInstance((Device)bumpDevice, (PinTemplate)pt);
                        Personality personality = pi.getPersonality();
                        if (personality == null) continue;
                        Object netName = personality.getName();
                        if ("signal".equalsIgnoreCase((String)netName)) {
                            String nOrP = p ? "p" : "n";
                            netName = "io_" + ith + nOrP;
                            if (p) {
                                ++ith;
                                p = false;
                            } else {
                                p = true;
                            }
                            pi.setPinInstanceName((String)netName);
                            String deviceName = coverDevice.getName();
                            Net coverNet = DieDecorator.netmapChildToParent(coverTemplate, (String)netName, ((DevicePath)hp.first).getLast(), bumpNet);
                            String fullName = deviceName + "_" + (String)netName;
                            DieDecorator.netmapChildToParent(dieTemplate, fullName, coverDevice, coverNet);
                            continue;
                        }
                        RemakeAllNets.mapUpPGBumpNet(coverTemplate, coverDevice, personality, hp, bumpNet, dieTemplate);
                    }
                }
            }
            Net.deleteImmaterialNets((Db)dieTemplate.getDb(), (boolean)false);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }
}

