/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.decorators;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.AOctagon;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.decorators.BumpDecoratorDlg;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.iov.IOViewBlock;
import com.sigrity.orbit.iov.IOViewDecorator;
import com.sigrity.orbit.ui.wb_route.RouterInterface;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;

public class InteractiveBumpFactory
extends IOViewDecorator {
    LinkedList<DevicePath> originalDevices = new LinkedList();
    LinkedList<Device> addedDevices = new LinkedList();

    @Override
    public void decorate() {
        if (this.input.size() == 0) {
            return;
        }
        for (IOViewBlock b : this.input) {
            this.originalDevices.add(b.getDevicePath());
        }
        DevicePath interfacePath = ((IOViewBlock)this.input.get(0)).getParent().getDevicePath().getParent();
        DoThisDecorate callback = new DoThisDecorate();
        BumpDecoratorDlg dlg = BumpDecoratorDlg.createDialog(OrbitIO.getMainWindow(), interfacePath, callback);
        dlg.setVisible(true);
        for (DevicePath macroPath : this.originalDevices) {
            IOViewBlock macro = IOViewBlock.findBlockOfName(macroPath.toString());
            this.copyToOutput(macro);
        }
        for (Device added : this.addedDevices) {
            this.addToOutput(added, added.getName(), added.getTemplate().getName(), 0L, 0L);
        }
        ALog.logInfo((String)"done");
    }

    static String makeANetNameFromIOPort(HierPin ioPort) {
        String netName = ioPort.getPath().getParent().getLast().getName() + "_" + ioPort.getPath().getLast().getName() + "_" + ioPort.getPin().getName();
        return netName;
    }

    public static class HorizontalIOPadSorter
    implements Comparator<HierPin> {
        RouterInterface.SortType mT;
        ARect mDieRect = null;

        @Override
        public int compare(HierPin io0, HierPin io1) {
            HierPin p0 = new HierPin(new DevicePath(io0.getPath().getLast()), io0.getPin());
            HierPin p1 = new HierPin(new DevicePath(io1.getPath().getLast()), io1.getPin());
            return Long.compare(p0.getWorldLoc().getX(), p1.getWorldLoc().getX());
        }
    }

    class DoThisDecorate
    implements BumpDecoratorDlg.DoDecorate {
        Db db = OrbitIO.getCurDb();
        long ds = Design.micronToInternal((Db)this.db, (double)85.0);
        long startDx = 0L;
        long startDy = 0L;
        long maxXDist = Design.micronToInternal((Db)this.db, (double)2000.0);
        long bumpDiameter = Design.micronToInternal((Db)this.db, (double)64.0);
        long bumpToIoPadDist = Design.micronToInternal((Db)this.db, (double)10.0);
        double scale = 1.0;
        boolean stagger = false;
        boolean oppositeStagger = false;
        int maxRows = 5;
        int extraRows = 0;
        Layer bumpLayer = null;
        Unit unit;
        boolean createBumpDevices = false;
        int staggerRepeatSize = 0;
        boolean repeat = true;
        boolean bySequence = true;
        String delim = "@";
        boolean align = false;
        boolean adaptive = false;
        LinkedList<ToSignalRatio> ratioMap = new LinkedList();
        Device interfaceDevice;
        Device dieDevice;
        DeviceTemplate coverTemplate;
        Device coverCell;
        DeviceTemplate bumpTemplate;
        PadTemplate padTemplateForBump;
        ARect coverCellRect = new ARect(0L, 0L, 0L, 0L);

        public DoThisDecorate() {
            this.unit = OrbitIO.getCurDesign().getUnit();
        }

        public void setOppositeStagger(boolean oppositeStagger) {
            this.oppositeStagger = oppositeStagger;
        }

        public void setStaggerRepeat(int repeatSize) {
            this.staggerRepeatSize = repeatSize;
        }

        public void setMaxXDist(double d) {
            this.maxXDist = this.unit.fromUser(d);
        }

        public void setMaxRows(int rows) {
            this.maxRows = rows;
        }

        public void setScale(double scale) {
            this.scale = scale;
        }

        public void setNoRepeat() {
            this.repeat = false;
        }

        public void setAlign(boolean align) {
            this.align = align;
        }

        public void setAdaptive(boolean adaptive) {
            this.adaptive = adaptive;
        }

        public void createBumpDevices(boolean mode) {
            this.createBumpDevices = mode;
        }

        protected ARect getIOPadRect(PinInstance ioPin, DevicePath path) {
            AffineTransform t = path.getTransform();
            PinTemplate ioPinTemplate = ioPin.getPinTemplate();
            ARect bounds = null;
            for (PortTemplate portTmplt : ioPinTemplate.getPortTemplates()) {
                ARect r;
                PadTemplate pt;
                AffineTransform xform = portTmplt.getTransform();
                if (xform != null) {
                    xform.preConcatenate(t);
                } else {
                    xform = t;
                }
                if ((pt = portTmplt.getPadTemplate()) == null || (r = pt.getBounds(null)) == null) continue;
                r = r.transform(xform).getBounds();
                if (bounds == null) {
                    bounds = r;
                    continue;
                }
                bounds.expand(r);
            }
            return bounds;
        }

        @Override
        public void setBumpLayer(Layer layer) {
            this.bumpLayer = layer;
        }

        @Override
        public void setBumpDiameter(double d) {
            this.bumpDiameter = this.unit.fromUser(d);
        }

        @Override
        public void setMinPitch(double ds) {
            this.ds = this.unit.fromUser(ds);
        }

        @Override
        public void setStartDx(double dx) {
            this.startDx = this.unit.fromUser(dx);
        }

        @Override
        public void setStartDy(double dy) {
            this.startDy = this.unit.fromUser(dy);
        }

        @Override
        public void setStagger(boolean stagger) {
            this.stagger = stagger;
        }

        @Override
        public void addRatio(String name, int r) {
            ToSignalRatio tsr = new ToSignalRatio();
            tsr.name = name;
            tsr.ratio = r;
            this.ratioMap.add(tsr);
        }

        @Override
        public void start() {
            this.ratioMap.clear();
        }

        @Override
        public void decorateCallBack() {
            if (this.scale != 1.0) {
                ALog.logInfo((String)("All dimensions will be scaled by " + this.scale));
                this.startDx = (long)((double)this.startDx * this.scale);
                ALog.logInfo((String)("startDx " + this.startDx));
                this.startDy = (long)((double)this.startDy * this.scale);
                ALog.logInfo((String)("startDy " + this.startDy));
                this.ds = (long)((double)this.ds * this.scale);
                ALog.logInfo((String)("pitch " + this.ds));
                this.bumpDiameter = (long)((double)this.bumpDiameter * this.scale);
                ALog.logInfo((String)("Bump Diameter " + this.bumpDiameter));
            }
            this.doAdaptive();
            OrbitIO.getApp().refreshCurrentView(true);
        }

        protected void doAdaptive() {
            InteractiveBumpFactory.this.addedDevices.clear();
            this.interfaceDevice = InteractiveBumpFactory.this.originalDevices.get(0).getParent().getLast();
            this.dieDevice = InteractiveBumpFactory.this.originalDevices.get(0).pathToLowestDie().getLast();
            this.coverCellRect = new ARect(this.interfaceDevice.getTemplate().getBB());
            for (DevicePath macroPath : InteractiveBumpFactory.this.originalDevices) {
                int totalSignalPads;
                Device theMacroDevice = macroPath.getLast();
                ArrayList<HierPin> ioPortList = new ArrayList<HierPin>();
                if (theMacroDevice.getType() == DeviceTemplate.Type.COVER) continue;
                DeviceTemplate dt = theMacroDevice.getTemplate();
                HashSet ioPorts = new HashSet(dt.getIOPorts());
                for (PinInstance pi : theMacroDevice.getPins()) {
                    PinTemplate thisPinTemplate = pi.getPinTemplate();
                    if (!ioPorts.contains(thisPinTemplate)) continue;
                    ioPortList.add(new HierPin(macroPath, pi));
                }
                DevicePath coverCellPath = this.getOrMakeCoverCell(this.interfaceDevice, theMacroDevice);
                int totalBumps = totalSignalPads = ioPortList.size();
                ALog.logInfo((String)("There are a total of " + totalSignalPads + " signal bumps"));
                for (ToSignalRatio tsr : this.ratioMap) {
                    int thisAdd;
                    tsr.result = thisAdd = totalSignalPads / tsr.ratio;
                    ALog.logInfo((String)(tsr.name + " adding " + thisAdd + " bumps to " + theMacroDevice.getName()));
                    totalBumps += thisAdd;
                }
                ALog.logInfo((String)("There are a total of " + totalBumps + " bumps"));
                Device coverCell = coverCellPath.getLast();
                this.populateWithBumps(coverCell, ioPortList, totalBumps);
                InteractiveBumpFactory.this.addedDevices.add(coverCell);
            }
        }

        protected void populateWithBumps(Device coverCell, ArrayList<HierPin> ioPortList, int number) {
            long dx = this.ds;
            long dy = this.ds;
            this.makeTheBumpTemplate(coverCell);
            long step = Design.micronToInternal((Db)this.db, (double)1.0);
            ARect r = coverCell.getTemplate().getBB();
            long numCol = r.width() / dx;
            if (numCol * dx < r.width()) {
                ++numCol;
            }
            long maxLen = this.startDx + (numCol - 1L) * dx;
            if (this.stagger) {
                maxLen += dx / 2L;
            }
            if ((maxLen += this.bumpDiameter / 2L) > r.width()) {
                --numCol;
            }
            maxLen = this.startDx + (numCol - 1L) * dx;
            if (this.stagger) {
                maxLen += dx / 2L;
            }
            maxLen += this.bumpDiameter / 2L;
            while (maxLen < r.width()) {
                maxLen = this.startDx + (numCol - 1L) * (dx += step);
                if (this.stagger) {
                    maxLen += dx / 2L;
                }
                maxLen += this.bumpDiameter / 2L;
            }
            dx -= step;
            long numRow = (long)number / numCol;
            if (numCol * numRow < (long)number) {
                ++numRow;
            }
            maxLen = this.startDy + (numRow - 1L) * dy;
            if ((maxLen += this.bumpDiameter / 2L) > r.height()) {
                --numRow;
            }
            maxLen = this.startDy + (numRow - 1L) * dy;
            maxLen += this.bumpDiameter / 2L;
            while (maxLen < r.height()) {
                maxLen = this.startDy + (numRow - 1L) * (dy += step);
                maxLen += this.bumpDiameter / 2L;
            }
            ALog.logInfo((String)("Derived Parameters for " + coverCell.getName()));
            ALog.logInfo((String)("Derived x pitch of " + this.unit.toUserStr(dx)));
            ALog.logInfo((String)("Derived y pitch of " + this.unit.toUserStr(dy -= step)));
            ALog.logInfo((String)("Rows: " + numRow + " Cols: " + numCol));
            long x = this.startDx;
            long y = this.startDy;
            LinkedList<DevicePath> addedBumps = new LinkedList<DevicePath>();
            int bumpNum = 0;
            int row = 0;
            while ((long)row < numRow) {
                if (row % 2 != 0 && this.stagger) {
                    x += dx / 2L;
                }
                int col = 0;
                while ((long)col < numCol) {
                    addedBumps.add(this.addBumpAt(x, y, "bump" + bumpNum++, "NetUnused"));
                    x += dx;
                    ++col;
                }
                x = this.startDx;
                y += dy;
                ++row;
            }
            Collections.sort(this.ratioMap);
            Personality.resetColor();
            LinkedList<DevicePath> free = new LinkedList<DevicePath>();
            free.addAll(addedBumps);
            for (ToSignalRatio tsr : this.ratioMap) {
                Personality p = Personality.getOrCreate((DeviceTemplate)coverCell.getTemplate(), (Personality.Type)Personality.Type.PORT, (String)tsr.name);
                Color c = AUtil.colorFromString((String)Personality.nextColor());
                p.setColor(c);
                for (int i = 0; i < tsr.result; ++i) {
                    DevicePath freePath = null;
                    while (freePath == null) {
                        DevicePath best = null;
                        long bestDist = 0L;
                        for (DevicePath candidate : free) {
                            long dist = candidate.getLast().getLoc().getY();
                            if (best != null && dist <= bestDist) continue;
                            best = candidate;
                            bestDist = dist;
                        }
                        freePath = best;
                        PinInstance pi = freePath.getLast().getPinByName("BUMP");
                        if (pi.getPersonality() == null) {
                            pi.assignToPersonality(p);
                            free.remove(best);
                            continue;
                        }
                        freePath = null;
                    }
                }
            }
        }

        protected void makeTheBumpTemplate(Device coverCell) {
            Substrate s = coverCell.getSubstrate();
            AGrid grid = null;
            NamedGrid ng = NamedGrid.get((Substrate)s, (String)"Manufacturing Grid");
            grid = ng != null ? ng.getGrid() : new AGrid(5L, 5L, 0L, 0L);
            String bumpName = "BUMP" + this.bumpDiameter;
            this.bumpTemplate = DeviceTemplate.getDeviceTemplate((Substrate)s, (String)bumpName);
            if (this.bumpTemplate == null) {
                this.bumpTemplate = DeviceTemplate.create((Substrate)s, (String)bumpName, (boolean)true);
                this.bumpTemplate.setType(DeviceTemplate.Type.BUMP);
                this.bumpTemplate.setBounds((AGeom)new AOctagon(this.bumpDiameter / 2L, grid));
                this.bumpTemplate.setIsSynthesized(true);
                PinTemplate pt = PinTemplate.create((Net)this.bumpTemplate.getNetUnused(), (String)"BUMP");
                this.padTemplateForBump = PadTemplate.create((Db)this.db, (Substrate)pt.getSubstrate(), (String)"CoverBump");
                AOctagon padShape = new AOctagon(this.bumpDiameter / 2L, grid);
                LayerShape.create((Db)OrbitIO.getCurDb(), (Layer)this.bumpLayer, (DbObject)this.padTemplateForBump, (AGeom)padShape);
                pt.setPadTemplate(this.padTemplateForBump);
                pt.setType(PinTemplate.Type.BUMPPAD);
            }
        }

        protected DevicePath getOrMakeCoverCell(Device interfaceDevice, Device macroDevice) {
            String macroName = macroDevice.getName();
            String deviceName = "CoverFor" + macroName;
            Substrate s = interfaceDevice.getSubstrate();
            Device coverDevice = interfaceDevice.getTemplate().getChild(deviceName);
            if (coverDevice != null) {
                DeviceTemplate dt = coverDevice.getTemplate();
                coverDevice.deleteFromDb();
                dt.deleteFromDb();
            }
            this.coverTemplate = DeviceTemplate.create((Substrate)s, (String)deviceName, (boolean)true);
            this.coverTemplate.setType(DeviceTemplate.Type.COVER);
            this.coverTemplate.setBounds(macroDevice.getTemplate().getBounds());
            coverDevice = Device.create((Db)this.db, (String)deviceName, (DeviceTemplate)this.coverTemplate, (DeviceTemplate)interfaceDevice.getTemplate());
            coverDevice.setLoc(new APoint2D(macroDevice.getLoc()));
            coverDevice.setSynthesized(true);
            this.coverTemplate.setIsSynthesized(true);
            return coverDevice.getADevicePath();
        }

        protected DevicePath addBumpAt(long x, long y, String bumpName, String bumpNetName) {
            Device thisBumpDevice = Device.create((Db)this.db, (String)bumpName, (DeviceTemplate)this.bumpTemplate, (DeviceTemplate)this.coverTemplate);
            DevicePath bumpPath = new DevicePath(this.dieDevice);
            bumpPath.add(this.interfaceDevice);
            bumpPath.add(this.coverCell);
            bumpPath.add(thisBumpDevice);
            thisBumpDevice.setLoc(new APoint2D(x, y));
            return bumpPath;
        }

        public class ToSignalRatio
        implements Comparable<ToSignalRatio> {
            String name;
            int ratio;
            int result;

            @Override
            public int compareTo(ToSignalRatio a) {
                return this.ratio - a.ratio;
            }
        }
    }
}

