/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.decorators;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.iov.IOView;
import com.sigrity.orbit.iov.IOViewBlock;
import com.sigrity.orbit.iov.IOViewDecorator;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class PowerInsertionDecorator
extends IOViewDecorator {
    ArrayList<ConsumePattern> consumePatterns = new ArrayList();
    private ArrayList<IOViewBlock> workingBuffer = new ArrayList();

    public void addConsumePattern(String candidatePattern, String insertTemplateName, String pinName, String netName, String baseName, int num) {
        ConsumePattern cp = new ConsumePattern(candidatePattern, insertTemplateName, pinName, netName, baseName, num);
        this.consumePatterns.add(cp);
    }

    @Override
    public void decorate() {
        for (IOViewBlock iovb : this.input) {
            this.workingBuffer.add(iovb);
        }
        for (ConsumePattern cp : this.consumePatterns) {
            this.doPattern(cp);
        }
        for (IOViewBlock iovb : this.workingBuffer) {
            this.copyToOutput(iovb);
        }
    }

    protected void doPattern(ConsumePattern cp) {
        int count = 0;
        int unique = 0;
        ArrayList<IOViewBlock> tempBuffer = new ArrayList<IOViewBlock>();
        Pattern matchPattern = Pattern.compile(cp.matchPattern);
        for (IOViewBlock iovb : this.workingBuffer) {
            tempBuffer.add(iovb);
            if (iovb.getDevicePath().getLast().getSourceType() == Device.SourceType.DECORATOR) continue;
            String templateName = iovb.getDevicePath().getLast().getTemplate().getName();
            if (matchPattern.matcher(templateName).matches()) {
                Substrate s;
                if (++count % cp.num != 0 || (s = IOView.theIOView.getRootDevicePath().getSubstrate()) == null) continue;
                DeviceTemplate dt = DeviceTemplate.get((Db)OrbitIO.getCurDb(), (String)s.getName(), (String)cp.insertTemplateName);
                if (dt == null) {
                    ALog.logWarn((String)("A DeviceTemplate of the name " + cp.insertTemplateName), (Object[])new Object[]{" could not be found."});
                    continue;
                }
                PinTemplate pt = dt.getPinByName(cp.pinName);
                if (pt == null) {
                    ALog.logWarn((String)("A PinTemplate name of " + cp.pinName + " was specified and no such pin name exist on the DeviceTemplate " + cp.insertTemplateName));
                    continue;
                }
                IOViewBlock b = this.makeBlock(cp.baseName + unique++, cp.insertTemplateName);
                DevicePath devicePath = b.getDevicePath();
                Device d = devicePath.getLast();
                d.assignToPersonality(this.workingBuffer.get(0).getDevicePath().getLast().getPersonality());
                d.setSourceType(Device.SourceType.DECORATOR);
                PinInstance port = d.getPinByName(cp.pinName);
                if ("NetUnused".equals(cp.netName)) {
                    port.setNet(port.getDeviceTemplate().getNetUnused());
                } else {
                    NetMap.mapThroughPath((DevicePath)devicePath, (PinInstance)port, (String)cp.netName);
                }
                port.setNetSetterType(PinInstance.NetSetterType.DECORATOR);
                tempBuffer.add(b);
                continue;
            }
            ALog.logInfo((String)("Ignoring " + templateName));
        }
        this.workingBuffer.clear();
        this.workingBuffer.addAll(tempBuffer);
    }

    static class ConsumePattern {
        String matchPattern;
        String insertTemplateName;
        String pinName;
        String netName;
        String baseName;
        int num;

        public ConsumePattern(String matchPattern, String insertPattern, String pinName, String netName, String baseName, int num) {
            this.matchPattern = matchPattern;
            this.insertTemplateName = insertPattern;
            this.pinName = pinName;
            this.netName = netName;
            this.baseName = baseName;
            this.num = num;
        }
    }
}

